/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.diagram.custom.move;

import com.indy.md.ui.diagram.Messages;
import com.indy.md.ui.diagram.custom.move.MdNodeRefactorer;
import com.indy.md.ui.diagram.custom.move.MoveDialog;
import com.indy.ui.custom.out.CustomInternalWorksapceJob;
import com.indy.ui.custom.out.HistoryRestorationHelper;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.stambia.md.MdNode;
import com.stambia.md.diagram.navigator.MdDomainNavigatorItem;
import com.stambia.md.presentation.MdEditorPlugin;
import com.stambia.tech.Level;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;

public class MoveHandler
extends AbstractHandler {
    private Logger logger = LogManager.getLogger(MoveHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection s = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ArrayList<EObject> selectedMdNode = new ArrayList<EObject>();
        Level lvl = null;
        if (!this.allowClosedProject()) {
            return null;
        }
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.setURIConverter((URIConverter)new InternalResourceURIConverter());
        if (s instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)s;
            for (Object o : ss.toList()) {
                EObject node = rs.getEObject(EcoreUtil.getURI((EObject)((MdDomainNavigatorItem)((Object)o)).getEObject()), true);
                selectedMdNode.add(node);
                if (lvl == null) {
                    lvl = ((MdNode)node.eContainer()).getLevel();
                    continue;
                }
                if (lvl == ((MdNode)node.eContainer()).getLevel()) continue;
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.MoveHandler_4, (String)Messages.MoveHandler_5);
                return null;
            }
        }
        selectedMdNode = new ArrayList(EcoreUtil.filterDescendants(selectedMdNode));
        MoveDialog d = new MoveDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), lvl);
        if (d.open() == 0) {
            final ArrayList<EObject> toMove = selectedMdNode;
            final URI targetURI = d.getResourceUri().appendFragment(d.getTargetURIFragment());
            AbstractOperation op = new AbstractOperation(Messages.MoveHandler_6, (ResourceSet)rs){
                private Set<URI> modifiedFiles;
                private final /* synthetic */ ResourceSet val$rs;
                {
                    this.val$rs = resourceSet;
                    super($anonymous0);
                    this.modifiedFiles = new HashSet<URI>();
                }

                public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    this.modifiedFiles.clear();
                    monitor.beginTask(Messages.MoveHandler_7, toMove.size());
                    HashMap<URI, URI> movedURIParent = new HashMap<URI, URI>();
                    HashSet<URI> uriToMove = new HashSet<URI>();
                    for (EObject n : toMove) {
                        URI toMoveParentUri = EcoreUtil.getURI((EObject)n.eContainer());
                        URI movingNodeUri = EcoreUtil.getURI((EObject)n);
                        movedURIParent.put(movingNodeUri, toMoveParentUri);
                        uriToMove.add(movingNodeUri);
                    }
                    if (monitor.isCanceled()) {
                        this.undo(monitor, info);
                    }
                    boolean autoBuild = HistoryRestorationHelper.setWorkspaceAutoBuild((boolean)false);
                    try {
                        try {
                            MdNodeRefactorer ref = new MdNodeRefactorer(uriToMove, targetURI);
                            for (URI movedURI : ref.execute()) {
                                this.modifiedFiles.add(movedURI);
                            }
                        }
                        catch (Exception ex) {
                            this.undo(monitor, info);
                            Status status = new Status(4, "com.indy.md.ui.diagram", Messages.MoveHandler_8 + ex.getMessage(), (Throwable)ex);
                            HistoryRestorationHelper.setWorkspaceAutoBuild((boolean)autoBuild);
                            return status;
                        }
                    }
                    finally {
                        HistoryRestorationHelper.setWorkspaceAutoBuild((boolean)autoBuild);
                    }
                    for (Resource r : this.val$rs.getResources()) {
                        if (r == null || !r.isLoaded()) continue;
                        r.unload();
                    }
                    return new Status(0, "com.indy.md.ui.diagram", Messages.MoveHandler_9);
                }

                public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    return this.execute(monitor, info);
                }

                public boolean canRedo() {
                    return false;
                }

                public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    HistoryRestorationHelper.scheduleRestoreFromHistory((String)Messages.MoveHandler_1, this.modifiedFiles.stream().map(Util::convertEMFURIToFile).filter(f -> f != null).toList(), (Logger)MoveHandler.this.logger);
                    return new Status(0, "com.indy.md.ui.diagram", Messages.MoveHandler_10);
                }
            };
            op.addContext(WorkspaceUndoUtil.getWorkspaceUndoContext());
            CustomInternalWorksapceJob job = new CustomInternalWorksapceJob(Messages.MoveHandler_1, op);
            job.setUser(true);
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            job.schedule();
        }
        return null;
    }

    private boolean allowClosedProject() {
        IPreferenceStore store = MdEditorPlugin.getPlugin().getPreferenceStore();
        if (!store.getBoolean("checkClosedProjectOnMove")) {
            return true;
        }
        MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.MoveHandler_11, null, Messages.MoveHandler_12 + Messages.MoveHandler_13, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        return dialog.open() == 0;
    }
}

