/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.diagram.navigator;

import com.indy.md.ui.diagram.Messages;
import com.indy.ui.custom.out.CustomResourceItemProviderAdapterFactory;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.common.Unloadable;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.md.diagram.custom.properties.CustomizedAdapterFactoryContentProvider;
import com.stambia.md.diagram.navigator.MdAbstractNavigatorItem;
import com.stambia.md.diagram.navigator.MdDomainNavigatorItem;
import com.stambia.md.diagram.part.MdDiagramEditorPlugin;
import com.stambia.tech.Level;
import com.stambia.tech.View;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class MdDomainNavigatorContentProvider
implements ICommonContentProvider,
Unloadable {
    private Logger logger = LogManager.getLogger(MdDomainNavigatorContentProvider.class);
    private AdapterFactoryContentProvider myAdapterFctoryContentProvier;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public MdDomainNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        editingDomain.getResourceSet().setURIConverter((URIConverter)new InternalResourceURIConverter());
        editingDomain.getResourceSet().getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        editingDomain.setID("com.indy.md.ui.diagram.EditingDomain");
        this.myAdapterFctoryContentProvier = new CustomizedAdapterFactoryContentProvider(MdDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory(), (EditingDomain)editingDomain);
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            @Override
            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                if (MdDomainNavigatorContentProvider.this.myViewer != null) {
                    MdDomainNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                for (Resource nextResource : MdDomainNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (MdDomainNavigatorContentProvider.this.myViewer != null) {
                    MdDomainNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(MdDomainNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                for (Resource nextResource : MdDomainNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (MdDomainNavigatorContentProvider.this.myViewer != null) {
                    MdDomainNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(MdDomainNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                for (Resource nextResource : MdDomainNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (MdDomainNavigatorContentProvider.this.myViewer != null) {
                    MdDomainNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(MdDomainNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }
        });
        ICommandService cmdService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (cmdService != null) {
            cmdService.addExecutionListener(new IExecutionListener(){

                public void preExecute(String commandId, ExecutionEvent event) {
                    if ("org.eclipse.ui.navigate.collapseAll".equals(commandId)) {
                        try {
                            String partId = HandlerUtil.getActivePartId((ExecutionEvent)event);
                            if (partId == null) {
                                partId = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite().getId();
                            }
                            if ("org.eclipse.ui.navigator.ProjectExplorer".equals(partId)) {
                                for (Resource r : MdDomainNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                                    r.unload();
                                }
                                MdDomainNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources().clear();
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }

                public void postExecuteSuccess(String commandId, Object returnValue) {
                }

                public void postExecuteFailure(String commandId, ExecutionException exception) {
                }

                public void notHandled(String commandId, NotHandledException exception) {
                }
            });
        }
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
        String version = (String)ResourcesPlugin.getPlugin().getBundle().getHeaders().get("Bundle-Version");
        if (this.myViewer != null && version.startsWith("3.4")) {
            Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
            Control myControl = this.myViewer.getControl();
            DragSource dragSource = (DragSource)myControl.getData("DragSource");
            dragSource.setTransfer(transfers);
            dragSource.addDragListener((DragSourceListener)new ViewerDragAdapter(this.myViewer));
            DropTarget dropTarget = (DropTarget)myControl.getData("DropTarget");
            dropTarget.setTransfer(transfers);
            dropTarget.addDropListener((DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.myEditingDomain, this.myViewer));
        } else {
            Control myControl = this.myViewer.getControl();
            DragSource dragSource = (DragSource)myControl.getData("DragSource");
            ArrayList<Transfer> l = new ArrayList<Transfer>(Arrays.asList(dragSource.getTransfer()));
            if (!l.contains(LocalTransfer.getInstance())) {
                l.add((Transfer)LocalTransfer.getInstance());
                dragSource.setTransfer(l.toArray(new Transfer[l.size()]));
            }
            l.clear();
            DropTarget dropTarget = (DropTarget)myControl.getData("DropTarget");
            l.addAll(Arrays.asList(dropTarget.getTransfer()));
            if (!l.contains(LocalTransfer.getInstance())) {
                l.add((Transfer)LocalTransfer.getInstance());
                dropTarget.setTransfer(l.toArray(new Transfer[l.size()]));
            }
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        Object val;
        Resource resource = null;
        URI resourceUri = null;
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            resourceUri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        } else if (parentElement instanceof TreeNode && (val = ((TreeNode)parentElement).getValue()) instanceof URI) {
            resourceUri = (URI)val;
        }
        if (resourceUri != null) {
            block7: {
                try {
                    resource = this.myEditingDomain.getResourceSet().getResource(resourceUri, true);
                }
                catch (Throwable ex) {
                    resource = this.myEditingDomain.getResourceSet().getResource(resourceUri, false);
                    if (resource != null) break block7;
                    MdDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "com.indy.md.ui.diagram", Messages.MdDomainNavigatorContentProvider_2 + ex.getMessage(), ex));
                }
            }
            return this.wrapEObjects(this.myAdapterFctoryContentProvier.getChildren((Object)resource), parentElement);
        }
        if (parentElement instanceof MdDomainNavigatorItem) {
            return this.wrapEObjects(this.myAdapterFctoryContentProvier.getChildren((Object)((MdDomainNavigatorItem)((Object)parentElement)).getEObject()), parentElement);
        }
        return EMPTY_ARRAY;
    }

    /*
     * WARNING - void declaration
     */
    public Object[] wrapEObjects(Object[] objects, Object parentElement) {
        void var5_9;
        ArrayList<MdDomainNavigatorItem> result = new ArrayList<MdDomainNavigatorItem>();
        MdDomainNavigatorItem nodeItem = null;
        if (parentElement instanceof MdDomainNavigatorItem) {
            nodeItem = (MdDomainNavigatorItem)((Object)parentElement);
        }
        if (nodeItem != null && nodeItem.getEObject() instanceof MdNode) {
            MdNode mdNode = (MdNode)nodeItem.getEObject();
            Level parentLevel = mdNode.getLevel();
            ArrayList<View> list = new ArrayList<View>();
            if (parentLevel != null) {
                for (View hier : parentLevel.getView()) {
                    if (nodeItem.hierarchicalCode != null) {
                        if (!hier.getCode().equals(nodeItem.hierarchicalCode)) continue;
                        list.add(hier);
                        break;
                    }
                    if (!hier.isRoot()) continue;
                    list.add(hier);
                }
            }
            for (View hier : list) {
                List children1;
                block22: {
                    boolean enable;
                    block21: {
                        boolean bl = enable = hier.getEnablementXpath() == null || hier.getEnablementXpath().isEmpty();
                        if (!enable) {
                            try {
                                enable = mdNode.evaluateMdBoolean(hier.getEnablementXpath());
                            }
                            catch (XPathExpressionException e) {
                                if (!this.logger.isDebugEnabled()) break block21;
                                this.logger.error("Failed to evaluate MdBoolean", (Throwable)e);
                            }
                        }
                    }
                    if (!enable) continue;
                    children1 = null;
                    if (hier.getXpath() != null && !hier.getXpath().isEmpty()) {
                        try {
                            children1 = (List)mdNode.evaluateMdSet(hier.getXpath());
                        }
                        catch (XPathExpressionException e) {
                            if (!this.logger.isDebugEnabled()) break block22;
                            this.logger.error("Failed to evaluate Md Set on {}", (Object)hier.getXpath(), (Object)e);
                        }
                    }
                }
                if (children1 == null || children1.size() <= 0) continue;
                if (hier.getLevelCode() != null && !hier.getLevelCode().isEmpty()) {
                    MdNode node = null;
                    for (MdNode n : ((MdNode)((MdDomainNavigatorItem)((Object)parentElement)).getEObject()).getNode()) {
                        if (!hier.getLevelCode().equals(n.getDefType())) continue;
                        node = n;
                        break;
                    }
                    if (node == null) {
                        node = MdFactory.eINSTANCE.createMdNode();
                        node.setDefType(hier.getLevelCode());
                        node.setSubstituteContainer(((MdDomainNavigatorItem)((Object)parentElement)).getEObject());
                        ((MdDomainNavigatorItem)((Object)parentElement)).getEObject().eSetDeliver(false);
                        ((MdNode)((MdDomainNavigatorItem)((Object)parentElement)).getEObject()).getNode().add((Object)node);
                        ((MdDomainNavigatorItem)((Object)parentElement)).getEObject().eSetDeliver(true);
                    }
                    MdDomainNavigatorItem dni = new MdDomainNavigatorItem((EObject)node, parentElement, (IPropertySourceProvider)this.myAdapterFctoryContentProvier);
                    dni.hierarchicalChildren = new ArrayList<WeakReference<EObject>>();
                    for (Object o : children1) {
                        if (!(o instanceof EObject)) continue;
                        dni.hierarchicalChildren.add(new WeakReference<EObject>((EObject)o));
                    }
                    dni.hierarchicalCode = hier.getCode();
                    result.add(dni);
                    continue;
                }
                for (Object o : children1) {
                    if (!(o instanceof EObject)) continue;
                    EObject eo = (EObject)o;
                    MdDomainNavigatorItem mdni = new MdDomainNavigatorItem(eo, parentElement, (IPropertySourceProvider)this.myAdapterFctoryContentProvier);
                    mdni.hierarchicalCode = nodeItem != null ? nodeItem.hierarchicalCode : null;
                    result.add(mdni);
                }
            }
        }
        if (nodeItem != null && nodeItem.hierarchicalChildren != null) {
            for (WeakReference weakReference : nodeItem.hierarchicalChildren) {
                EObject eo = (EObject)weakReference.get();
                if (eo == null) continue;
                MdDomainNavigatorItem mdni = new MdDomainNavigatorItem(eo, parentElement, (IPropertySourceProvider)this.myAdapterFctoryContentProvier);
                mdni.hierarchicalCode = nodeItem != null ? nodeItem.hierarchicalCode : null;
                result.add(mdni);
            }
        }
        boolean bl = false;
        while (var5_9 < objects.length) {
            if (objects[var5_9] instanceof EObject) {
                MdDomainNavigatorItem mdni = new MdDomainNavigatorItem((EObject)objects[var5_9], parentElement, (IPropertySourceProvider)this.myAdapterFctoryContentProvier);
                mdni.hierarchicalCode = nodeItem != null ? nodeItem.hierarchicalCode : null;
                result.add(mdni);
            }
            ++var5_9;
        }
        return result.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof MdAbstractNavigatorItem) {
            MdAbstractNavigatorItem abstractNavigatorItem = (MdAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        if (element instanceof MdDomainNavigatorItem) {
            Resource resource;
            MdDomainNavigatorItem i;
            block8: {
                i = (MdDomainNavigatorItem)((Object)element);
                if (i.getEObject() != null && !i.getEObject().eIsProxy()) {
                    if (i.getEObject().eContainer() instanceof EObject) {
                        return new MdDomainNavigatorItem(i.getEObject().eContainer(), null, (IPropertySourceProvider)this.myAdapterFctoryContentProvier);
                    }
                    URI resourceFileId = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(CacheHelper.extractFileID((EObject)i.getEObject()));
                    return Util.convertEMFURIToFile((URI)resourceFileId);
                }
                URI resourceFileId = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).findResourceURIByFileId(CacheHelper.extractFileID((EObject)i.getEObject()));
                resource = null;
                try {
                    resource = this.myEditingDomain.getResourceSet().getResource(resourceFileId, false);
                }
                catch (Throwable ex) {
                    resource = this.myEditingDomain.getResourceSet().getResource(resourceFileId, true);
                    if (resource != null) break block8;
                    MdDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "com.indy.md.ui.diagram", Messages.MdDomainNavigatorContentProvider_2 + ex.getMessage(), ex));
                }
            }
            if (resource != null) {
                EObject o = resource.getEObject(((InternalEObject)i.getEObject()).eProxyURI().fragment());
                if (o == null) {
                    return null;
                }
                return new MdDomainNavigatorItem(o.eContainer(), null, (IPropertySourceProvider)this.myAdapterFctoryContentProvier);
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }

    public void unload(Object[] eObjects) {
        Object[] objectArray = eObjects;
        int n = eObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof MdDomainNavigatorItem) {
                AdapterFactory specAf;
                Resource resource = ((MdDomainNavigatorItem)((Object)o)).getEObject().eResource();
                this.myEditingDomain.getResourceToReadOnlyMap().remove(resource);
                resource.unload();
                EcoreUtil.remove((EObject)((MdDomainNavigatorItem)((Object)o)).getEObject());
                EcoreUtil.delete((EObject)((MdDomainNavigatorItem)((Object)o)).getEObject(), (boolean)true);
                resource.getResourceSet().getResources().remove((Object)resource);
                AdapterFactory af = this.myAdapterFctoryContentProvier.getAdapterFactory();
                if (af instanceof ComposedAdapterFactory && (specAf = ((ComposedAdapterFactory)af).getFactoryForType((Object)resource)) instanceof CustomResourceItemProviderAdapterFactory) {
                    ((CustomResourceItemProviderAdapterFactory)specAf).dispose();
                }
            }
            ++n2;
        }
    }
}

