/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom;

import com.indy.gmf.proc.MetaDataLink;
import com.indy.gmf.proc.Parameter;
import com.indy.gmf.proc.XslVariable;
import com.indy.gmf.proc.diagram.non_rcp.custom.cpypaste.CustomClipboardSupportGlobalActionHandler;
import com.indy.gmf.proc.diagram.non_rcp.edit.parts.MetaDataLinkEditPart;
import com.indy.gmf.proc.diagram.non_rcp.edit.parts.ParameterEditPart;
import com.indy.gmf.proc.diagram.non_rcp.edit.parts.XslVariableEditPart;
import com.indy.gmf.proc.diagram.non_rcp.messages.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.providers.TopDownProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNode;
import org.eclipse.gmf.runtime.diagram.ui.services.layout.ILayoutNodeOperation;
import org.eclipse.gmf.runtime.draw2d.ui.graph.ConstrainedEdge;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class ProcessLayoutProvider
extends TopDownProvider {
    private int parameterMinY = Integer.MAX_VALUE;
    private int parameterX = 0;
    private int parameterMaxWidth = Integer.MIN_VALUE;
    private int mdLinkMaxWidth = Integer.MIN_VALUE;

    public boolean canLayoutNodes(List layoutNodes, boolean shouldOffsetFromBoundingBox, IAdaptable layoutHint) {
        if (!super.canLayoutNodes(layoutNodes, shouldOffsetFromBoundingBox, layoutHint)) {
            return !shouldOffsetFromBoundingBox || !layoutNodes.isEmpty();
        }
        return true;
    }

    protected void postProcessGraph(DirectedGraph g, Hashtable editPartToNodeDict) {
        super.postProcessGraph(g, editPartToNodeDict);
        ArrayList<ParameterEditPart> paramEditParts = new ArrayList<ParameterEditPart>();
        ArrayList<XslVariableEditPart> xlsVariables = new ArrayList<XslVariableEditPart>();
        ArrayList<MetaDataLinkEditPart> mdLinkEditParts = new ArrayList<MetaDataLinkEditPart>();
        for (Object o : editPartToNodeDict.keySet()) {
            if (editPartToNodeDict.get(o) == null) continue;
            boolean notLinked = false;
            if (o instanceof ParameterEditPart) {
                paramEditParts.add((ParameterEditPart)((Object)o));
                notLinked = true;
            } else if (o instanceof XslVariableEditPart) {
                xlsVariables.add((XslVariableEditPart)((Object)o));
                notLinked = true;
            } else if (o instanceof MetaDataLinkEditPart) {
                mdLinkEditParts.add((MetaDataLinkEditPart)((Object)o));
                notLinked = true;
            }
            if (!notLinked) continue;
            ((Node)editPartToNodeDict.get(o)).setPadding(new Insets(5, 5, 5, 5));
        }
        this.linkList(paramEditParts.iterator(), g, editPartToNodeDict);
        this.linkList(xlsVariables.iterator(), g, editPartToNodeDict);
        this.linkList(mdLinkEditParts.iterator(), g, editPartToNodeDict);
    }

    private void linkList(Iterator<EditPart> iterator, DirectedGraph g, Hashtable editPartToNodeDict) {
        EditPart cur = null;
        EditPart previous = null;
        while (iterator.hasNext()) {
            previous = cur;
            cur = iterator.next();
            if (previous == null) continue;
            Node source = (Node)editPartToNodeDict.get(cur);
            Node target = (Node)editPartToNodeDict.get(previous);
            if (source == null || target == null) continue;
            this.addEdge(g.edges, source, target);
        }
    }

    protected void createSubCommands(Point diff, ListIterator vi, CompoundCommand cc) {
        boolean isPasting = CustomClipboardSupportGlobalActionHandler.isPasting();
        while (vi.hasNext()) {
            Node node = (Node)vi.next();
            if (!(node.data instanceof ShapeEditPart)) continue;
            IGraphicalEditPart gep = (IGraphicalEditPart)node.data;
            Rectangle nodeExt = this.getNodeMetrics(node);
            PrecisionPoint ptLocation = new PrecisionPoint(nodeExt.preciseX() + diff.preciseX(), nodeExt.preciseY() + diff.preciseY());
            if (gep instanceof ParameterEditPart || gep instanceof XslVariableEditPart || gep instanceof MetaDataLinkEditPart) {
                if (gep instanceof ParameterEditPart) {
                    if (this.parameterMaxWidth >= nodeExt.width) continue;
                    this.parameterMaxWidth = nodeExt.width;
                    continue;
                }
                if (!(gep instanceof MetaDataLinkEditPart) || this.mdLinkMaxWidth >= nodeExt.width) continue;
                this.mdLinkMaxWidth = nodeExt.width;
                continue;
            }
            ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
            PrecisionPoint ptOldLocation = new PrecisionPoint(gep.getFigure().getBounds().getLocation());
            PrecisionPoint delta = new PrecisionPoint(ptLocation.preciseX() - ptOldLocation.preciseX() + 20.0, ptLocation.preciseY() - ptOldLocation.preciseY() + 20.0);
            if (isPasting) {
                delta = new PrecisionPoint(delta.y, -delta.x);
            }
            gep.getFigure().translateToAbsolute((Translatable)delta);
            request.setEditParts((EditPart)gep);
            request.setMoveDelta((Point)delta);
            request.setLocation((Point)ptLocation);
            Rectangle r = request.getTransformedRectangle(gep.getFigure().getBounds());
            this.parameterX = Math.max(this.parameterX, r.width + r.x);
            this.parameterMinY = Math.min(this.parameterMinY, r.y);
            Command cmd = gep.getCommand((Request)request);
            if (cmd == null || !cmd.canExecute()) continue;
            cc.add(cmd);
        }
        if (isPasting) {
            CustomClipboardSupportGlobalActionHandler.unsetPasting();
        }
    }

    protected Command createNodeChangeBoundCommands(DirectedGraph g, Point diff) {
        Command cmd;
        PrecisionPoint delta;
        PrecisionPoint ptOldLocation;
        ChangeBoundsRequest request;
        Rectangle nodeExt;
        PrecisionPoint ptLocation;
        IGraphicalEditPart gep;
        Node node;
        this.parameterMinY = Integer.MAX_VALUE;
        this.parameterX = 0;
        this.parameterMaxWidth = Integer.MIN_VALUE;
        CompoundCommand sc = (CompoundCommand)super.createNodeChangeBoundCommands(g, diff);
        Collections.sort(g.nodes, new NodeComparator());
        ListIterator vi = g.nodes.listIterator();
        int curY = 15;
        CompoundCommand cc = new CompoundCommand("");
        while (vi.hasNext()) {
            node = (Node)vi.next();
            if (!(node.data instanceof ShapeEditPart)) continue;
            gep = (IGraphicalEditPart)node.data;
            ptLocation = null;
            nodeExt = this.getNodeMetrics(node);
            if (gep instanceof ParameterEditPart) {
                ptLocation = new PrecisionPoint(this.parameterX + 15, curY);
                curY += nodeExt.getSize().height + 5;
                if (this.parameterMaxWidth < nodeExt.getSize().width) {
                    this.parameterMaxWidth = nodeExt.getSize().width;
                }
            }
            if (ptLocation == null) continue;
            request = new ChangeBoundsRequest((Object)"move");
            ptOldLocation = new PrecisionPoint(gep.getFigure().getBounds().getLocation());
            gep.getFigure().translateToAbsolute((Translatable)ptOldLocation);
            gep.getFigure().translateToAbsolute((Translatable)ptLocation);
            delta = new PrecisionPoint(ptLocation.preciseX() - ptOldLocation.preciseX(), ptLocation.preciseY() - ptOldLocation.preciseY());
            request.setEditParts((EditPart)gep);
            request.setMoveDelta((Point)delta);
            request.setLocation((Point)ptLocation);
            cmd = gep.getCommand((Request)request);
            if (cmd == null || !cmd.canExecute()) continue;
            cc.add(cmd);
        }
        vi = g.nodes.listIterator();
        if (this.parameterMaxWidth < 0) {
            this.parameterMaxWidth = 0;
        }
        curY = 15;
        while (vi.hasNext()) {
            node = (Node)vi.next();
            if (!(node.data instanceof ShapeEditPart)) continue;
            gep = (IGraphicalEditPart)node.data;
            ptLocation = null;
            nodeExt = this.getNodeMetrics(node);
            if (gep instanceof MetaDataLinkEditPart) {
                ptLocation = new PrecisionPoint(this.parameterX + 20 + this.parameterMaxWidth, curY);
                curY += nodeExt.getSize().height + 5;
            }
            if (ptLocation == null) continue;
            request = new ChangeBoundsRequest((Object)"move");
            ptOldLocation = new PrecisionPoint(gep.getFigure().getBounds().getLocation());
            gep.getFigure().translateToAbsolute((Translatable)ptOldLocation);
            gep.getFigure().translateToAbsolute((Translatable)ptLocation);
            delta = new PrecisionPoint(ptLocation.preciseX() - ptOldLocation.preciseX(), ptLocation.preciseY() - ptOldLocation.preciseY());
            request.setEditParts((EditPart)gep);
            request.setMoveDelta((Point)delta);
            request.setLocation((Point)ptLocation);
            cmd = gep.getCommand((Request)request);
            if (cmd == null || !cmd.canExecute()) continue;
            cc.add(cmd);
        }
        vi = g.nodes.listIterator();
        if (this.mdLinkMaxWidth < 0) {
            this.mdLinkMaxWidth = 0;
        }
        curY = 15;
        while (vi.hasNext()) {
            node = (Node)vi.next();
            if (!(node.data instanceof ShapeEditPart)) continue;
            gep = (IGraphicalEditPart)node.data;
            ptLocation = null;
            nodeExt = this.getNodeMetrics(node);
            if (gep instanceof XslVariableEditPart) {
                ptLocation = new PrecisionPoint(this.parameterX + 20 + this.parameterMaxWidth + 10 + this.mdLinkMaxWidth, curY);
                curY += nodeExt.getSize().height + 5;
            }
            if (ptLocation == null) continue;
            request = new ChangeBoundsRequest((Object)"move");
            ptOldLocation = new PrecisionPoint(gep.getFigure().getBounds().getLocation());
            gep.getFigure().translateToAbsolute((Translatable)ptOldLocation);
            gep.getFigure().translateToAbsolute((Translatable)ptLocation);
            delta = new PrecisionPoint(ptLocation.preciseX() - ptOldLocation.preciseX(), ptLocation.preciseY() - ptOldLocation.preciseY());
            request.setEditParts((EditPart)gep);
            request.setMoveDelta((Point)delta);
            request.setLocation((Point)ptLocation);
            cmd = gep.getCommand((Request)request);
            if (cmd == null || !cmd.canExecute()) continue;
            cc.add(cmd);
        }
        if (!cc.isEmpty()) {
            if (sc == null) {
                sc = new CompoundCommand();
            }
            sc.add((Command)cc);
        }
        return sc;
    }

    private void addEdge(EdgeList edges, Node source, Node target) {
        ConstrainedEdge edge = new ConstrainedEdge(null, source, target);
        int padding = 0;
        Rectangle.SINGLETON.x = 0;
        Rectangle.SINGLETON.y = 0;
        Rectangle.SINGLETON.width = padding;
        Rectangle.SINGLETON.height = padding;
        padding = Math.min(Math.max(Math.round((float)this.translateToGraph((Rectangle)Rectangle.SINGLETON).width * 1.5f), this.getMapMode().DPtoLP(15)), this.getMapMode().DPtoLP(90));
        edge.setPadding(0);
        edge.setDelta(Math.max(edge.getDelta(), 0));
        edges.add((Object)edge);
    }

    public boolean provides(IOperation operation) {
        if (operation instanceof ILayoutNodeOperation) {
            org.eclipse.gmf.runtime.notation.Node node;
            Diagram container;
            ListIterator nodes = ((ILayoutNodeOperation)operation).getLayoutNodes().listIterator();
            if (nodes.hasNext() && ((container = (node = ((ILayoutNode)nodes.next()).getNode()).getDiagram()) == null || !container.getType().equals("Proc"))) {
                return false;
            }
        } else {
            return false;
        }
        IAdaptable layoutHint = ((ILayoutNodeOperation)operation).getLayoutHint();
        String layoutType = (String)layoutHint.getAdapter(String.class);
        return "DEFAULT".equals(layoutType);
    }

    protected void buildGraph(DirectedGraph g, List selectedObjects) {
        Hashtable editPartToNodeDict = new Hashtable(500);
        this.minX = -1;
        this.minY = -1;
        NodeList nodes = this.buildNodes(selectedObjects, editPartToNodeDict, null);
        ArrayList objects = new ArrayList();
        objects.addAll(selectedObjects);
        objects.addAll(this.getRelevantConnections(editPartToNodeDict));
        EdgeList edges = this.buildEdges(objects, editPartToNodeDict);
        g.nodes = nodes;
        g.edges = edges;
        this.postProcessGraph(g, editPartToNodeDict);
    }

    public Command layoutEditParts(final GraphicalEditPart containerEditPart, IAdaptable layoutHint) {
        CompoundCommand cc = new CompoundCommand();
        cc.add(super.layoutEditParts(containerEditPart, layoutHint));
        TransactionalEditingDomain ed = TransactionUtil.getEditingDomain((EObject)((View)containerEditPart.getModel()));
        if (ed != null) {
            cc.add((Command)new ICommandProxy((ICommand)new AbstractTransactionalCommand(ed, Messages.ProcessLayoutProvider_2, null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    int minX = Integer.MAX_VALUE;
                    int minY = Integer.MAX_VALUE;
                    ArrayList<Bounds> l = new ArrayList<Bounds>();
                    for (Object o : containerEditPart.getChildren()) {
                        org.eclipse.gmf.runtime.notation.Node n;
                        Bounds b;
                        View v;
                        if (!(o instanceof EditPart) || !(((EditPart)o).getModel() instanceof View) || !((v = (View)((EditPart)o).getModel()) instanceof org.eclipse.gmf.runtime.notation.Node) || (b = (Bounds)(n = (org.eclipse.gmf.runtime.notation.Node)v).getLayoutConstraint()) == null) continue;
                        if (b.getX() < minX) {
                            minX = b.getX();
                        }
                        if (b.getY() < minY) {
                            minY = b.getY();
                        }
                        l.add(b);
                    }
                    for (Bounds b : l) {
                        if (minX > 0) {
                            b.setX(b.getX() - minX + 30);
                        }
                        if (minY <= 0) continue;
                        b.setY(b.getY() - minY + 30);
                    }
                    return CommandResult.newOKCommandResult();
                }
            }));
        }
        return cc;
    }

    private static class NodeComparator
    implements Comparator<Node> {
        private NodeComparator() {
        }

        protected String getNameString(EditPart arg0) {
            QName qName;
            String s = null;
            if (arg0 instanceof ParameterEditPart) {
                s = ((Parameter)((IGraphicalEditPart)arg0).resolveSemanticElement()).getName();
            } else if (arg0 instanceof MetaDataLinkEditPart) {
                QName qName2 = ((MetaDataLink)((IGraphicalEditPart)arg0).resolveSemanticElement()).getName();
                if (qName2 != null) {
                    s = qName2.toString();
                }
            } else if (arg0 instanceof XslVariableEditPart && (qName = ((XslVariable)((IGraphicalEditPart)arg0).resolveSemanticElement()).getName()) != null) {
                s = qName.toString();
            }
            return s;
        }

        @Override
        public int compare(Node arg0, Node arg1) {
            String o1 = this.getNameString((EditPart)arg0.data);
            String o2 = this.getNameString((EditPart)arg1.data);
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.compareTo(o2);
        }
    }
}

