/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom.commands;

import com.indy.ui.custom.out.BuildMenuOperationDispatcher;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class BuildPackageAndDocumentationHandler
extends AbstractHandler
implements IElementUpdater {
    Logger logger = LogManager.getLogger(BuildPackageAndDocumentationHandler.class);
    private List<IFile> process = new ArrayList<IFile>();

    private Stream<IResource> getStream(ISelection s) {
        return ((IStructuredSelection)s).toList().stream().filter(IResource.class::isInstance).map(o -> (IResource)o);
    }

    public BuildPackageAndDocumentationHandler() {
        ISelection s = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.ui.navigator.ProjectExplorer");
        if (s != null) {
            this.process.clear();
            ResourceVisitor visitor = new ResourceVisitor();
            this.getStream(s).forEach(r -> SafeRunner.run(() -> r.accept((IResourceVisitor)visitor)));
            this.process.addAll(visitor.l);
        }
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((part, selection) -> {
            if (!"org.eclipse.ui.navigator.ProjectExplorer".equals(part.getSite().getId())) {
                return;
            }
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
            if (commandService == null) {
                return;
            }
            this.process.clear();
            ResourceVisitor visitor = new ResourceVisitor();
            this.getStream(selection).forEach(r -> SafeRunner.run(() -> r.accept((IResourceVisitor)visitor)));
            this.process.addAll(visitor.l);
            commandService.refreshElements("com.indy.ui.custom.out.command.actionExecution", null);
        });
    }

    public boolean isEnabled() {
        return !this.process.isEmpty();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String paramValue = event.getParameter("com.indy.ui.custom.out.commandParameter6");
        BuildMenuOperationDispatcher.OperationKey operation = BuildMenuOperationDispatcher.OperationKey.of((String)paramValue);
        BuildMenuOperationDispatcher.performOperation((BuildMenuOperationDispatcher.OperationKey)operation, (Collection)this.process.stream().map(f -> URIUtils.convertIPathToEMFURI2((IPath)f.getFullPath())).collect(Collectors.toList()));
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
    }

    private class ResourceVisitor
    implements IResourceVisitor {
        List<IFile> l = new ArrayList<IFile>();

        private ResourceVisitor() {
        }

        private boolean discardContainer(IResource resource) {
            boolean discardFolder;
            boolean discardProject = resource.getType() == 4 && !resource.getProject().isOpen();
            boolean bl = discardFolder = resource.getType() == 2 && ("indy.build".equals(resource.getName()) || "indy.diagram".equals(resource.getName()));
            return discardProject || discardFolder;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.discardContainer(resource)) {
                return false;
            }
            if (resource.getType() != 1) {
                return true;
            }
            if ("map".equals(resource.getFileExtension())) {
                try {
                    IMarker[] m;
                    IPath p = new Path("indy.build").append(resource.getParent().getProjectRelativePath()).append(resource.getFullPath().removeFileExtension().lastSegment() + ".proc");
                    IResource mappingProc = resource.getProject().findMember(p);
                    if (mappingProc != null && mappingProc.exists() && ((m = resource.findMarkers("com.stambia.resource.marker", true, 0)) == null || m.length == 0)) {
                        this.l.add((IFile)mappingProc);
                    }
                }
                catch (Exception ex) {
                    BuildPackageAndDocumentationHandler.this.logger.warn("unexpected", (Throwable)ex);
                }
            } else if ("proc".equals(resource.getFileExtension())) {
                this.l.add((IFile)resource);
            }
            return true;
        }
    }
}

