/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom.cpypaste;

import com.indy.gmf.proc.Action;
import com.indy.gmf.proc.Parameter;
import com.indy.gmf.proc.diagram.non_rcp.custom.cpypaste.CopyPasteBuffer;
import com.indy.gmf.proc.diagram.non_rcp.custom.cpypaste.CustomClipboardSupportGlobalActionHandler;
import com.indy.gmf.proc.diagram.non_rcp.custom.cpypaste.NameGenerator;
import com.indy.gmf.proc.diagram.non_rcp.messages.Messages;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardSupportUtil;
import org.eclipse.gmf.runtime.emf.commands.core.commands.DuplicateEObjectsCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;

public class DuplicateAnythingCommand
extends DuplicateEObjectsCommand {
    private EObject targetContainer;
    private Diagram diagram;
    private Map<CustomClipboardSupportGlobalActionHandler.ItemOrigin, EObject> duplicatedObjects = new HashMap<CustomClipboardSupportGlobalActionHandler.ItemOrigin, EObject>();
    HashMap<Edge, EObject> noteAttachmentDuplicate = new HashMap();
    private static final int EOBJECT_ACTION = 1;
    private static final int EOBJECT_PARAMETER = 2;

    public DuplicateAnythingCommand(TransactionalEditingDomain editingDomain, Diagram diagram) {
        super(editingDomain, Messages.CustomClipboardSupportGlobalActionHandler_7, CopyPasteBuffer.INSTANCE.getBuffered(), new HashMap(), diagram.getElement());
        this.diagram = diagram;
        this.targetContainer = diagram.getElement();
    }

    public boolean canExecute() {
        for (EObject original : this.getObjectsToBeDuplicated()) {
            EReference reference = CopyPasteBuffer.INSTANCE.buffer.get((Object)original).containmentFeature;
            if (FeatureMapUtil.isMany((EObject)this.targetContainer, (EStructuralFeature)reference)) continue;
            return false;
        }
        return true;
    }

    public Map<CustomClipboardSupportGlobalActionHandler.ItemOrigin, EObject> getDuplicated() {
        return this.duplicatedObjects;
    }

    protected void doUpdate(EObject original, EObject duplicate) {
        if (duplicate instanceof Action) {
            this.rename(duplicate, 1);
        } else if (duplicate instanceof Parameter) {
            this.rename(duplicate, 2);
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        try {
            EObject duplicate;
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            copier.copyAll((Collection)this.getObjectsToBeDuplicated());
            copier.copyReferences();
            this.getAllDuplicatedObjectsMap().putAll(copier);
            for (EObject original : this.getObjectsToBeDuplicated()) {
                duplicate = (EObject)copier.get((Object)original);
                this.duplicatedObjects.put(CopyPasteBuffer.INSTANCE.buffer.get(original), duplicate);
                EReference reference = CopyPasteBuffer.INSTANCE.buffer.get((Object)original).containmentFeature;
                if (reference == null || !FeatureMapUtil.isMany((EObject)CopyPasteBuffer.INSTANCE.buffer.get((Object)original).container, (EStructuralFeature)reference) || !ClipboardSupportUtil.isOkToAppendEObjectAt((EObject)CopyPasteBuffer.INSTANCE.buffer.get((Object)original).container, (EReference)reference, (EObject)duplicate)) continue;
                if (duplicate instanceof Edge) {
                    this.noteAttachmentDuplicate.put((Edge)duplicate, (EObject)copier.get((Object)((Edge)original).getTarget().getElement()));
                    continue;
                }
                if (duplicate instanceof View) {
                    ClipboardSupportUtil.appendEObjectAt((EObject)this.diagram, (EReference)reference, (EObject)duplicate);
                    continue;
                }
                ClipboardSupportUtil.appendEObjectAt((EObject)this.targetContainer, (EReference)reference, (EObject)duplicate);
            }
            for (Map.Entry entry : copier.entrySet()) {
                duplicate = (EObject)entry.getValue();
                EAttribute idFeature = duplicate.eClass().getEIDAttribute();
                if (idFeature != null) {
                    Object duplicateId = duplicate.eGet((EStructuralFeature)idFeature);
                    Object originalId = ((EObject)entry.getKey()).eGet((EStructuralFeature)idFeature);
                    if (originalId == null || originalId.equals(duplicateId)) {
                        duplicate.eSet((EStructuralFeature)duplicate.eClass().getEIDAttribute(), (Object)UUID.randomUUID().toString());
                    }
                }
                this.doUpdate((EObject)entry.getKey(), duplicate);
            }
            this.doPostCopy();
            return CommandResult.newOKCommandResult((Object)this.getAllDuplicatedObjectsMap());
        }
        catch (Exception t) {
            return CommandResult.newErrorCommandResult((Throwable)t);
        }
    }

    protected void doPostCopy() {
    }

    private void rename(EObject object, int eObjectType) {
        switch (eObjectType) {
            case 1: {
                ((Action)object).setName(this.generateCopyName(((Action)object).getName(), eObjectType));
                break;
            }
            case 2: {
                ((Parameter)object).setName(this.generateCopyName(((Parameter)object).getName(), eObjectType));
            }
        }
    }

    private String generateCopyName(String name, int eObjectType) {
        NameGenerator gen = new NameGenerator(name);
        for (EObject o : this.targetContainer.eContents()) {
            String currentName = null;
            if (eObjectType == 1 && o instanceof Action) {
                currentName = ((Action)o).getName();
            } else if (eObjectType == 1 && o instanceof Parameter) {
                currentName = ((Parameter)o).getName();
            }
            if (currentName == null) continue;
            gen.addName(currentName);
        }
        return gen.generate();
    }
}

