/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom.policies;

import com.indy.engine.core.common.objects2.IVariable;
import java.util.List;
import org.eclipse.swt.custom.PaintObjectEvent;
import org.eclipse.swt.custom.PaintObjectListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CoreStcakTracePopup {
    private Button next;
    private Button prev;
    private FormToolkit toolkit;
    private StyledText text;
    private List<IVariable> coreStackTraces;
    private String actionName;
    private int currentIndex = 0;
    private Image image;
    private Shell shell;
    private static Font font = null;

    public CoreStcakTracePopup(Shell parent, int style, Image actionImage, String actionName, List<IVariable> coreStackTrace) {
        this.shell = new Shell(parent, style);
        this.image = actionImage;
        this.coreStackTraces = coreStackTrace;
        this.actionName = actionName;
        FillLayout l = new FillLayout();
        l.marginWidth = 0;
        l.marginHeight = 0;
        l.spacing = 0;
        this.shell.setLayout((Layout)l);
        this.shell.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                CoreStcakTracePopup.this.refreshText();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.createContent();
    }

    public Shell getShell() {
        return this.shell;
    }

    private void createContent() {
        this.toolkit = new FormToolkit(this.shell.getDisplay());
        Composite main = new Composite((Composite)this.shell, 0);
        GridLayout gl = new GridLayout();
        gl.marginLeft = 0;
        gl.marginRight = 0;
        gl.marginBottom = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        main.setLayout((Layout)gl);
        Composite sc = new Composite(main, 0);
        sc.setLayout((Layout)new FillLayout());
        this.text = new StyledText(sc, 66314);
        if (font == null) {
            FontData fontData = this.text.getFont().getFontData()[0];
            font = new Font((Device)this.text.getShell().getDisplay(), new FontData(fontData.getName(), fontData.getHeight(), 1));
        }
        this.text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                e.doit = false;
            }
        });
        this.text.addPaintObjectListener(new PaintObjectListener(){

            public void paintObject(PaintObjectEvent event) {
                GC gc = event.gc;
                StyleRange style = event.style;
                int start = style.start;
                if (start == 0) {
                    int x = event.x;
                    int y = event.y + event.ascent - style.metrics.ascent;
                    gc.drawImage(CoreStcakTracePopup.this.image, x, y);
                }
            }
        });
        GridData gd = new GridData(4, 4, true, true);
        sc.setLayoutData((Object)gd);
        Composite toolbar = new Composite(main, 0);
        gd = new GridData(4, 3, true, false);
        gd.verticalIndent = 0;
        toolbar.setLayoutData((Object)gd);
        RowLayout rl = new RowLayout();
        toolbar.setLayout((Layout)rl);
        this.prev = new Button(toolbar, 8);
        this.prev.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_BACK"));
        this.prev.setEnabled(false);
        this.prev.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                --CoreStcakTracePopup.this.currentIndex;
                CoreStcakTracePopup.this.refreshText();
                if (CoreStcakTracePopup.this.currentIndex == 0) {
                    CoreStcakTracePopup.this.prev.setEnabled(false);
                }
                CoreStcakTracePopup.this.next.setEnabled(true);
            }
        });
        this.next = new Button(toolbar, 8);
        this.next.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_FORWARD"));
        this.next.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ++CoreStcakTracePopup.this.currentIndex;
                CoreStcakTracePopup.this.refreshText();
                if (CoreStcakTracePopup.this.currentIndex == CoreStcakTracePopup.this.coreStackTraces.size() - 1) {
                    CoreStcakTracePopup.this.next.setEnabled(false);
                }
                CoreStcakTracePopup.this.prev.setEnabled(true);
            }
        });
        this.next.setEnabled(this.coreStackTraces.size() > 1);
        this.refreshText();
    }

    private void refreshText() {
        String actionName;
        String value = this.currentIndex < this.coreStackTraces.size() ? this.coreStackTraces.get(this.currentIndex).getValue() : "";
        String string = actionName = this.currentIndex < this.coreStackTraces.size() ? this.coreStackTraces.get(this.currentIndex).getActionName() : this.actionName;
        if (actionName.contains("/")) {
            String[] s = actionName.split("/");
            actionName = s[s.length - 1];
        }
        this.text.setText("  " + actionName + "\n" + value);
        StyleRange style = new StyleRange();
        style.start = 0;
        style.length = 1;
        Rectangle rect = this.image.getBounds();
        style.metrics = new GlyphMetrics(rect.height, 0, rect.width);
        this.text.setStyleRange(style);
        style = new StyleRange();
        style.start = 2;
        style.length = actionName.length() + 1;
        style.fontStyle = 1;
        this.text.setStyleRange(style);
    }
}

