/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.edit.commands;

import com.indy.gmf.proc.Action;
import com.indy.gmf.proc.Element;
import com.indy.gmf.proc.Link;
import com.indy.gmf.proc.diagram.non_rcp.edit.policies.ProcBaseItemSemanticEditPolicy;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;

public class LinkReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public LinkReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Link)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Element) || !(this.newEnd instanceof Element)) {
            return false;
        }
        Action target = this.getLink().getTargetId();
        return ProcBaseItemSemanticEditPolicy.LinkConstraints.canExistLink_4001(this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Action) || !(this.newEnd instanceof Action)) {
            return false;
        }
        if (!(this.getLink().eContainer() instanceof Element)) {
            return false;
        }
        Element source = (Element)this.getLink().eContainer();
        return ProcBaseItemSemanticEditPolicy.LinkConstraints.canExistLink_4001(source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getLink().remove((Object)this.getLink());
        this.getNewSource().getLink().add((Object)this.getLink());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setTargetId(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Link getLink() {
        return (Link)this.getElementToEdit();
    }

    protected Element getOldSource() {
        return (Element)this.oldEnd;
    }

    protected Element getNewSource() {
        return (Element)this.newEnd;
    }

    protected Action getOldTarget() {
        return (Action)this.oldEnd;
    }

    protected Action getNewTarget() {
        return (Action)this.newEnd;
    }
}

