/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.part;

import com.indy.gmf.proc.MetaDataLink;
import com.indy.gmf.proc.diagram.non_rcp.messages.Messages;
import com.indy.gmf.proc.diagram.non_rcp.part.DeleteElementAction;
import com.indy.gmf.proc.diagram.non_rcp.part.ProcDiagramEditorPlugin;
import com.indy.md.ui.editor.ui.MdMenuUtil;
import com.semarchy.xdi.designer.core.models.MetaDataLinkCapability;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.lang.ref.WeakReference;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.ContributionItemService;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.providers.DiagramContextMenuProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.services.IServiceLocator;
import org.osgi.service.log.LogService;

public class DiagramEditorContextMenuProvider
extends DiagramContextMenuProvider {
    private WeakReference<IWorkbenchPart> part;
    private DeleteElementAction deleteAction;
    private CommandAction collapseAndArrangeAction;

    public DiagramEditorContextMenuProvider(IWorkbenchPart part, EditPartViewer viewer) {
        super(null, viewer);
        this.part = new WeakReference<IWorkbenchPart>(part);
        this.deleteAction = new DeleteElementAction(part);
        this.deleteAction.init();
        this.collapseAndArrangeAction = new CommandAction((IServiceLocator)part.getSite(), "com.indy.gmf.process.diagram.non_rcp.commandArrangeAllAndCollapse");
    }

    public ActionRegistry getActionRegistry() {
        IWorkbenchPart p = (IWorkbenchPart)this.part.get();
        if (p != null) {
            return (ActionRegistry)p.getAdapter(ActionRegistry.class);
        }
        return null;
    }

    public void dispose() {
        if (this.deleteAction != null) {
            this.deleteAction.dispose();
            this.deleteAction = null;
        }
        super.dispose();
        this.part = null;
        this.setViewer(null);
    }

    public void buildContextMenu(final IMenuManager menu) {
        this.getViewer().flush();
        try {
            TransactionUtil.getEditingDomain((EObject)((EObject)this.getViewer().getContents().getModel())).runExclusive(new Runnable(){

                @Override
                public void run() {
                    if (DiagramEditorContextMenuProvider.this.part == null) {
                        return;
                    }
                    IWorkbenchPart partRef = (IWorkbenchPart)DiagramEditorContextMenuProvider.this.part.get();
                    if (partRef != null) {
                        ContributionItemService.getInstance().contributeToPopupMenu((IMenuManager)DiagramEditorContextMenuProvider.this, partRef);
                        menu.remove("deleteFromModelAction");
                        menu.appendToGroup("editGroup", (IAction)DiagramEditorContextMenuProvider.this.deleteAction);
                        menu.appendToGroup("filterFormatGroup", (IAction)DiagramEditorContextMenuProvider.this.collapseAndArrangeAction);
                    }
                }
            });
        }
        catch (Exception e) {
            ProcDiagramEditorPlugin.getInstance().logError(Messages.DiagramEditorContextMenuProvider_1, e);
        }
        this.addMdNodeMenu(menu);
    }

    public void addMdNodeMenu(IMenuManager menu) {
        if (this.getViewer().getSelection() instanceof StructuredSelection) {
            EObject ref;
            StructuredSelection selection = (StructuredSelection)this.getViewer().getSelection();
            EObject selectedElement = null;
            if (selection.getFirstElement() instanceof GraphicalEditPart) {
                selectedElement = ((GraphicalEditPart)selection.getFirstElement()).resolveSemanticElement();
            }
            if (selectedElement instanceof MetaDataLink && (ref = ((MetaDataLink)selectedElement).getTarget()) instanceof MetaDataLinkCapability) {
                MenuManager actionSubMenu = new MenuManager(Messages.DiagramEditorContextMenuProvider_2);
                menu.insertBefore("umlAddGroup", (IContributionItem)actionSubMenu);
                MdMenuUtil.addExecutableAction((IMenuManager)actionSubMenu, (MetaDataLinkCapability)((MetaDataLinkCapability)ref), (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (boolean)false, (boolean)false);
                menu.insertBefore("umlAddGroup", (IAction)new CommandWrapper("com.indy.md.ui.editor.commands.xPathWizard", ref));
            }
        }
    }

    class CommandWrapper
    extends Action {
        Command wrappedCmd;
        ImageDescriptor img;
        Object mdNode;

        CommandWrapper(String commandId, Object mdNode) {
            ICommandService cmdService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            this.mdNode = mdNode;
            this.img = ((ICommandImageService)PlatformUI.getWorkbench().getService(ICommandImageService.class)).getImageDescriptor(commandId);
            this.wrappedCmd = cmdService.getCommand(commandId);
        }

        public String getText() {
            try {
                return this.wrappedCmd.getName();
            }
            catch (NotDefinedException e) {
                return this.wrappedCmd.getId();
            }
        }

        public ImageDescriptor getImageDescriptor() {
            return this.img;
        }

        public void run() {
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            try {
                EvaluationContext ctx = new EvaluationContext(null, this.mdNode);
                ctx.addVariable("selection", (Object)new StructuredSelection(this.mdNode));
                handlerService.executeCommandInContext(new ParameterizedCommand(this.wrappedCmd, null), new Event(), (IEvaluationContext)ctx);
            }
            catch (Exception e) {
                ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger(DiagramContextMenuProvider.class).error(String.format("Failed to execute command %s", this.wrappedCmd.getId()), (Object)e);
            }
        }
    }
}

