/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.internal;

import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.index.internal.CacheImpl;
import com.semarchy.xdi.designer.index.internal.Messages;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

class CacheChangedJob
extends Job {
    private CacheImpl cache;
    private Map<String, Runnable> additionalSubtasks = new LinkedHashMap<String, Runnable>();

    public CacheChangedJob(CacheImpl cache) {
        super(Messages.CacheChangedJob_jobName);
        this.cache = cache;
        this.setSystem(true);
    }

    public boolean belongsTo(Object family) {
        return family == ICacheService.class;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(Messages.CacheChangedJob_taskName, 3 + this.additionalSubtasks.size());
        monitor.subTask(Messages.CacheChangedJob_cleanSubtask);
        this.cache.clean();
        monitor.worked(1);
        monitor.subTask(Messages.CacheChangedJob_analyzeProblemsSubtask);
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.cache.getSuper().analyseProblem(this.cache);
        monitor.worked(1);
        for (String taskName : this.additionalSubtasks.keySet()) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.subTask(taskName);
            Runnable task = this.additionalSubtasks.get(taskName);
            task.run();
            monitor.worked(1);
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    public void addSubtask(String subtaskName, Runnable subtask) {
        try {
            this.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.additionalSubtasks.put(subtaskName, subtask);
    }

    public void removeSubtask(String subtaskName) {
        try {
            this.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.additionalSubtasks.remove(subtaskName);
    }
}

