/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.internal;

import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.services.cache.CacheEventResource;
import com.semarchy.xdi.designer.core.services.cache.CacheEventURI;
import com.semarchy.xdi.designer.core.services.cache.ICacheListener;
import com.semarchy.xdi.designer.core.services.cache.ICacheState;
import com.semarchy.xdi.designer.index.internal.CacheImpl;
import com.semarchy.xdi.designer.index.internal.Messages;
import com.semarchy.xdi.designer.index.internal.MissingModelLocator;
import com.semarchy.xdi.designer.index.model.Elt;
import com.semarchy.xdi.designer.index.model.Source;
import com.semarchy.xdi.designer.index.model.StateType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ICacheListener.class, ICacheService.ICacheServiceListener.class, ICacheState.IBrokenSourceProvider.class, ICacheService.IDependenciesGraphAnalyzer.class})
public class DependencyGraphHandler
implements ICacheListener,
ICacheService.ICacheServiceListener,
ICacheState.IBrokenSourceProvider,
ICacheService.IDependenciesGraphAnalyzer {
    private Graph dependanciesGraph = new Graph();
    private HashMap<Source, Collection<Source>> brokenSrc = new HashMap();
    private boolean graphChanged = false;
    private boolean updated = false;
    private boolean initializing = false;
    private Monitor monitor = new Monitor();
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Reference(service=ICacheService.class)
    private ICacheService cacheService;
    @Reference
    private XDIModelURIResolver modelResolver;

    public void resourceBuildStateChanged(CacheEventResource event) {
    }

    public void resourceErrorStateChanged(CacheEventResource event) {
    }

    public boolean handleEvent(CacheEventResource event) {
        return false;
    }

    private boolean track(URI uri) {
        if (uri != null) {
            return uri.segmentCount() <= 2 || !"indy.build".equals(uri.segment(2));
        }
        return false;
    }

    public boolean handleEvent(CacheEventURI event) {
        if (this.initializing) {
            return false;
        }
        switch (event.getType()) {
            case REMOVED: 
            case SYNCHRONIZED: 
            case INEXISTED: {
                if (event.getModelURI() == null) break;
                return this.track(event.getModelURI());
            }
        }
        return false;
    }

    public void handleEventsTriggered() {
        this.doUpdateBrokenSources();
    }

    public void handleCacheSourceChanged(CacheEventURI event) {
        Source src = null;
        boolean changed = false;
        switch (event.getType()) {
            case REMOVED: {
                changed |= this.dependanciesGraph.deleteNode(event.getSourceID());
                this.updated = true;
                break;
            }
            case INEXISTED: {
                src = ((CacheImpl)this.cacheService).getSuper().getSource(event.getSourceID());
                if (this.dependanciesGraph.incomingEdges.get(src) != null) {
                    Iterator<Source> it = this.dependanciesGraph.incomingEdges.get(src).iterator();
                    while (it.hasNext()) {
                        Source to = it.next();
                        it.remove();
                        this.dependanciesGraph.removeEdge(src, to);
                        changed |= true;
                    }
                }
                this.updated = true;
                break;
            }
            case DUPLICATED: {
                this.updated = true;
                break;
            }
            case SYNCHRONIZED: {
                src = ((CacheImpl)this.cacheService).getSuper().getSource(event.getSourceID());
                if (src == null) break;
                this.updated = true;
                changed |= this.dependanciesGraph.createNode(src);
                HashSet<Source> referencedSource = new HashSet<Source>();
                for (Elt elt : src.getElt()) {
                    for (Elt r : elt.getReference()) {
                        Source s = r.getSource();
                        if (s == null) continue;
                        referencedSource.add(s);
                    }
                }
                Iterator<Source> it = this.dependanciesGraph.incomingEdges.get(src).iterator();
                while (it.hasNext()) {
                    Source to = it.next();
                    it.remove();
                    this.dependanciesGraph.removeEdge(src, to);
                    changed |= true;
                }
                for (Source s : referencedSource) {
                    changed |= this.dependanciesGraph.createEdge(s, src);
                }
                break;
            }
        }
        if (changed && !this.graphChanged) {
            this.graphChanged = changed;
        }
    }

    public void handleCacheInitialized() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("INITIALIZED");
        }
        boolean changed = false;
        HashSet<String> toMonitor = new HashSet<String>();
        this.monitor.monitoredDependencies.clear();
        this.monitor.monitoredId.clear();
        this.monitor.monitoredImpact.clear();
        this.monitor.toInvalidate.clear();
        try {
            for (Source s : ((CacheImpl)this.cacheService).getSuper().getResource()) {
                if (s.getURI() == null || s.getState() == StateType.DUPLICATE || !this.track(s.getURI())) continue;
                if ("md".equals(s.getURI().fileExtension()) || "tech".equals(s.getURI().fileExtension())) {
                    toMonitor.add(s.getId());
                }
                changed |= this.dependanciesGraph.createNode(s);
                for (Elt e : s.getElt()) {
                    for (Elt r : e.getReference()) {
                        Source f = r.getSource();
                        if (f == null) continue;
                        changed |= this.dependanciesGraph.createNode(f);
                        try {
                            changed |= this.dependanciesGraph.createEdge(f, s);
                        }
                        catch (RuntimeException ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
            if (changed) {
                this.graphChanged = true;
            }
        }
        finally {
            this.initializing = false;
            this.monitor.monitorObject(toMonitor);
        }
    }

    public void handleCacheInitializing() {
        this.dependanciesGraph = new Graph();
        this.brokenSrc.clear();
        this.initializing = true;
    }

    public Collection<URI> getSourceWithBrokenRequirement() {
        this.doUpdateBrokenSources();
        return Collections.unmodifiableCollection(this.brokenSrc.keySet().stream().map(s -> s.getURI()).collect(Collectors.toSet()));
    }

    private void doUpdateBrokenSources() {
        if (this.graphChanged) {
            Visitor v = new Visitor();
            try {
                try {
                    v.acceptDFS(this.dependanciesGraph);
                    this.brokenSrc = new HashMap();
                    for (Source k : v.dependanciesPerBrokenSrc.keySet()) {
                        for (Source s : v.dependanciesPerBrokenSrc.get(k)) {
                            Collection<Source> c = this.brokenSrc.get(s);
                            if (c == null) {
                                c = new HashSet<Source>();
                                this.brokenSrc.put(s, c);
                            }
                            c.add(k);
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    this.graphChanged = false;
                }
            }
            finally {
                this.graphChanged = false;
            }
        }
    }

    public String getSourceWithBrokenRequirementMessage(URI uri) {
        Source src = ((CacheImpl)this.cacheService).getSuper().getSource(uri);
        Collection<Source> c = this.brokenSrc.get(src);
        if (c == null || c.isEmpty()) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        for (Source s : c) {
            if (s.getState() != StateType.INEXISTENT) {
                if (s.getURI() != null) {
                    if (s.getURI().isPlatformResource()) {
                        b.append(Messages.bind((String)Messages.DependencyGraphHandler_13, (Object)s.getURI().toPlatformString(true)));
                        continue;
                    }
                    b.append(Messages.bind((String)Messages.DependencyGraphHandler_9, (Object)s.getURI().toPlatformString(true)));
                    continue;
                }
                b.append(Messages.bind((String)Messages.DependencyGraphHandler_11, (Object)s.getId()));
                continue;
            }
            if (s.getURI() != null) {
                if (s.getURI().isPlatformResource()) {
                    b.append(Messages.bind((String)Messages.DependencyGraphHandler_13, (Object)s.getURI().toPlatformString(true)));
                    continue;
                }
                b.append(Messages.bind((String)Messages.DependencyGraphHandler_13, (Object)s.getURI().toPlatformString(true)));
                continue;
            }
            b.append(Messages.bind((String)Messages.DependencyGraphHandler_11, (Object)s.getId()));
        }
        return b.toString();
    }

    public Map<String, URI> getRequiredModelsURI(Collection<String> modelIds) {
        DependencyVisitor v = new DependencyVisitor();
        v.acceptDFS(modelIds);
        if (v.uris.containsKey("UUID_REGISTRY_UDF")) {
            HashSet mappingURIs = new HashSet();
            mappingURIs.addAll(modelIds.stream().map(s -> this.dependanciesGraph.srcById.get(s).getURI()).filter(u -> "map".equals(u.fileExtension())).collect(Collectors.toSet()));
            mappingURIs.addAll(v.uris.values().stream().filter(u -> "map".equals(u.fileExtension())).collect(Collectors.toSet()));
            for (URI u2 : mappingURIs) {
                List requiredModels = this.cacheService.getDependencyHelper().getDependancies(u2);
                requiredModels.stream().filter(m -> !dependencyVisitor.uris.containsValue(m)).forEach(m -> {
                    URI uRI = dependencyVisitor.uris.put(this.cacheService.getSourceId(m), (URI)m);
                });
            }
        }
        return v.uris;
    }

    public Map<String, Collection<URI>> getPotentialModelURIForMissing(Collection<String> modelId) {
        HashMap<String, Collection<URI>> res = new HashMap<String, Collection<URI>>();
        for (String id : modelId) {
            Source src = this.dependanciesGraph.srcById.get(id);
            if (src == null) {
                res.put(id, Collections.EMPTY_LIST);
                continue;
            }
            if (src.getState() != StateType.INEXISTENT) continue;
            MissingModelLocator locator = new MissingModelLocator();
            res.put(id, locator.lookForPotentialURI((CacheImpl)this.cacheService, id));
        }
        return res;
    }

    public Collection<String> getInvalidatedModelsId() {
        return this.monitor.consumeInvalidated();
    }

    public void monitorModelsDependancies(Collection<String> modelIds) {
        this.monitor.monitorObject(modelIds);
    }

    class DependencyVisitor {
        Map<String, URI> uris = new HashMap<String, URI>();
        Map<String, Collection<String>> impactedByChange = new HashMap<String, Collection<String>>();

        DependencyVisitor() {
        }

        void visitDFS(Source s, Collection<Source> visited) {
            for (Source from : DependencyGraphHandler.this.dependanciesGraph.incomingEdges.get(s)) {
                Collection<String> impacts = this.impactedByChange.get(from.getId());
                if (impacts == null) {
                    impacts = new HashSet<String>();
                    this.impactedByChange.put(from.getId(), impacts);
                }
                impacts.add(s.getId());
                if (!visited.add(from)) continue;
                this.uris.put(from.getId(), from.getURI());
                this.visitDFS(from, visited);
            }
        }

        void acceptDFS(Collection<String> ids) {
            HashSet<Source> visited = new HashSet<Source>();
            for (String id : ids) {
                Source n = DependencyGraphHandler.this.dependanciesGraph.srcById.get(id);
                if (n == null) continue;
                this.visitDFS(n, visited);
            }
        }
    }

    class Graph {
        Set<Source> nodes = Collections.synchronizedSet(new HashSet());
        Map<String, Source> srcById = Collections.synchronizedMap(new HashMap());
        Map<Source, Set<Source>> incomingEdges = Collections.synchronizedMap(new HashMap());
        Map<Source, Set<Source>> outgoingEdges = Collections.synchronizedMap(new HashMap());

        Graph() {
        }

        boolean deleteNode(String id) {
            boolean res = false;
            Source s = this.srcById.remove(id);
            if (s != null) {
                res = this.nodes.remove(s);
                boolean hadEdges = false;
                hadEdges |= this.incomingEdges.remove(s) != null;
                if (hadEdges |= this.outgoingEdges.remove(s) != null) {
                    for (Set<Source> l : this.incomingEdges.values()) {
                        l.remove(s);
                    }
                    for (Set<Source> l : this.outgoingEdges.values()) {
                        l.remove(s);
                    }
                    res = true;
                }
            }
            DependencyGraphHandler.this.monitor.handleObjectChange(id);
            return res;
        }

        boolean createNode(Source s) {
            if (s != null && this.nodes.add(s)) {
                this.incomingEdges.put(s, new HashSet());
                this.outgoingEdges.put(s, new HashSet());
                this.srcById.put(s.getId(), s);
                DependencyGraphHandler.this.monitor.monitorObject(Collections.singletonList(s.getId()));
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump() {
            StringBuffer buf = new StringBuffer();
            Set<Source> set = this.nodes;
            synchronized (set) {
                for (Source s : this.nodes) {
                    Object name = s.getURI() == null ? s.getId() : s.getURI().trimFragment().lastSegment();
                    name = URI.decode((String)name);
                    name = "\\n" + (String)name;
                    for (Source o : this.outgoingEdges.get(s)) {
                        Object name2 = s.getURI() == null ? o.getId() : o.getURI().trimFragment().lastSegment();
                        name2 = URI.decode((String)name2);
                        name2 = "\\n" + (String)name2;
                        buf.append("\"" + s.getId() + (String)name + "\" -> \"" + o.getId() + (String)name2 + "\";\n");
                    }
                }
            }
            System.out.println(buf.toString());
        }

        boolean removeEdge(Source from, Source to) {
            boolean res = false;
            res |= this.outgoingEdges.get(from).remove(to);
            if (res |= this.incomingEdges.get(to).remove(from)) {
                DependencyGraphHandler.this.monitor.handleObjectChange(from.getId());
            }
            return res;
        }

        boolean createEdge(Source from, Source to) {
            if (!this.nodes.contains(from)) {
                this.createNode(from);
            }
            if (!this.nodes.contains(to)) {
                this.createNode(to);
            }
            this.incomingEdges.get(to).add(from);
            this.outgoingEdges.get(from).add(to);
            DependencyGraphHandler.this.monitor.handleObjectChange(to.getId());
            return true;
        }
    }

    static enum Mode {
        DETECT_BROKEN,
        TRAVERSE_ALL;

    }

    class Monitor {
        Set<String> monitoredId = Collections.synchronizedSet(new HashSet());
        Set<String> monitoredDependencies = Collections.synchronizedSet(new HashSet());
        Map<String, Collection<String>> monitoredImpact = Collections.synchronizedMap(new HashMap());
        Set<String> toInvalidate = Collections.synchronizedSet(new HashSet());

        Monitor() {
        }

        public void monitorObject(Collection<String> id) {
            if (DependencyGraphHandler.this.initializing) {
                return;
            }
            HashSet<String> toMonitor = new HashSet<String>();
            for (String s : id) {
                if (!this.monitoredId.add(s)) continue;
                toMonitor.add(s);
            }
            DependencyVisitor v = new DependencyVisitor();
            v.acceptDFS(toMonitor);
            this.monitoredImpact.putAll(v.impactedByChange);
            this.monitoredDependencies.addAll(v.uris.keySet());
        }

        private void handleObjectChange(String id) {
            if (DependencyGraphHandler.this.initializing) {
                return;
            }
            if ((this.monitoredId.contains(id) || this.monitoredDependencies.contains(id)) && this.toInvalidate.add(id)) {
                this.gatherDescendant(id, this.toInvalidate);
            }
        }

        private void gatherDescendant(String id, Collection<String> handled) {
            Collection<String> imp = this.monitoredImpact.get(id);
            if (imp != null) {
                for (String s : imp) {
                    if (!handled.add(s)) continue;
                    this.gatherDescendant(s, handled);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doUpdate() {
            if (DependencyGraphHandler.this.updated) {
                this.monitoredDependencies.clear();
                HashSet<String> toMonitor = new HashSet<String>();
                Set<String> set = this.monitoredId;
                synchronized (set) {
                    for (String id : this.monitoredId) {
                        Source src = DependencyGraphHandler.this.dependanciesGraph.srcById.get(id);
                        if (src == null) continue;
                        toMonitor.add(id);
                    }
                    this.monitoredId.clear();
                    this.monitoredId.addAll(toMonitor);
                    this.monitorObject(this.monitoredId);
                    DependencyGraphHandler.this.updated = false;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Collection<String> consumeInvalidated() {
            this.doUpdate();
            Set<String> set = this.toInvalidate;
            synchronized (set) {
                HashSet<String> res = new HashSet<String>(this.toInvalidate);
                this.toInvalidate.clear();
                return res;
            }
        }
    }

    class Visitor {
        Set<Source> brokenSrc = new HashSet<Source>();
        HashMap<Source, Set<Source>> dependanciesPerBrokenSrc = new HashMap();
        Graph g;

        Visitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void acceptDFS(Graph g) {
            this.g = g;
            HashSet<Source> visited = new HashSet<Source>();
            Set<Source> set = g.nodes;
            synchronized (set) {
                for (Source s : g.nodes) {
                    this.visitDFS(s, visited, Mode.DETECT_BROKEN);
                }
            }
            for (Source s : this.brokenSrc) {
                HashSet<Source> brokenDependants = null;
                brokenDependants = new HashSet<Source>();
                this.dependanciesPerBrokenSrc.put(s, brokenDependants);
                this.visitDFS(s, brokenDependants, Mode.TRAVERSE_ALL);
            }
        }

        boolean isBroken(Source s) {
            boolean broken = false;
            for (Elt e : s.getMandatoryElt()) {
                if (e.getState() != StateType.INEXISTENT) continue;
                broken = true;
                break;
            }
            return broken;
        }

        void visitDFS(Source s, Collection<Source> visited, Mode mode) {
            if (mode == Mode.DETECT_BROKEN && this.isBroken(s)) {
                this.brokenSrc.add(s);
                return;
            }
            for (Source to : this.g.outgoingEdges.get(s)) {
                if (!visited.add(to)) continue;
                this.visitDFS(to, visited, mode);
            }
        }
    }
}

