/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.internal;

import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IMappingBuildJobFactory;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.utils.MemoryPreserverEditingDomainWrapper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import com.semarchy.xdi.designer.index.internal.MappingBuildHandler;
import com.semarchy.xdi.designer.index.internal.Messages;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.osgi.util.NLS;

class MappingBuildDelegate
implements IMappingBuildJobFactory.IBuilderDelegate {
    public static final int MD_RETENTION_COUNT = 100;
    protected LinkedList<String> queue;
    private Map<String, URI> sourceIdToURI = new HashMap<String, URI>();
    private MappingBuildHandler buildHandler;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private MemoryPreserverEditingDomainWrapper editingDomainWrapper;
    HashMap<URI, Collection<URI>> requirementByURI = new HashMap();

    public MappingBuildDelegate(LinkedList<String> mappingIds, MappingBuildHandler buildHandler) {
        this.buildHandler = buildHandler;
        this.queue = mappingIds;
        this.editingDomainWrapper = new MemoryPreserverEditingDomainWrapper(buildHandler.mdipf, 15);
    }

    URI getSourceURI(String sourceId) {
        return this.sourceIdToURI.computeIfAbsent(sourceId, k -> this.buildHandler.cacheService.findResourceURIByFileId(k));
    }

    protected boolean isForce() {
        return false;
    }

    private void cleanBuiltFiles(URI mappingURI, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor);
        sub.subTask(Messages.MappingBuildHandler_138);
        for (URI u : URIUtils.getMappingBuiltFiles((URI)mappingURI, (XDIModelURIResolver)this.buildHandler.modelResolver, (boolean)false)) {
            File f = this.buildHandler.modelResolver.resolve(u);
            if (f == null) continue;
            try {
                Files.deleteIfExists(f.toPath());
            }
            catch (Exception e) {
                this.logger.warn("com.semarchy.xdi.designer.index", (Object)(Messages.MappingBuildHandler_139 + String.valueOf(f)), (Object)e);
            }
        }
    }

    private Collection<URI> extractAllRequirment(URI uri, Collection<URI> usedUri) {
        Collection<URI> cached = this.requirementByURI.get(uri);
        if (cached != null) {
            return cached;
        }
        HashSet<URI> l = new HashSet<URI>();
        for (URI dp : this.buildHandler.cacheService.getReferencedResources(uri)) {
            if (l.contains(dp) || usedUri.contains(dp)) continue;
            l.add(dp);
        }
        usedUri.addAll(l);
        HashSet<URI> requirements = new HashSet<URI>();
        for (URI u : l) {
            requirements.addAll(this.extractAllRequirment(u, usedUri));
        }
        for (URI u : requirements) {
            if (l.contains(u)) continue;
            l.add(u);
        }
        this.requirementByURI.put(uri, l);
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSmartRelease() {
        if (this.editingDomainWrapper.releaseWhenMemoryIsThin()) {
            return;
        }
        try {
            HashSet<URI> requestedUris = new HashSet<URI>();
            int i = 0;
            for (String id : this.queue) {
                URI uri = this.getSourceURI(id);
                ICacheService.SourceState st = this.buildHandler.cacheService.getSourceState(uri);
                if (st == null || st.isDuplicate()) continue;
                ICacheService iCacheService = this.buildHandler.cacheService;
                synchronized (iCacheService) {
                    for (URI u : this.extractAllRequirment(uri, new ArrayList<URI>())) {
                        requestedUris.add(u);
                    }
                }
                if (++i >= 100) break;
            }
            ResourceSet rs = this.editingDomainWrapper.getEditingDomain().getResourceSet();
            Iterator it = rs.getResources().iterator();
            while (it.hasNext()) {
                String extension;
                Resource r = (Resource)it.next();
                if (r == null || !r.isLoaded() || !"md".equals(extension = r.getURI().fileExtension()) && !"tech".equals(extension) || requestedUris.contains(r.getURI())) continue;
                this.logger.info("Unload: {}", (Object)r);
                r.unload();
                it.remove();
            }
        }
        catch (Exception t) {
            this.logger.warn(Messages.MappingBuildHandler_5, (Throwable)t);
        }
    }

    /*
     * Exception decompiling
     */
    public IStatus run(IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 35[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Unable to fully structure code
     */
    private boolean handlePrebuilt(URI srcURI, String mappingId, SubMonitor subMonitor, List<IStatus> warning, List<IStatus> infos) {
        if (this.buildHandler.preBuiltMappingId.remove(mappingId)) {
            subMonitor.subTask(Messages.MappingBuildHandler_31);
            prebuiltFiles = Collections.EMPTY_LIST;
            try {
                prebuiltFiles = this.buildHandler.delegateBuilder.getPrebuiltFilesPath(srcURI);
                this.logger.trace("Handling prebuilt {} ...", (Object)srcURI);
                this.movePrebuiltFile(srcURI, mappingId, prebuiltFiles, (IProgressMonitor)subMonitor.newChild(1));
                this.logger.info("Handled prebuilt {}", (Object)srcURI);
                infos.add((IStatus)new Status(1, "com.semarchy.xdi.designer.index", Messages.MappingBuildHandler_35 + String.valueOf(srcURI)));
                return true;
            }
            catch (Exception ex) {
                subMonitor.subTask(Messages.MappingBuildHandler_36);
                this.logger.warn("Handled prebuilt {}  failed because ", (Object)srcURI, (Object)ex);
                warning.add((IStatus)new Status(2, "com.semarchy.xdi.designer.index", NLS.bind((String)Messages.MappingBuildHandler_39, (Object)srcURI)));
                ** for (s : prebuiltFiles)
            }
lbl-1000:
            // 1 sources

            {
                f = new File(s);
                f.delete();
                continue;
            }
lbl22:
            // 1 sources

            this.logger.info("Destroyed prebuilt {}", (Object)srcURI);
        }
        return false;
    }

    private void handleCancellation(String sourceId) {
        this.buildHandler.mappingIdToBuild.add(sourceId);
        this.buildHandler.hasNewMappingToBuild = true;
        this.buildHandler.mappingIdToBuild.addAll(this.queue);
        this.logger.info("Cancelled");
    }

    private void movePrebuiltFile(URI mappingURI, String mappingID, List<String> prebuiltFiles, IProgressMonitor monitor) throws Exception {
        ISchedulingRule combinedRule = null;
        URI buildFolderURI = URIUtils.getMappingBuiltMdFile((URI)mappingURI).trimFileExtension().trimSegments(1);
        HashMap<String, URI> prebuiltMap = new HashMap<String, URI>();
        for (String s : prebuiltFiles) {
            String fName = s.substring(s.replace("\\", "/").lastIndexOf("/") + 1);
            fName = fName.replace(mappingID, mappingURI.trimFileExtension().lastSegment());
            URI uri = buildFolderURI.appendSegment(fName);
            prebuiltMap.put(s, uri);
            combinedRule = MultiRule.combine(combinedRule, (ISchedulingRule)this.buildHandler.modelResolver.createSchedulingRule(uri));
        }
        try {
            Job.getJobManager().beginRule(combinedRule, monitor);
            monitor.beginTask(Messages.MappingBuildHandler_81, 2);
            for (String s : prebuiltFiles) {
                File trgFile = this.buildHandler.modelResolver.resolve((URI)prebuiltMap.get(s));
                Files.move(new File(s).toPath(), trgFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            this.buildHandler.modelResolver.refreshResurce(mappingURI);
            prebuiltMap.entrySet().stream().forEach(e -> {
                try {
                    this.buildHandler.modelResolver.refreshResurce((URI)e.getValue());
                }
                catch (Exception e1) {
                    this.logger.error("Failed to refresh {}", (Object)((URI)e.getValue()).toPlatformString(true));
                }
            });
        }
        finally {
            Job.getJobManager().endRule(combinedRule);
        }
    }
}

