/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.internal;

import com.semarchy.xdi.designer.core.models.ModelWithDuplicateIdException;
import com.semarchy.xdi.designer.core.models.XSDValidityException;
import com.semarchy.xdi.designer.core.services.cache.ICacheState;
import org.eclipse.emf.ecore.resource.Resource;

class UnparsedResourceInfo
implements ICacheState.IUnparsedResourceInfo {
    String message;
    String location;
    int lineNumber = 1;
    boolean warning = false;
    String markerType = null;

    public UnparsedResourceInfo(Throwable t) {
        this.message = t.getMessage();
        if (t instanceof Resource.Diagnostic) {
            this.location = ((Resource.Diagnostic)t).getLocation();
            this.lineNumber = ((Resource.Diagnostic)t).getLine();
            if (t instanceof XSDValidityException || t instanceof ModelWithDuplicateIdException) {
                this.warning = true;
                if (t instanceof XSDValidityException) {
                    this.markerType = "com.stambia.resource.marker.invalidXML";
                } else if (t instanceof ModelWithDuplicateIdException) {
                    this.markerType = "com.stambia.resource.marker.duplicateid";
                }
            }
        }
    }

    public UnparsedResourceInfo(String message, boolean warning, String markerType) {
        this.message = message;
        this.warning = warning;
        this.markerType = markerType;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLocation() {
        return this.location;
    }

    public int getLine() {
        return this.lineNumber;
    }

    public boolean isWarning() {
        return this.warning;
    }

    public String getMarkerType() {
        return this.markerType;
    }
}

