/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.parsers;

import com.semarchy.xdi.designer.core.services.IInternalResourceRegistry;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.index.internal.InternalResourceFolderRegistry;
import com.semarchy.xdi.designer.index.internal.Messages;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogService;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class StaxFastResourceLoader {
    public String fastParse(InputStream is) throws Exception {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        parserFactory.setFeature("http://xml.org/sax/features/validation", false);
        parserFactory.setNamespaceAware(true);
        SAXParser parser = parserFactory.newSAXParser();
        XMLReader saxReader = parser.getXMLReader();
        RootIdContentHandler handler = new RootIdContentHandler();
        saxReader.setContentHandler(handler);
        try {
            saxReader.parse(new InputSource(is));
        }
        catch (RootIdGatheredExeption ex) {
            return handler.rootId;
        }
        throw new NoIdGatheredExeption();
    }

    public String fastParse(URI uri) throws Exception {
        try (InputStream fis = null;){
            if (uri.isPlatformPlugin() && "com.indy.environment".equals(uri.segment(1))) {
                IInternalResourceRegistry.InternalResourceProvider p = InternalResourceFolderRegistry.INSTANCE.getProvider(uri);
                StringBuilder s = new StringBuilder();
                URI u = p.getPathRelativeToBundle(uri);
                int i = 0;
                while (i < u.segmentCount()) {
                    s.append("/");
                    s.append(URI.decode((String)u.segment(i)));
                    ++i;
                }
                Path relativePathToBundle = new Path(s.toString());
                try {
                    fis = FileLocator.openStream((Bundle)Platform.getBundle((String)p.getBundleName()), (IPath)relativePathToBundle, (boolean)false);
                }
                catch (Exception e) {
                    ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.semarchy.xdi.designer.index").error(e.getMessage(), (Object)e);
                }
            } else if (uri.isPlatformResource()) {
                fis = new BufferedInputStream(new FileInputStream(((XDIModelURIResolver)E4InjectorHelper.getService(XDIModelURIResolver.class)).resolve(uri)));
            } else {
                throw new Exception(Messages.StaxFastResourceLoader_3 + String.valueOf(uri));
            }
            String string = this.fastParse(fis);
            return string;
        }
    }

    public class NoIdGatheredExeption
    extends Exception {
    }

    private class RootIdContentHandler
    implements ContentHandler {
        private String rootId;
        private boolean rootRead = false;

        private RootIdContentHandler() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.rootId != null) {
                throw new RootIdGatheredExeption();
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (!this.rootRead) {
                String id = atts.getValue("id");
                if (this.rootId == null) {
                    this.rootId = id;
                }
                if (this.rootId != null) {
                    this.rootRead = true;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }

    private class RootIdGatheredExeption
    extends SAXException {
        private RootIdGatheredExeption() {
        }
    }
}

