/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.module.impl;

import com.indy.engine.core.module.IModuleService;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InternalModule
implements IModuleService.IModule,
IModuleService.IModuleDescriptor,
IModuleService.IBaseModuleInfo {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private Collection<URL> contentURL = null;
    private Collection<String> internalFileNames = null;
    private String moduleName;

    public InternalModule(String moduleName, File ... runtimeFolder) throws Exception {
        this.moduleName = moduleName;
        HashSet localURL = new HashSet();
        HashSet fileNames = new HashSet();
        Arrays.stream(runtimeFolder).forEach(f -> {
            try {
                localURL.add(f.toURI().toURL());
                fileNames.add(f.getName());
            }
            catch (MalformedURLException e) {
                this.logger.log(Level.WARNING, "Unexpected", e);
            }
        });
        this.contentURL = Collections.unmodifiableSet(localURL);
        this.internalFileNames = Collections.unmodifiableSet(fileNames);
    }

    @Override
    public String getName() {
        return this.moduleName;
    }

    @Override
    public Collection<URL> getURLs() throws Exception {
        return this.contentURL;
    }

    @Override
    public IModuleService.IModuleDescriptor getDescriptor() {
        return this;
    }

    @Override
    public File getInstallationFolder() {
        return null;
    }

    @Override
    public IModuleService.IBaseModuleInfo getBaseModuleInfo() {
        return this;
    }

    @Override
    public Properties getModuleProperties() {
        return new Properties();
    }

    @Override
    public String getModuleName() {
        return this.getName();
    }

    @Override
    public Collection<String> getFileNames() {
        return this.internalFileNames;
    }

    @Override
    public IModuleService.IBaseModuleInfo getBaseModuleExtensionInfo() {
        return null;
    }

    @Override
    public String getBundleProviderId() {
        return "com.indy.engine.core.module";
    }

    @Override
    public String getBundleProviderVersion() {
        return "1.0.0";
    }

    @Override
    public Integer getVersion() {
        return 1;
    }

    @Override
    public String getId() {
        return "com.indy.baseModule.generic";
    }

    @Override
    public String getComponentBundle() {
        return null;
    }
}

