/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.internal;

import com.semarchy.xdi.designer.core.indexation.IndexationRegisterExtension;
import com.semarchy.xdi.designer.core.models.LightWeightCrossReferencer;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.index.internal.CacheImpl;
import com.semarchy.xdi.designer.index.model.Elt;
import com.semarchy.xdi.designer.index.model.Source;
import com.semarchy.xdi.designer.index.model.StateType;
import com.semarchy.xdi.designer.index.parsers.StaxFastProxyResolver;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;

public class FastResolverCrossReferencer
extends LightWeightCrossReferencer {
    private Map<String, Collection<String>> toResolve = new HashMap<String, Collection<String>>();
    private Map<String, URI> eltURI = new HashMap<String, URI>();
    private boolean canHaveMandatoryRef = false;
    private Set<EObject> mandatoryRefProxy = new HashSet<EObject>();
    private EObject mainMandatoryRefProxy = null;
    private URI resourceURI;
    private String sourceID;
    private CacheImpl cache;

    public FastResolverCrossReferencer(CacheImpl cache, String sourceID, EObject o) {
        super(Collections.singleton(o));
        this.cache = cache;
        this.sourceID = sourceID;
        String extension = o.eResource().getURI().fileExtension();
        if ("md".equals(extension) || "tech".equals(extension) || "proc".equals(extension) || "tech_ext".equals(extension)) {
            this.canHaveMandatoryRef = true;
        }
        this.resourceURI = o.eResource().getURI();
    }

    public Collection<EStructuralFeature.Setting> put(EObject key, Collection<EStructuralFeature.Setting> value) {
        if (key.eIsProxy()) {
            String fileID = CacheHelper.extractFileID((EObject)key);
            if (!this.sourceID.equals(fileID)) {
                this.addToResolve(key);
                return (Collection)super.put((Object)key, value);
            }
            return Collections.EMPTY_LIST;
        }
        this.addToResolve(key);
        return (Collection)super.put((Object)key, value);
    }

    protected void add(InternalEObject eObject, EReference eReference, EObject crossReferencedEObject) {
        if (!IndexationRegisterExtension.EXTENSION_MANAGER.isAvailableRelation2((EStructuralFeature)eReference, (EObject)eObject)) {
            return;
        }
        if (!this.mandatoryRefProxy.contains(crossReferencedEObject) && this.isMandatoryReference(eObject, eReference)) {
            if (this.mandatoryRefProxy.isEmpty() && this.resourceURI.fileExtension().equals("md") && eReference.getName().equals("ref")) {
                this.mainMandatoryRefProxy = crossReferencedEObject;
            }
            this.mandatoryRefProxy.add(crossReferencedEObject);
        }
        super.add(eObject, eReference, crossReferencedEObject);
    }

    public EObject getMainMandatoryRefProxy() {
        return this.mainMandatoryRefProxy;
    }

    private boolean isMandatoryReference(InternalEObject eObject, EReference eReference) {
        if (this.canHaveMandatoryRef && !eReference.isContainment()) {
            String extension = this.resourceURI.fileExtension();
            if ("tech".equals(extension) || "md".equals(extension) || "tech_ext".equals(extension)) {
                if (eReference.getName().equals("ref") ? (eObject.eClass().getName().equals("Tech") || eObject.eClass().getName().equals("MdNode") || eObject.eClass().getName().equals("MdRootNode")) && eObject.eContainer() != null && eObject.eContainer().eClass().getName().equals("DocumentRoot") : "md".equals(extension) && eReference.getName().equals("target") && eObject.eClass().getName().equals("MdLink")) {
                    return true;
                }
            } else if ("proc".equals(extension)) {
                if (eReference.getName().equals("targetName") && eObject.eClass().getName().equals("ActionProcessRef")) {
                    return true;
                }
                if (eReference.getName().equals("target") && eObject.eClass().getName().equals("MetaDataLink")) {
                    return true;
                }
            }
        }
        return false;
    }

    private void addToResolve(EObject key) {
        Elt elt;
        URI uri = ((InternalEObject)key).eProxyURI();
        if (uri == null) {
            return;
        }
        String eltID = CacheHelper.extractEltID((EObject)key);
        String srcID = CacheHelper.extractFileID((EObject)key);
        URI old = this.eltURI.put(eltID, uri);
        if (old != null) {
            old.equals(uri);
        }
        if ((elt = this.cache.getSuper().findElt(eltID, srcID)) == null || elt.getState() != StateType.EXISTS) {
            if (eltID != null && srcID != null) {
                Collection<String> c = this.toResolve.get(srcID);
                if (c == null) {
                    c = new HashSet<String>();
                    this.toResolve.put(srcID, c);
                }
                c.add(eltID);
            } else if (srcID == null) {
                srcID = this.cache.getSourceId(uri.trimFragment());
                if (eltID != null && srcID != null) {
                    Collection<String> c = this.toResolve.get(srcID);
                    if (c == null) {
                        c = new HashSet<String>();
                        this.toResolve.put(srcID, c);
                    }
                    c.add(eltID);
                }
            } else {
                throw new RuntimeException("");
            }
        }
    }

    public void putAll(Map<? extends EObject, ? extends Collection<EStructuralFeature.Setting>> m) {
        for (EObject eObject : m.keySet()) {
            this.addToResolve(eObject);
        }
        super.putAll(m);
    }

    public Collection<EObject> getMandatoryRefProxy() {
        return this.mandatoryRefProxy;
    }

    public void fastResolve() {
        StaxFastProxyResolver resolver = new StaxFastProxyResolver();
        for (String ID : this.toResolve.keySet()) {
            Collection<String> proxies;
            Source s = this.cache.getSuper().getSource(ID);
            if (s == null || (proxies = this.toResolve.get(ID)).isEmpty()) continue;
            try {
                URI sourceURI = s.getURI();
                if (sourceURI == null && (sourceURI = this.eltURI.get(ID)) != null) {
                    sourceURI = sourceURI.trimFragment();
                }
                if (sourceURI == null) continue;
                HashSet<String> resolved = new HashSet<String>();
                try {
                    for (String eltID : resolver.fastResolve(proxies, sourceURI)) {
                        try {
                            this.udateState(eltID, s, StateType.EXISTS);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        resolved.add(eltID);
                    }
                }
                catch (Exception eltID) {
                    // empty catch block
                }
                for (String eltID : proxies) {
                    if (resolved.contains(eltID)) continue;
                    try {
                        this.udateState(eltID, s, StateType.INEXISTENT);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void udateState(String eltID, Source s, StateType state) throws Exception {
        Elt elt = this.cache.getSuper().findElt(eltID, s.getId());
        if (elt == null) {
            AnyType type = XMLTypeFactory.eINSTANCE.createAnyType();
            ((InternalEObject)type).eSetProxyURI(this.eltURI.get(eltID));
            elt = this.cache.getSuper().getOrCreateElt((EObject)type);
            elt.setSource(s);
        }
        elt.setState(state);
    }
}

