/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.internal;

import com.indy.administration.AdministrationHelper;
import com.indy.administration.AdministrationListener;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IComponentService;
import com.semarchy.xdi.designer.core.services.IInternalResourceRegistry;
import com.semarchy.xdi.designer.core.services.IModelTranslationProvider;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.index.internal.InternalResourceFolder;
import com.semarchy.xdi.designer.index.internal.Messages;
import com.semarchy.xdi.designer.index.parsers.StaxFastResourceLoader;
import java.io.BufferedInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.log.LogService;

public class InternalResourceFolderRegistry
implements IInternalResourceRegistry,
IModelTranslationProvider,
AdministrationListener {
    public static final String EXTENTION_POINT_ID = "com.indy.ui.custom.out.internalResources";
    private List<InternalResourceFolder> folders = new ArrayList<InternalResourceFolder>();
    private Set<String> foldersNames = new HashSet<String>();
    private Set<URI> allURIS = new HashSet<URI>();
    public static final InternalResourceFolderRegistry INSTANCE = new InternalResourceFolderRegistry();
    private volatile boolean loaded = false;
    private volatile int readerCount = 0;
    private Semaphore lock = new Semaphore(0, true);
    private Map<String, List<java.net.URI>> languageFile = new HashMap<String, List<java.net.URI>>();
    private Set<URI> languageFileToProcess = new HashSet<URI>();
    private Map<String, IComponentService.IComponent> componentsPerIds = new HashMap<String, IComponentService.IComponent>();
    private Set<InternalResourceFolder> loadedFolder = new HashSet<InternalResourceFolder>();
    private boolean overrideEventHappened = false;

    private void releaseReadLock(boolean hasBeenLocked) {
        if (hasBeenLocked && this.readerCount > 0) {
            this.lock.release();
            --this.readerCount;
        }
    }

    public Collection<String> getFoldersName() {
        boolean useSem = this.tryReadLock();
        try {
            Set<String> set = this.foldersNames;
            return set;
        }
        finally {
            this.releaseReadLock(useSem);
        }
    }

    public Collection<URI> getURIFromFolder(String folderName) {
        boolean useSem = this.tryReadLock();
        try {
            HashSet<URI> l = new HashSet<URI>();
            for (InternalResourceFolder f : this.folders) {
                if (!folderName.equalsIgnoreCase(f.getInternalResourcePath())) continue;
                l.addAll(f.getFilesURI());
            }
            HashSet<URI> hashSet = l;
            return hashSet;
        }
        finally {
            this.releaseReadLock(useSem);
        }
    }

    private boolean tryReadLock() {
        if (!this.loaded) {
            block4: {
                ++this.readerCount;
                if (!this.lock.tryAcquire(500L, TimeUnit.MILLISECONDS)) break block4;
                return true;
            }
            try {
                this.load((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public Collection<URI> getInternalResourceURI() {
        boolean useSem = this.tryReadLock();
        try {
            Set<URI> set = this.allURIS;
            return set;
        }
        finally {
            this.releaseReadLock(useSem);
        }
    }

    public void generateInternalResourceFiles() {
        for (InternalResourceFolder p : this.folders) {
            p.generateFilesInto();
        }
    }

    private synchronized void load(IProgressMonitor monitor) {
        if (this.loaded) {
            return;
        }
        AdministrationHelper.removeListener((AdministrationListener)this);
        try {
            IComponentService componentService = (IComponentService)E4InjectorHelper.getService(IComponentService.class);
            Logger.getLogger(this.getClass().getName()).info("Loading internal resources");
            this.folders.clear();
            this.foldersNames.clear();
            this.allURIS.clear();
            this.languageFile.clear();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENTION_POINT_ID);
            if (extensionPoint == null) {
                try {
                    throw new Exception(Messages.InternalResourceFolderRegistry_2 + EXTENTION_POINT_ID);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            IConfigurationElement[] iConfigurationElementArray = extensionPoint.getConfigurationElements();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement el = iConfigurationElementArray[n2];
                try {
                    String contributorId = el.getContributor().getName();
                    String bundlePath = el.getAttribute("bundleSourcePath");
                    Object fileExtensions = el.getAttribute("fileExtensions");
                    String internalResourcePath = el.getAttribute("internalResourcePath");
                    String resourceImportPath = el.getAttribute("defaultImportPath");
                    if (bundlePath == null || bundlePath.trim().isEmpty()) {
                        throw new Exception(Messages.bind((String)Messages.InternalResourceFolderRegistry_7, (Object)EXTENTION_POINT_ID, (Object)contributorId));
                    }
                    if (internalResourcePath == null || internalResourcePath.trim().isEmpty()) {
                        throw new Exception(Messages.bind((String)Messages.InternalResourceFolderRegistry_9, (Object)EXTENTION_POINT_ID, (Object)contributorId));
                    }
                    if (fileExtensions != null) {
                        fileExtensions = (String)fileExtensions + ",properties";
                    }
                    IComponentService.IComponent component = componentService.getComponentByBundleProvider(contributorId).orElse(null);
                    InternalResourceFolder f = new InternalResourceFolder(component, contributorId, bundlePath, fileExtensions == null ? null : ((String)fileExtensions).split(","), internalResourcePath, resourceImportPath);
                    this.folders.add(f);
                    if (internalResourcePath != null) {
                        this.foldersNames.add(internalResourcePath);
                    }
                    if (component == null || AdministrationHelper.componentAuthorized((IComponentService.IComponent)component)) {
                        this.processProviderContent(f);
                    }
                }
                catch (Exception r) {
                    r.printStackTrace();
                }
                ++n2;
            }
        }
        finally {
            this.generateInternalResourceFiles();
            this.registerModesComponentProvider();
            this.loaded = true;
            this.lock.release(this.readerCount);
            this.readerCount = 0;
            AdministrationHelper.addListener((AdministrationListener)this);
        }
    }

    protected static Predicate<URI> filterIndexableModels() {
        return uri -> "map".equals(uri.fileExtension()) || "proc".equals(uri.fileExtension()) || "md".equals(uri.fileExtension()) || "tech".equals(uri.fileExtension()) || "tpc".equals(uri.fileExtension()) || "tech_ext".equals(uri.fileExtension());
    }

    private void processProviderContent(InternalResourceFolder folder) {
        Logger.getLogger(this.getClass().getName()).info("Processing folder " + folder.getBundleName());
        this.loadedFolder.add(folder);
        for (URI uri : folder.getFilesURI()) {
            String fileExt = uri.fileExtension();
            if (InternalResourceFolderRegistry.filterIndexableModels().test(uri)) {
                if (!this.allURIS.add(uri)) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "The plugin " + folder.getBundleName() + " defined an internalResource which has already been deployed by another plugins (" + String.valueOf(uri) + "). Check the extensionPoint com.indy.ui.custom.out.internalResources");
                    ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.semarchy.xdi.designer.index").warn(Messages.bind((String)Messages.InternalResourceFolderRegistry_20, (Object[])new Object[]{folder.getBundleName(), uri, EXTENTION_POINT_ID}));
                    continue;
                }
                Logger.getLogger(this.getClass().getName()).info("Added into INternalResources " + String.valueOf(uri) + " from " + folder.getBundleName());
                continue;
            }
            if (!"properties".equals(fileExt)) continue;
            if (uri.trimFragment().lastSegment().endsWith("_" + Platform.getNL() + ".properties")) {
                this.handleExternalizationFile(uri);
                continue;
            }
            this.handleExternalizationFile(uri);
        }
    }

    private void handleExternalizationFile(URI uri) {
        this.languageFileToProcess.add(uri);
    }

    private void processExternalizationFile() {
        InternalResourceURIConverter c = new InternalResourceURIConverter();
        for (URI uri : this.languageFileToProcess) {
            URI modelURI = this.getTranslationKey(uri);
            List<java.net.URI> files = this.languageFile.get(modelURI.toString());
            if (files == null) {
                files = new ArrayList<java.net.URI>();
                this.languageFile.put(modelURI.toString(), files);
            }
            try {
                URI normalized = c.normalize(uri);
                URL url = new URL(URI.decode((String)normalized.toString()));
                url = FileLocator.find((URL)url);
                url = new URL(url.toString());
                files.add(new java.net.URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef()));
                files.sort(Comparator.comparing(java.net.URI::toString));
            }
            catch (Exception ex) {
                ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger(this.getClass()).error(String.format("Failed to find externalization file %s", uri), (Object)ex);
            }
        }
        this.languageFileToProcess.clear();
    }

    private URI getTranslationKey(URI uri) {
        String lastSegment = uri.trimFileExtension().lastSegment();
        URI modelURI = uri.trimFileExtension().trimSegments(1);
        modelURI = "properties".equals(uri.fileExtension()) ? (lastSegment.endsWith("_" + Platform.getNL()) ? modelURI.appendSegment(lastSegment.substring(0, lastSegment.length() - 3)) : modelURI.appendSegment(lastSegment)) : modelURI.appendSegment(lastSegment);
        return modelURI;
    }

    public boolean contains(URI uri) {
        boolean useSem = this.tryReadLock();
        try {
            boolean bl = this.allURIS.contains(uri);
            return bl;
        }
        finally {
            this.releaseReadLock(useSem);
        }
    }

    public IInternalResourceRegistry.InternalResourceProvider getProvider(URI uri) {
        boolean useSem = this.tryReadLock();
        try {
            for (InternalResourceFolder f : this.folders) {
                if (!f.getFilesURI().contains(uri)) continue;
                InternalResourceFolder internalResourceFolder = f;
                return internalResourceFolder;
            }
            return null;
        }
        finally {
            this.releaseReadLock(useSem);
        }
    }

    public Collection<IInternalResourceRegistry.InternalResourceProvider> getProviders() {
        boolean useSem = this.tryReadLock();
        try {
            List<IInternalResourceRegistry.InternalResourceProvider> list = this.folders;
            return list;
        }
        finally {
            this.releaseReadLock(useSem);
        }
    }

    public List<java.net.URI> getTranslationFileURI(URI modelURI) {
        this.processExternalizationFile();
        URI translationKey = this.getTranslationKey(modelURI);
        return this.languageFile.get(translationKey.toString());
    }

    private void registerModesComponentProvider() {
        StaxFastResourceLoader loader = new StaxFastResourceLoader();
        this.folders.forEach(f -> {
            IComponentService.IComponent component = f.getComponent();
            if (component != null) {
                f.getBundleEntryURL().forEach(u -> {
                    try {
                        Throwable throwable = null;
                        Object var5_7 = null;
                        try (BufferedInputStream is = new BufferedInputStream(u.openStream());){
                            String modelID = loader.fastParse(is);
                            if (modelID != null) {
                                this.componentsPerIds.put(modelID, component);
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        });
    }

    public IComponentService.IComponent getProvidingComponent(String modelID) {
        return this.componentsPerIds.get(modelID);
    }

    public void handleRoleChanged() {
        boolean useSem = this.tryReadLock();
        boolean refresh = false;
        try {
            for (InternalResourceFolder f : this.folders) {
                if (f.getComponent() == null) continue;
                if (AdministrationHelper.componentAuthorized((IComponentService.IComponent)f.getComponent())) {
                    if (!this.loadedFolder.add(f)) continue;
                    this.processProviderContent(f);
                    refresh = true;
                    continue;
                }
                if (!this.loadedFolder.remove(f)) continue;
                f.getFilesURI().stream().filter(InternalResourceFolderRegistry.filterIndexableModels()).forEach(uri -> this.allURIS.remove(uri));
                refresh = true;
            }
        }
        finally {
            this.releaseReadLock(useSem);
        }
        if (refresh) {
            ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).init(true);
        }
    }
}

