/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.internal;

import com.semarchy.xdi.designer.core.models.IMetaDataInformationsProviderFactory;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IMappingBuildJobFactory;
import com.semarchy.xdi.designer.core.services.IMappingBuilderDelegate;
import com.semarchy.xdi.designer.core.services.IWorkspaceListener;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.services.cache.CacheEventResource;
import com.semarchy.xdi.designer.core.services.cache.CacheEventURI;
import com.semarchy.xdi.designer.core.services.cache.ICacheListener;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.index.internal.MappingBuildDelegateFactory;
import com.semarchy.xdi.designer.index.internal.Messages;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.equinox.app.IApplicationContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ICacheListener.class, ICacheService.ICacheServiceListener.class, IMappingBuilderDelegate.IMappingBuildManager.class})
public class MappingBuildHandler
implements ICacheListener,
ICacheService.ICacheServiceListener,
IMappingBuilderDelegate.IMappingBuildManager {
    private static final String RESOURCE_PLUGIN_ID = "org.eclipse.core.resources";
    private static final String AUTOBUILD_PREFERENCE_KEY = "description.autobuilding";
    ISchedulingRule mutexRule = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return this.isConflicting(rule);
        }
    };
    Set<String> preBuiltMappingId = Collections.synchronizedSet(new HashSet());
    Set<String> mappingIdToBuild = Collections.synchronizedSet(new HashSet());
    Set<URI> mappingToClean = Collections.synchronizedSet(new HashSet());
    IMappingBuilderDelegate delegateBuilder;
    @Reference(service=IMetaDataInformationsProviderFactory.class)
    IMetaDataInformationsProviderFactory mdipf = null;
    @Reference(service=XDIModelURIResolver.class)
    XDIModelURIResolver modelResolver;
    @Reference(service=ICacheService.class)
    ICacheService cacheService;
    @Reference(service=IMappingBuildJobFactory.class)
    IMappingBuildJobFactory jobFactory;
    private List<CacheEventResource> cachedEventResource = Collections.synchronizedList(new ArrayList());
    private List<CacheEventURI> cachedEventURI = Collections.synchronizedList(new ArrayList());
    private boolean listeningToResource = false;
    private List<CacheEventURI> unHandledEvents = Collections.synchronizedList(new ArrayList());
    Job lastJob;
    private boolean inited = false;
    private boolean applicationInited = false;
    boolean hasNewMappingToBuild = false;
    private volatile boolean autobuild = false;
    private IEclipsePreferences autoBuildPreferences;
    private final Logger logger = LogManager.getLogger(this.getClass());
    private MappingBuildDelegateFactory jobDelegateFactory = new MappingBuildDelegateFactory();
    private Collection<URI> askedForBuild = new HashSet<URI>();

    private void updateAutoBuild(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals(AUTOBUILD_PREFERENCE_KEY)) {
            this.autobuild = this.autoBuildPreferences.getBoolean(AUTOBUILD_PREFERENCE_KEY, true);
            this.handleEventsTriggered();
        }
    }

    @Reference(service=IMappingBuilderDelegate.class)
    public void bind(IMappingBuilderDelegate delegate) {
        this.delegateBuilder = delegate;
        if (!this.listeningToResource) {
            this.autoBuildPreferences = InstanceScope.INSTANCE.getNode(RESOURCE_PLUGIN_ID);
            if (this.autoBuildPreferences != null) {
                this.autoBuildPreferences.addPreferenceChangeListener(this::updateAutoBuild);
                this.autobuild = this.autoBuildPreferences.getBoolean(AUTOBUILD_PREFERENCE_KEY, true);
            }
            this.listeningToResource = true;
        }
    }

    public void unbind(IMappingBuilderDelegate delegate) {
        if (delegate == this.delegateBuilder) {
            this.delegateBuilder = null;
        }
    }

    private void handleResourceBuildStateChanged(CacheEventResource event) {
        if (event.getType() == 1) {
            if (this.mappingIdToBuild.add(event.getSourceID())) {
                this.hasNewMappingToBuild = true;
            }
        } else {
            this.mappingIdToBuild.remove(event.getSourceID());
        }
    }

    private void handleResourceErrorStateChanged(CacheEventResource event) {
        if (event.getType() == 1) {
            this.mappingIdToBuild.remove(event.getSourceID());
        } else if (event.getType() == 2) {
            this.mappingIdToBuild.add(event.getSourceID());
            this.hasNewMappingToBuild = true;
        }
    }

    public void resourceBuildStateChanged(CacheEventResource event) {
        this.cachedEventResource.add(event);
    }

    public void resourceErrorStateChanged(CacheEventResource event) {
        this.cachedEventResource.add(event);
    }

    public boolean handleEvent(CacheEventResource event) {
        if (!(this.autobuild || event.getEventType() == CacheEventResource.EventType.ERROR && event.getType() == 1 || event.getEventType() == CacheEventResource.EventType.UNBUILT)) {
            return false;
        }
        try {
            return event.getResourceInfo() != null && "map".equals(event.getResourceInfo().fileExtension());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean handleEvent(CacheEventURI event) {
        if (!this.autobuild && event.getType() != CacheEventURI.Type.INEXISTED && event.getType() == CacheEventURI.Type.SYNCHRONIZED && event.getModelURI() != null && "map".equals(event.getModelURI().fileExtension())) {
            this.mappingToClean.add(event.getModelURI());
        }
        return event != null && event.getModelURI() != null && "map".equals(event.getModelURI().fileExtension());
    }

    private void handleCachedResourceEvent(CacheEventResource ev) {
        if (ev.getEventType() == CacheEventResource.EventType.ERROR) {
            this.handleResourceErrorStateChanged(ev);
        } else if (ev.getEventType() == CacheEventResource.EventType.UNBUILT) {
            this.handleResourceBuildStateChanged(ev);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void handleEventsTriggered() {
        if (!this.inited) {
            return;
        }
        List<CacheEventURI> list = this.cachedEventURI;
        synchronized (list) {
            this.cachedEventURI.stream().forEach(e -> SafeRunner.run(() -> this.handleCachedEvent((CacheEventURI)e)));
            this.cachedEventURI.clear();
        }
        list = this.cachedEventResource;
        synchronized (list) {
            this.cachedEventResource.stream().forEach(e -> SafeRunner.run(() -> this.handleCachedResourceEvent((CacheEventResource)e)));
            this.cachedEventResource.clear();
        }
        if (this.delegateBuilder == null) {
            this.logger.trace("Pending mapping because waiting for a delegate builder");
        }
        this.askForClean(Collections.emptyList());
        if (!this.askedForBuild.isEmpty()) {
            for (URI u : this.askedForBuild) {
                ICacheService.SourceState s = this.cacheService.getSourceState(u);
                if (s == null || !s.isSync()) continue;
                this.mappingIdToBuild.add(s.getSourceId());
                this.hasNewMappingToBuild = true;
            }
            this.askedForBuild.clear();
        }
        if (this.autobuild && !this.mappingIdToBuild.isEmpty() && this.hasNewMappingToBuild) {
            this.hasNewMappingToBuild = false;
            MappingBuildDelegateFactory.Result res = this.jobDelegateFactory.createBuildDelegate(this);
            this.lastJob = this.jobFactory.createJob(Messages.MappingBuildHandler_0, res.delegate, res.rule, (Object)"MAPPING_BUILD_JOB_FAMILY");
            this.logger.trace("Scheduling Build Job ...");
            this.lastJob.schedule();
        } else if (!this.autobuild) {
            this.logger.trace("build Job not created because autobuild is off");
        } else {
            this.logger.trace("build Job not created because no new mapping to build");
        }
    }

    public void handleCacheSourceChanged(CacheEventURI event) {
        this.cachedEventURI.add(event);
    }

    private boolean hasModelChangedSinceLastBuildAttempt(URI modelURI) {
        boolean modelChanged;
        ICacheService.SourceState srcState = this.cacheService.getSourceState(modelURI);
        if (srcState == null) {
            return false;
        }
        XMLGregorianCalendar d = srcState.getLastBuildAttempt();
        boolean bl = modelChanged = d == null || d.compare(srcState.getDateFile()) < 0;
        if (!modelChanged) {
            Collection dependanciesId = this.delegateBuilder.getAllDependancies(modelURI);
            for (String s : dependanciesId) {
                URI dependencyURI = this.cacheService.findResourceURIByFileId(s);
                ICacheService.SourceState dependancy = this.cacheService.getSourceState(dependencyURI);
                if (!modelChanged && dependancy != null && dependancy.isSync() && dependencyURI.isPlatformResource()) {
                    modelChanged = d.compare(dependancy.getLastScan()) < 0;
                    continue;
                }
                modelChanged = false;
                break;
            }
        }
        return modelChanged;
    }

    private void handleCachedEvent(CacheEventURI event) {
        if (!this.cacheService.isInit()) {
            if (event.getType() == CacheEventURI.Type.SYNCHRONIZED) {
                this.unHandledEvents.add(event);
            }
            return;
        }
        switch (event.getType()) {
            case SYNCHRONIZED: {
                if (!this.hasModelChangedSinceLastBuildAttempt(event.getModelURI()) || !this.mappingIdToBuild.add(event.getSourceID())) break;
                this.hasNewMappingToBuild = true;
                break;
            }
            case REMOVED: 
            case INEXISTED: {
                this.mappingIdToBuild.remove(event.getSourceID());
                this.preBuiltMappingId.remove(event.getSourceID());
                this.mappingToClean.add(event.getModelURI());
                break;
            }
            case DUPLICATED: {
                if (!"map".equals(event.getModelURI().fileExtension())) break;
                this.mappingToClean.add(event.getModelURI());
            }
        }
    }

    private void initializeApplication() {
        BundleContext ctx = Platform.getBundle((String)"com.semarchy.xdi.designer.index").getBundleContext();
        try {
            ServiceReference[] sr = ctx.getServiceReferences(IApplicationContext.class.getName(), null);
            if (sr != null && sr.length > 0) {
                E4InjectorHelper.consumeService(IWorkspaceListener.class, s -> s.listenWorkspace());
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to register IWorkspaceListener", (Throwable)e);
        }
        this.applicationInited = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCacheInitialized() {
        Set<URI> c;
        if (!this.applicationInited) {
            this.initializeApplication();
        }
        if (!this.inited) {
            this.inited = true;
        }
        this.askForClean(this.mappingToClean);
        List<CacheEventURI> list = this.unHandledEvents;
        synchronized (list) {
            for (CacheEventURI e : this.unHandledEvents) {
                ICacheService.SourceState state = this.cacheService.getSourceState(e.getModelURI());
                if (state.isBuilt() || !state.mayBeBuilt()) continue;
                this.mappingIdToBuild.add(e.getSourceID());
                this.hasNewMappingToBuild = true;
            }
            this.unHandledEvents.clear();
        }
        Set<URI> set = c = this.cacheService.getCacheState().getUnbuiltResources();
        synchronized (set) {
            for (URI uri : c) {
                try {
                    ICacheService.SourceState s = this.cacheService.getSourceState(uri);
                    if (s == null || !s.isSync() || s.isMissingCrossReference() || s.hasBrokenRequirements()) continue;
                    this.mappingIdToBuild.add(s.getSourceId());
                    this.hasNewMappingToBuild = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (!this.mappingToClean.isEmpty()) {
            set = this.mappingToClean;
            synchronized (set) {
                MappingBuildDelegateFactory.Result res = this.jobDelegateFactory.createCleanDeprecatedDelegate(this);
                Job cleanJob = this.jobFactory.createJob(Messages.MappingBuildHandler_155, res.getDelegate(), res.getSchedulingRule(), (Object)"MAPPING_BUILD_JOB_FAMILY");
                this.mappingToClean.clear();
                cleanJob.schedule();
            }
        }
        this.handleEventsTriggered();
    }

    public void handleCacheInitializing() {
        this.inited = false;
        this.mappingIdToBuild.clear();
        Job.getJobManager().cancel((Object)"MAPPING_BUILD_JOB_FAMILY");
        try {
            Job.getJobManager().join((Object)"MAPPING_BUILD_JOB_FAMILY", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (OperationCanceledException ex) {
            this.logger.warn("ICacheService.MAPPING_BUILD_JOB_FAMILY cancelled", (Throwable)ex);
        }
        if (this.lastJob != null && !this.lastJob.cancel()) {
            try {
                this.lastJob.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void prebuildMapping(Resource resource) {
        String id;
        block15: {
            id = this.cacheService.getSourceId(resource.getURI());
            try {
                try {
                    for (String s : this.delegateBuilder.getPrebuiltFilesPath(resource.getURI())) {
                        Files.deleteIfExists(Paths.get(s, new String[0]));
                    }
                }
                catch (Exception e) {
                    this.logger.error(() -> "Failed to deleted previously prebuilt files for " + String.valueOf(resource.getURI()), (Throwable)e);
                    this.preBuiltMappingId.remove(id);
                    break block15;
                }
            }
            catch (Throwable throwable) {
                this.preBuiltMappingId.remove(id);
                throw throwable;
            }
            this.preBuiltMappingId.remove(id);
        }
        if (this.delegateBuilder.canBeBuilt(resource)) {
            try {
                this.delegateBuilder.prebuildMapping(resource);
                this.preBuiltMappingId.add(id);
            }
            catch (Throwable ex) {
                this.logger.warn(() -> Messages.MappingBuildHandler_152 + String.valueOf(resource.getURI()), ex);
                try {
                    try {
                        for (String s : this.delegateBuilder.getPrebuiltFilesPath(resource.getURI())) {
                            Files.deleteIfExists(Paths.get(s, new String[0]));
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn("unexpected", (Throwable)e);
                        this.preBuiltMappingId.remove(id);
                    }
                }
                finally {
                    this.preBuiltMappingId.remove(id);
                }
            }
        }
    }

    public void askForBuild(Collection<URI> mappingFile) {
        if (mappingFile == null) {
            return;
        }
        if (!this.cacheService.isInit()) {
            this.askedForBuild.addAll(mappingFile);
            this.askedForBuild.remove(null);
        } else {
            AtomicBoolean added = new AtomicBoolean(false);
            mappingFile.stream().filter(uri -> uri != null && "map".equals(uri.fileExtension())).map(uri -> this.cacheService.getSourceState(uri)).filter(srcSt -> srcSt != null && srcSt.isSync()).forEach(srcSt -> {
                this.mappingIdToBuild.add(srcSt.getSourceId());
                this.hasNewMappingToBuild = true;
                added.set(true);
            });
            if (added.get()) {
                this.handleEventsTriggered();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void askForClean(Collection<URI> mappings) {
        Set<URI> set = this.mappingToClean;
        synchronized (set) {
            this.mappingToClean.addAll(mappings);
        }
        if (!this.inited) {
            return;
        }
        if (!this.mappingToClean.isEmpty()) {
            set = this.mappingToClean;
            synchronized (set) {
                MappingBuildDelegateFactory.Result res = this.jobDelegateFactory.createCleanDeprecatedDelegate(this);
                Job cleanJob = this.jobFactory.createJob(Messages.MappingBuildHandler_155, res.getDelegate(), res.getSchedulingRule(), (Object)"MAPPING_BUILD_JOB_FAMILY");
                this.mappingToClean.clear();
                cleanJob.schedule();
            }
        }
    }

    public void forceBuild(Resource resource) throws Exception {
        this.logger.trace("Force build on {}", (Object)resource.getURI());
        Job.getJobManager().sleep((Object)"MAPPING_BUILD_JOB_FAMILY");
        MappingBuildDelegateFactory.Result res = this.jobDelegateFactory.createForceBuildDelegate(this, resource);
        Job job = this.jobFactory.createJob(Messages.MappingBuildHandler_0, res.delegate, res.rule, (Object)"MAPPING_BUILD_JOB_FAMILY");
        job.setUser(true);
        job.schedule();
        job.join();
        this.logger.trace("Force build performed");
    }

    public void triggerBuild(Collection<URI> filesToBuild) {
        this.logger.trace("Build triggerred ");
        Job.getJobManager().sleep((Object)"MAPPING_BUILD_JOB_FAMILY");
        MappingBuildDelegateFactory.Result res = this.jobDelegateFactory.createTriggeredBuildDelegate(this, filesToBuild);
        Job job = this.jobFactory.createJob(Messages.MappingBuildHandler_0, res.delegate, res.rule, (Object)"MAPPING_BUILD_JOB_FAMILY");
        job.setUser(true);
        job.schedule();
        this.logger.trace("Triggered Build scheduled");
    }
}

