/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator.internal.data;

import com.indy.ui.common.resource.IFile;
import com.indy.ui.common.resource.IResource;
import com.stambia.ui.navigator.data.IPotentialResource;
import com.stambia.ui.navigator.internal.data.OwnDir;
import com.stambia.ui.navigator.internal.data.ResourceWithChildren;
import java.io.File;
import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.ui.IWorkbenchPage;

public class PrivateOwnDir
extends ResourceWithChildren
implements IFile {
    protected File file;

    public PrivateOwnDir(String name, PrivateOwnDir parent, String id) {
        super(name, parent, id);
        this.file = new File(parent.getSystemFile(), name);
    }

    public PrivateOwnDir(String name, File file) {
        super(name, null, UUID.randomUUID().toString());
        this.file = file;
    }

    public PrivateOwnDir(String name, String id) {
        super(name, null, id);
    }

    @Override
    public void dispose() {
        if (this.getChildren() != null) {
            for (IResource resource : this.getChildren().values()) {
                if (resource instanceof ResourceWithChildren) {
                    ((ResourceWithChildren)resource).removeChildrens(resource, false);
                }
                resource.dispose();
            }
        }
        this.file = null;
        super.dispose();
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getSystemFile() {
        return this.file;
    }

    public void synchronize(boolean deeply) {
        ArrayList<IPotentialResource> resources = new ArrayList<IPotentialResource>();
        if (this.file != null && this.file.exists() && this.file.isDirectory() && this.file.listFiles() != null) {
            File[] fileArray = this.file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                final File _file = fileArray[n2];
                if (_file.isDirectory()) {
                    resources.add(new IPotentialResource(){

                        @Override
                        public String getName() {
                            return _file.getName();
                        }

                        @Override
                        public IResource createResource() {
                            return new OwnDir(_file.getName(), PrivateOwnDir.this, _file.getName());
                        }

                        @Override
                        public String getId() {
                            return _file.getName();
                        }
                    });
                }
                ++n2;
            }
        }
        this.synchronize(resources, deeply);
    }

    public String getExtension() {
        int index;
        if (this.file != null && (index = this.file.getName().lastIndexOf(46)) > -1) {
            return this.file.getName().substring(index + 1);
        }
        return null;
    }

    public boolean openEditor(IWorkbenchPage activePage, String actionId) {
        return false;
    }
}

