/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator.internal.data;

import com.indy.ui.common.listener.NotificationManager;
import com.indy.ui.common.resource.IResource;
import com.stambia.ui.navigator.data.IPotentialResource;
import com.stambia.ui.navigator.internal.data.AbstractResource;
import com.stambia.ui.resource.ResourcePluginStambia;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ResourceWithChildren
extends AbstractResource {
    private Map<String, IResource> children = new HashMap<String, IResource>();

    protected ResourceWithChildren(String name, IResource parent, String resourceId) {
        super(name, parent, resourceId);
    }

    public void replaceChild(IResource resource) {
        if (this.existsChild(resource)) {
            this.children.put(resource.getResourceId(), resource);
            NotificationManager.getInstance().refreshItem(resource);
        }
    }

    public Map<String, IResource> getChildren() {
        return this.children;
    }

    public boolean existsChild(IResource resource) {
        return this.children.containsKey(resource.getResourceId());
    }

    public boolean hasChildrenRecursive(IResource current, IResource resourceToCheck) {
        if (current instanceof ResourceWithChildren) {
            if (((ResourceWithChildren)current).getChildren().containsKey(resourceToCheck.getResourceId())) {
                return true;
            }
            for (IResource child : current.getResources()) {
                if (!this.hasChildrenRecursive(child, resourceToCheck)) continue;
                return true;
            }
        }
        return false;
    }

    public IResource addChild(IResource resource, boolean force) {
        if (force || !this.existsChild(resource)) {
            this.children.put(resource.getResourceId(), resource);
            NotificationManager.getInstance().refreshItem(resource);
            ResourcePluginStambia.getDefault().getResourceListenerManager().notifyAdded(resource);
        }
        return this.children.get(resource.getResourceId());
    }

    public IResource removeChild(IResource resource) {
        return this.removeChild(resource, true);
    }

    public IResource removeChild(IResource resource, boolean notify) {
        IResource res = this.children.remove(resource.getResourceId());
        if (res != null && notify) {
            NotificationManager.getInstance().refreshItem(resource.getParent());
            ResourcePluginStambia.getDefault().getResourceListenerManager().notifyRemoved(res);
        }
        return res;
    }

    public void removeChildrens(IResource resource, boolean notify) {
        ArrayList<IResource> toDelete = new ArrayList<IResource>();
        if (resource.getResources() == null || resource.getResources().isEmpty()) {
            if (this.removeChild(resource, notify) == null && notify) {
                NotificationManager.getInstance().refreshItem(resource);
                ResourcePluginStambia.getDefault().getResourceListenerManager().notifyRemoved(resource);
            }
        } else {
            for (IResource currentChildrens : resource.getResources()) {
                toDelete.add(currentChildrens);
            }
            for (IResource toDeleteResource : toDelete) {
                this.removeChildrens(toDeleteResource, notify);
                this.removeChild(toDeleteResource, notify);
            }
        }
    }

    public void removeChildrens(IResource resource) {
        this.removeChildrens(resource, true);
    }

    @Override
    public Collection<IResource> getResources() {
        return this.children == null ? Collections.EMPTY_LIST : this.children.values();
    }

    public void synchronize(Collection<IPotentialResource> resources, boolean deeply) {
        HashMap<String, IResource> toRemove = new HashMap<String, IResource>(this.children);
        ArrayList<IResource> toAdd = new ArrayList<IResource>();
        for (IPotentialResource iPotentialResource : resources) {
            if (toRemove.containsKey(iPotentialResource.getId())) {
                if (!iPotentialResource.getName().equals(((IResource)toRemove.get(iPotentialResource.getId())).getName())) {
                    toAdd.add(iPotentialResource.createResource());
                    continue;
                }
                toRemove.remove(iPotentialResource.getId());
                continue;
            }
            this.addChild(iPotentialResource.createResource(), false);
        }
        for (IResource iResource : toRemove.values()) {
            this.removeChild(iResource);
        }
        for (IResource iResource : toAdd) {
            this.addChild(iResource, false);
        }
        if (deeply) {
            for (IResource iResource : this.children.values()) {
                iResource.synchronize(deeply);
            }
        }
        NotificationManager.getInstance().refreshItem((IResource)this);
    }

    @Override
    public void dispose() {
        if (this.children != null) {
            for (IResource resource : this.children.values()) {
                resource.dispose();
            }
            this.children.clear();
        }
        this.children = null;
        super.dispose();
    }
}

