/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.navigator.internal.data;

import com.indy.ui.common.resource.IResource;
import com.indy.ui.navigator.CommonUtils;
import com.stambia.ui.navigator.internal.data.INavigatorStatus;
import com.stambia.ui.navigator.internal.data.ResourceWithChildren;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

public abstract class StatusResourceWithChildren
extends ResourceWithChildren
implements INavigatorStatus {
    private boolean isWarning;
    private boolean isError;
    private Map<String, Set<String>> childrensStatus = new HashMap<String, Set<String>>();

    public StatusResourceWithChildren(String name, IResource parent, String resourceId) {
        super(name, parent, resourceId);
        this.childrensStatus.put("error", new HashSet());
        this.childrensStatus.put("warning", new HashSet());
    }

    @Override
    public Map<String, Set<String>> getChildrensStatus() {
        return this.childrensStatus;
    }

    @Override
    public Image getDecorator(Image baseImage) {
        return CommonUtils.getImageWithStatusDecoration(baseImage, this.isError, this.isWarning, this);
    }

    @Override
    public abstract void updateStatus(boolean var1, boolean var2);

    @Override
    public void setWarning(boolean warning) {
        this.isWarning = warning;
    }

    @Override
    public void setError(boolean error) {
        this.isError = error;
    }

    @Override
    public boolean isWarning() {
        return this.isWarning;
    }

    @Override
    public boolean isError() {
        return this.isError;
    }
}

