/*
 * Decompiled with CFR 0.152.
 */
package com.indy.connector.httprest.core;

import com.indy.engine.core.json.annotation.JsonElement;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;

public class WebServiceExchange {
    @JsonElement(name="requestbody", deserialiazeOnly=true)
    public Map<String, Object> request;
    @JsonElement(name="responses", serialiazeOnly=true)
    public Map<String, Object> responses = new HashMap<String, Object>();
    @JsonElement(name="parameters", deserialiazeOnly=true)
    public Map<String, String> params;

    public void addResponseExchange(String code, WebServiceResponse response) {
        this.responses.put(code, response);
    }

    public void addException(Exception e) {
        this.responses.put("technicalErrorMessage", e.getMessage());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        this.responses.put("technicalErrorException", sw.toString());
    }

    public static class ResponseInformation {
        @JsonElement(name="statusCode")
        public String statusCode;
        @JsonElement(name="reasonPhrase")
        public String reasonPhrase;
        @JsonElement(name="protocolVersion")
        public String protocolVersion;
    }

    public static class WebServiceMultipartContent {
    }

    public static class WebServiceRequest {
        @JsonElement(name="content")
        public Object content;
        @JsonElement(name="multipart")
        public Object multipart;
    }

    public static class WebServiceResponse {
        @JsonElement(name="content")
        public Object content;
        @JsonElement(name="headers")
        public Map<String, String> headers = new HashMap<String, String>();
        @JsonElement(name="cookies")
        public Map<String, String> cookies = new HashMap<String, String>();
        @JsonElement(name="respinfos")
        public ResponseInformation respInfos;
        @JsonElement(name="rawContent")
        public String rawContent;
    }
}

