/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.ui.tools.binding;

import com.ibm.icu.util.Calendar;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.emf.databinding.EMFUpdateValueStrategy;
import org.eclipse.emf.ecore.xml.type.internal.XMLCalendar;

public class BindingUtils {
    public static DateFormat df = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault());

    public static UpdateValueStrategy xmlDateToDate() {
        EMFUpdateValueStrategy strat = new EMFUpdateValueStrategy();
        strat.setConverter(new IConverter(){

            public Object getToType() {
                return Date.class;
            }

            public Object getFromType() {
                return XMLCalendar.class;
            }

            public Object convert(Object fromObject) {
                return ((XMLCalendar)fromObject).getDate();
            }
        });
        return strat;
    }

    public static UpdateValueStrategy dateToXmlDate() {
        EMFUpdateValueStrategy strat = new EMFUpdateValueStrategy();
        strat.setConverter(new IConverter(){

            public Object getToType() {
                return XMLCalendar.class;
            }

            public Object getFromType() {
                return Date.class;
            }

            public Object convert(Object fromObject) {
                return new XMLCalendar((Date)fromObject, 0);
            }
        });
        return strat;
    }

    public static EMFUpdateValueStrategy stringToXmlDate() {
        EMFUpdateValueStrategy strat = new EMFUpdateValueStrategy();
        strat.setConverter(new IConverter(){

            public Object getToType() {
                return XMLGregorianCalendar.class;
            }

            public Object getFromType() {
                return String.class;
            }

            public Object convert(Object fromObject) {
                try {
                    GregorianCalendar calendar = new GregorianCalendar();
                    Date date = df.parse((String)fromObject);
                    calendar.setTime(date);
                    return DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
                }
                catch (ParseException e) {
                    return null;
                }
                catch (DatatypeConfigurationException e) {
                    return null;
                }
            }
        });
        return strat;
    }

    public static EMFUpdateValueStrategy xmlDateToString() {
        EMFUpdateValueStrategy strat = new EMFUpdateValueStrategy();
        strat.setConverter(new IConverter(){

            public Object getToType() {
                return String.class;
            }

            public Object getFromType() {
                return XMLGregorianCalendar.class;
            }

            public Object convert(Object fromObject) {
                return df.format(((XMLGregorianCalendar)fromObject).toGregorianCalendar().getTime());
            }
        });
        return strat;
    }

    public static class ListNumberToStringConverter
    implements IConverter {
        public Object getFromType() {
            return List.class;
        }

        public Object getToType() {
            return String.class;
        }

        public Object convert(Object fromObject) {
            if (((List)fromObject).isEmpty()) {
                return "";
            }
            return ((List)fromObject).stream().map(String::valueOf).collect(Collectors.joining(","));
        }
    }

    public static class NumberToStringConverter
    implements IConverter {
        public Object getFromType() {
            return Integer.class;
        }

        public Object getToType() {
            return String.class;
        }

        public Object convert(Object fromObject) {
            if ((Integer)fromObject == 0) {
                return "";
            }
            return String.valueOf(fromObject);
        }
    }

    public static class NumberToStringConverterForYear
    implements IConverter {
        public Object getFromType() {
            return Integer.class;
        }

        public Object getToType() {
            return String.class;
        }

        public Object convert(Object fromObject) {
            if ((Integer)fromObject == 0) {
                String currentYear = String.valueOf(Calendar.getInstance().get(1));
                return currentYear;
            }
            return String.valueOf(fromObject);
        }
    }

    public static class StringToListNumberConverter
    implements IConverter {
        public Object getFromType() {
            return String.class;
        }

        public Object getToType() {
            return List.class;
        }

        public Object convert(Object fromObject) {
            if (((String)fromObject).isEmpty()) {
                return 0;
            }
            String[] convertedStringList = ((String)fromObject).split(",");
            ArrayList<Integer> intList = new ArrayList<Integer>();
            String[] stringArray = convertedStringList;
            int n = convertedStringList.length;
            int n2 = 0;
            while (n2 < n) {
                String number = stringArray[n2];
                intList.add(Integer.parseInt(number.trim()));
                ++n2;
            }
            return intList;
        }
    }

    public static class StringToNumberConverter
    implements IConverter {
        public Object getFromType() {
            return String.class;
        }

        public Object getToType() {
            return Integer.class;
        }

        public Object convert(Object fromObject) {
            if (((String)fromObject).isEmpty()) {
                return 0;
            }
            return Integer.parseInt((String)fromObject);
        }
    }

    public static class StringToNumberConverterForYear
    implements IConverter {
        public Object getFromType() {
            return String.class;
        }

        public Object getToType() {
            return Integer.class;
        }

        public Object convert(Object fromObject) {
            if (((String)fromObject).isEmpty()) {
                int year = Calendar.getInstance().get(1);
                return year;
            }
            return Integer.parseInt((String)fromObject);
        }
    }
}

