/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.ui.diagram.custom.move;

import com.indy.md.ui.diagram.Messages;
import com.indy.md.ui.diagram.custom.UISelector;
import com.stambia.md.MdNode;
import com.stambia.md.diagram.navigator.MdDomainNavigatorItem;
import com.stambia.tech.Level;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class MoveDialog
extends Dialog {
    private TreeViewer errors;
    private Level level;
    private Button replaceValidationButton;
    private Composite resultComposite;
    private UISelector<MdNode> mdSelector;
    private IFilter filter = null;
    private Clipboard clipboard;
    private URI resourceUri;
    private String targetNodeUri;

    public MoveDialog(Shell parentShell, Level level) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.level = level;
        this.clipboard = new Clipboard(parentShell.getDisplay());
    }

    public void setFilter(IFilter filter) {
        this.filter = filter;
        this.updateControlVisibility();
    }

    private void updateControlVisibility() {
        if (this.replaceValidationButton != null) {
            this.replaceValidationButton.setVisible(this.filter != null);
            this.resultComposite.setVisible(this.filter != null);
            this.resultComposite.getParent().layout(true, true);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setBackground(Display.getCurrent().getSystemColor(1));
        c.setLayout((Layout)new GridLayout());
        c.setLayoutData((Object)new GridData(1808));
        SashForm sash = new SashForm(c, 256);
        sash.setLayoutData((Object)new GridData(4, 4, true, true));
        sash.setBackground(c.getBackground());
        Composite left = new Composite((Composite)sash, 0);
        left.setLayoutData((Object)new GridData(1808));
        left.setLayout((Layout)new GridLayout());
        left.setBackground(c.getBackground());
        Composite right = new Composite((Composite)sash, 0);
        right.setLayoutData((Object)new GridData(1808));
        right.setLayout((Layout)new GridLayout());
        right.setBackground(c.getBackground());
        this.resultComposite = right;
        this.resultComposite.setVisible(false);
        Button b = new Button(c, 32);
        b.setBackground(c.getBackground());
        b.setLayoutData((Object)new GridData());
        b.setText(Messages.MoveDialog_0);
        b.setToolTipText(Messages.MoveDialog_1);
        b.setSelection(true);
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MoveDialog.this.filter.stopOnFirstMissing(((Button)e.widget).getSelection());
                if (!((Button)e.widget).getSelection()) {
                    MoveDialog.this.mdSelector.getConsumer().accept(MoveDialog.this.mdSelector.getSelectedObject());
                }
            }
        });
        this.replaceValidationButton = b;
        this.replaceValidationButton.setVisible(false);
        Label l = new Label(left, 0);
        l.setBackground(c.getBackground());
        l.setLayoutData((Object)new GridData());
        l.setText(Messages.MoveDialog_2 + this.level.getDisplayName());
        Composite result = new Composite(right, 0);
        result.setBackground(c.getBackground());
        result.setLayoutData((Object)new GridData());
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        result.setLayout((Layout)layout);
        Label l2 = new Label(result, 0);
        l2.setBackground(c.getBackground());
        l2.setLayoutData((Object)new GridData());
        l2.setText(Messages.MoveDialog_3);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ToolBar tb = new ToolBar(result, 0x800000);
        ToolItem it2 = new ToolItem(tb, 8);
        it2.setToolTipText(Messages.MoveDialog_4);
        it2.setImage(sharedImages.getImage("IMG_TOOL_COPY"));
        it2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringBuilder buf = new StringBuilder();
                Object[] objectArray = ((ITreeContentProvider)MoveDialog.this.errors.getContentProvider()).getElements(MoveDialog.this.errors.getInput());
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    buf.append(((ILabelProvider)MoveDialog.this.errors.getLabelProvider()).getText(o) + "\n");
                    Object[] objectArray2 = ((ITreeContentProvider)MoveDialog.this.errors.getContentProvider()).getChildren(o);
                    int n3 = objectArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object c = objectArray2[n4];
                        buf.append(((ILabelProvider)MoveDialog.this.errors.getLabelProvider()).getText(c) + "\n");
                        ++n4;
                    }
                    ++n2;
                }
                MoveDialog.this.clipboard.setContents((Object[])new String[]{buf.toString()}, new Transfer[]{TextTransfer.getInstance()});
            }
        });
        this.mdSelector = this.createMdRefSelector();
        Consumer<MdNode> selectionHandler = selectedMd -> {
            boolean selectionMatch;
            if (selectedMd == null) {
                selectionMatch = false;
                this.errors.setInput(Collections.emptyMap());
            } else {
                selectionMatch = selectedMd.getLevel().getCode().equals(this.level.getCode());
                if (selectionMatch && this.filter != null) {
                    selectionMatch = this.filter.accept((MdNode)selectedMd);
                    if (!this.filter.getErrors().isEmpty()) {
                        this.errors.setInput(this.filter.getErrors());
                    } else {
                        this.errors.setInput(Collections.emptyMap());
                    }
                } else if (this.filter == null) {
                    this.errors.setInput(Collections.emptyMap());
                }
            }
            this.getButton(0).setEnabled(selectionMatch);
        };
        this.mdSelector.setConsumer(selectionHandler);
        this.mdSelector.createControl(left);
        this.errors = new TreeViewer(right, 68354);
        this.errors.setAutoExpandLevel(-1);
        this.errors.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.errors.setContentProvider((IContentProvider)new ITreeContentProvider(){
            Map inputElement;

            public void dispose() {
                this.inputElement = null;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                this.inputElement = (Map)newInput;
            }

            public Object[] getElements(Object inputElement) {
                Set c = ((Map)inputElement).keySet();
                return c.toArray(new Object[c.size()]);
            }

            public Object[] getChildren(Object parentElement) {
                Collection c = (Collection)this.inputElement.get(parentElement);
                if (c != null) {
                    return c.toArray(new Object[c.size()]);
                }
                return Collections.emptyList().toArray();
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof IResource;
            }
        });
        this.errors.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

            public String getText(Object element) {
                if (element instanceof IResource) {
                    return NLS.bind((String)Messages.MoveDialog_15, (Object)(((IResource)element).getProject().getName() + "/" + ((IResource)element).getProjectRelativePath().toString()));
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                IWorkbenchAdapter adapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(element, IWorkbenchAdapter.class);
                if (adapter != null) {
                    return (Image)this.resourceManager.get((DeviceResourceDescriptor)adapter.getImageDescriptor(element));
                }
                return null;
            }
        });
        this.updateControlVisibility();
        return c;
    }

    private UISelector<MdNode> createMdRefSelector() {
        String fileExtension = "md";
        Function<IStructuredSelection, MdNode> selectionAdapterFunction = ss -> {
            EObject obj;
            if (!ss.isEmpty() && ss.getFirstElement() instanceof MdDomainNavigatorItem && (obj = ((MdDomainNavigatorItem)((Object)((Object)ss.getFirstElement()))).getEObject()) instanceof MdNode) {
                return (MdNode)obj;
            }
            return null;
        };
        Predicate<IFile> validateFileCondition = file -> {
            try {
                IMarker[] m = file.findMarkers("com.stambia.resource.marker.duplicate", true, 0);
                if (file.getFileExtension() != null && file.getFileExtension().equals("md")) {
                    return m == null || m.length == 0;
                }
                return false;
            }
            catch (CoreException e) {
                return false;
            }
        };
        return new UISelector<MdNode>(selectionAdapterFunction, validateFileCondition, fileExtension);
    }

    protected void initializeBounds() {
        this.getShell().setSize(800, 600);
        this.getShell().setText(Messages.MoveDialog_16);
    }

    public String getTargetURIFragment() {
        return this.targetNodeUri;
    }

    public URI getResourceUri() {
        return this.resourceUri;
    }

    protected void okPressed() {
        MdNode targetNode = this.mdSelector.getSelectedObject();
        Resource resource = targetNode.eResource();
        this.resourceUri = resource.getURI();
        this.targetNodeUri = resource.getURIFragment((EObject)targetNode);
        super.okPressed();
    }

    public static interface IFilter {
        public boolean accept(MdNode var1);

        public Map<IResource, List<String>> getErrors();

        public void stopOnFirstMissing(boolean var1);
    }
}

