/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.diagram.custom.properties;

import com.indy.ui.custom.out.GlobalPropertySection;
import com.indy.ui.custom.out.common.properties.UIControl;
import com.indy.ui.custom.out.common.properties.UIControlDescriptor;
import com.indy.ui.custom.out.fixes.MacOsTextHelper;
import com.semarchy.xdi.designer.core.models.IRebuildableUI;
import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.Element;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.custom.Util;
import com.stambia.md.diagram.custom.properties.ConfigurationControlDescriptor;
import com.stambia.md.diagram.custom.properties.ControlEnabler;
import com.stambia.md.diagram.custom.properties.IMdSectionHelper;
import com.stambia.md.diagram.custom.properties.MdSectionControlFactory;
import com.stambia.md.diagram.custom.properties.MdTabDescriptorProvider;
import com.stambia.md.diagram.custom.properties.MdValueSetter;
import com.stambia.md.diagram.custom.properties.Messages;
import com.stambia.md.diagram.custom.properties.ModuleListValueProvider;
import com.stambia.md.diagram.custom.properties.NameUIControlDescriptor;
import com.stambia.md.diagram.custom.properties.PropertyComparator;
import com.stambia.md.diagram.custom.properties.UIControlDescriptorImpl;
import com.stambia.md.diagram.navigator.MdDomainNavigatorItem;
import com.stambia.md.diagram.part.MdDiagramEditorPlugin;
import com.stambia.md.presentation.MdEditor;
import com.stambia.md.util.MdNodeInitializer;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.properties.views.IReadOnlyDiagramPropertySheetPageContributor;
import org.eclipse.gmf.runtime.diagram.ui.properties.views.PropertiesBrowserPage;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class PropertySection
extends GlobalPropertySection
implements IRebuildableUI {
    MdSectionControlFactory controlFactory;
    MdValueSetter valueSetter;
    Helper helper = new Helper();
    Composite topComposite;
    Map<String, Group> groupComposites = new HashMap<String, Group>();
    Map<UIControlDescriptorImpl, UIControl> controls = new HashMap<UIControlDescriptorImpl, UIControl>();
    Map<UIControl, ControlDecoration> controlsDecoration = new HashMap<UIControl, ControlDecoration>();
    ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    AdapterFactoryLabelProvider aflp = new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
    Collection<String> propertyWhoseChangeRequiresUIRebuild;
    boolean needToRebuildUI = true;
    boolean lock = false;
    String categoryFilter;

    public PropertySection(String tabLabel) {
        this.categoryFilter = tabLabel;
        this.valueSetter = new MdValueSetter(this.helper);
    }

    public NotificationFilter getFilter() {
        return NotificationFilter.createEventTypeFilter((int)1).or(NotificationFilter.createEventTypeFilter((int)2).or(NotificationFilter.createEventTypeFilter((int)3)).or(NotificationFilter.createEventTypeFilter((int)4))).and(NotificationFilter.createNotifierTypeFilter(EObject.class));
    }

    public void dispose() {
        if (this.controls != null) {
            this.controls.entrySet().stream().map(Map.Entry::getKey).forEach(UIControlDescriptor.ValueProvider::dispose);
            this.controls.clear();
            this.controls = null;
        }
        this.controlsDecoration.entrySet().stream().map(Map.Entry::getValue).forEach(ControlDecoration::dispose);
        this.controlsDecoration.clear();
        super.dispose();
        this.aflp.dispose();
        this.adapterFactory.dispose();
    }

    protected void initializeControls(Composite parent) {
        this.controlFactory = new MdSectionControlFactory(this.helper, this.getWidgetFactory());
        parent.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        Composite composite = this.getWidgetFactory().createComposite(parent);
        gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(3, false));
        MacOsTextHelper.handle((Composite)composite, (Composite)parent.getParent());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.getWidgetFactory().paintBordersFor(composite);
        this.topComposite = composite;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (this.needToRebuildUI) {
            this.forceRebuildUI();
        }
    }

    public void forceRebuildUI() {
        TabbedPropertySheetPage page = this.getTabbedPropertySheetPage();
        if (page != null) {
            this.needToRebuildUI = false;
            Composite parent = this.topComposite.getParent();
            this.lock = true;
            try {
                Configuration conf = (Configuration)this.getEObject();
                this.topComposite.dispose();
                if (this.controls != null) {
                    this.controls.clear();
                    this.createControls(parent, page);
                    if (this.categoryFilter.equals("Standard")) {
                        UIControlDescriptorImpl desc = null;
                        if (conf instanceof MdNode) {
                            if (conf.getLevel().isHasName()) {
                                desc = new NameUIControlDescriptor(this.helper, this.valueSetter);
                            }
                        } else {
                            desc = new ConfigurationControlDescriptor(null, this.helper, this.valueSetter, this.aflp);
                        }
                        if (desc != null) {
                            UIControl ctr = this.controlFactory.createControl(this.topComposite, desc);
                            desc.setUIControl(ctr);
                            this.controls.put(desc, ctr);
                            ctr.hookListeners();
                        }
                    }
                    if (conf != null) {
                        conf.getLevel().getAttribute().stream().sorted(new PropertyComparator(conf)).filter(p -> this.isPropertyDisplayed((Property)p, conf)).forEach(this::createPropertyControl);
                    }
                    parent.layout(true);
                }
                this.setEObject((EObject)conf);
            }
            finally {
                this.lock = false;
            }
            this.aboutToBeShown();
            this.refresh();
        } else {
            this.needToRebuildUI = true;
        }
    }

    private boolean isPropertyDisplayed(Property prop, Configuration conf) {
        String[] compositeLabels = MdTabDescriptorProvider.getTabAndGroupName(prop.getCategory());
        boolean test = compositeLabels[0].equals(this.categoryFilter);
        if (test && prop.getXpathCondition() != null && !prop.getXpathCondition().equals("")) {
            test = Util.isXpathConditionValided((Element)conf, (String)prop.getXpathCondition());
        }
        return test;
    }

    private Composite getParentComposite(Property prop) {
        String[] compositeLabels = MdTabDescriptorProvider.getTabAndGroupName(prop.getCategory());
        Composite parent = null;
        if (!compositeLabels[1].isEmpty()) {
            parent = (Composite)this.groupComposites.get(compositeLabels[1]);
            if (parent == null || parent.isDisposed()) {
                parent = this.getWidgetFactory().createGroup(this.topComposite, compositeLabels[1]);
                this.groupComposites.put(compositeLabels[1], (Group)parent);
                GridData gridData = new GridData(768);
                gridData.horizontalSpan = 3;
                parent.setLayoutData((Object)gridData);
                parent.setLayout((Layout)new GridLayout(3, false));
            }
        } else {
            parent = this.topComposite;
        }
        return parent;
    }

    private void createPropertyControl(Property prop) {
        final UIControlDescriptorImpl desc = new UIControlDescriptorImpl(prop, this.helper, this.valueSetter, this.aflp);
        ControlEnabler enabler = new ControlEnabler(desc);
        if (!(enabler.getHyperlinkEnablement() || enabler.isSubmd() && desc.sectionHelper.getEObject() instanceof MdNode)) {
            return;
        }
        Composite currentComposite = this.getParentComposite(prop);
        if (currentComposite.isDisposed()) {
            return;
        }
        UIControl ctr = this.controlFactory.createControl(currentComposite, desc);
        desc.setUIControl(ctr);
        ctr.getLabelControl().setData("qa", (Object)prop.getFullCode());
        ctr.getMainControl().setData("qa", (Object)prop.getFullCode());
        if (desc.hintValueProvider instanceof ModuleListValueProvider) {
            this.controlFactory.createModuleListControl(ctr, desc, (Configuration)this.getEObject());
        }
        this.controls.put(desc, ctr);
        ctr.hookListeners();
        if (prop.getType() == PropertyType.REFERENCE) {
            String hint = desc.getHint("com.indy.ui.custom.out.common.properties.hint.dnd.emfMetaInf");
            if (hint != null && !hint.contains("MdNode")) {
                this.controlFactory.createProcessReferenceAdditionalControls(ctr, desc);
            } else {
                this.controlFactory.createMdReferenceAdditionalControls(ctr, desc);
            }
        }
        if (desc.isHyperlink()) {
            ctr.getLabelControl().addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    Configuration cf = (Configuration)PropertySection.this.getEObject();
                    Attribute att = cf.getAttributeByShortCode(desc.getPropertyCode());
                    if (att == null) {
                        MdNodeInitializer.initialize((String)(cf.getDefType() + "." + desc.getPropertyCode()), (Configuration)cf, (Configuration)cf);
                    } else {
                        PropertySection.this.getEditingDomain().getCommandStack().execute((Command)new RemoveCommand((EditingDomain)PropertySection.this.getEditingDomain(), (EObject)cf, (EStructuralFeature)MdPackage.eINSTANCE.getConfiguration_Attribute(), (Object)att));
                    }
                }
            });
        }
    }

    protected void setEObject(EObject object) {
        if (this.propertyWhoseChangeRequiresUIRebuild != null) {
            this.propertyWhoseChangeRequiresUIRebuild.clear();
        }
        if (object instanceof Configuration) {
            this.propertyWhoseChangeRequiresUIRebuild = ((Configuration)object).getLevel().getAttribute().stream().filter(p -> p.isRefreshPropertiesCompositeOnValueChange()).map(p -> p.getFullCode()).collect(Collectors.toList());
        }
        super.setEObject(object);
    }

    public void refresh() {
        if (!this.lock && !this.isDisposed() && this.getEObject() != null && this.getEObject().eResource() != null) {
            this.executeAsReadAction(this::refreshContent);
        }
    }

    public void update(Notification notification, EObject element) {
        String attributeDeftype = null;
        if ((notification.getEventType() == 1 || notification.getEventType() == 4 || notification.getEventType() == 3) && notification.getNotifier() instanceof Attribute) {
            attributeDeftype = ((Attribute)notification.getNotifier()).getDefType();
        } else if (notification.getFeature() == MdPackage.eINSTANCE.getConfiguration_Attribute() && (notification.getEventType() == 3 || notification.getEventType() == 4)) {
            if (notification.getOldValue() instanceof Attribute) {
                attributeDeftype = ((Attribute)notification.getOldValue()).getDefType();
            } else if (notification.getNewValue() instanceof Attribute) {
                attributeDeftype = ((Attribute)notification.getNewValue()).getDefType();
            }
        }
        if (attributeDeftype != null && this.propertyWhoseChangeRequiresUIRebuild.contains(attributeDeftype)) {
            this.needToRebuildUI = true;
        }
        while (element != null && !(element instanceof Configuration)) {
            element = element.eContainer();
        }
        super.update(notification, element);
    }

    protected boolean isCurrentSelection(Notification notification, EObject element) {
        boolean res = super.isCurrentSelection(notification, element);
        if (!res) {
            return this.helper.isCurrentEditorOfEditedObject();
        }
        return res;
    }

    private void refreshContent() {
        try {
            EObject eObject;
            if (this.needToRebuildUI) {
                this.forceRebuildUI();
            }
            if ((eObject = this.getEObject()) instanceof Configuration) {
                this.controls.entrySet().stream().map(Map.Entry::getKey).forEach(this::refreshControl);
            }
            if ("macosx".equals(Platform.getOS())) {
                this.topComposite.setFocus();
            }
        }
        catch (Exception ex) {
            MdDiagramEditorPlugin.getInstance().getLog().error("Failed to refresh Metadata UI", (Throwable)ex);
        }
    }

    private void refreshControl(UIControlDescriptorImpl desc) {
        UIControl c = this.controls.get(desc);
        desc.refreshUIControl();
        if (this.helper.isReadOnly()) {
            c.setEnabled(false, false);
        } else {
            ControlEnabler enabler = new ControlEnabler(desc);
            c.setEnabled(enabler.getControlEnablement(), enabler.getHyperlinkEnablement());
            this.decorateControl(enabler.shouldDisplayWarning(), desc, c);
        }
    }

    private void decorateControl(boolean shouldDisplayWarning, UIControlDescriptorImpl desc, UIControl c) {
        ControlDecoration decoration = null;
        if (!shouldDisplayWarning) {
            decoration = this.controlsDecoration.remove(c);
            if (decoration != null) {
                decoration.hide();
                decoration.dispose();
            }
        } else {
            decoration = this.controlsDecoration.get(c);
            if (decoration == null) {
                Control toDecorate = null;
                toDecorate = desc.getType() == UIControlDescriptor.Type.BOOLEAN ? c.getMainControl() : c.getLabelControl();
                decoration = new ControlDecoration(toDecorate, 131072);
                decoration.setDescriptionText(Messages.propertySectionWarningTootipAttributeForbiden);
                decoration.setImage(MdSectionControlFactory.warningIcon);
                decoration.show();
                toDecorate.getParent().layout(true);
                this.controlsDecoration.put(c, decoration);
            }
        }
    }

    protected EObject adapt(Object object) {
        EObject res = null;
        if (object instanceof MdDomainNavigatorItem) {
            res = ((MdDomainNavigatorItem)((Object)object)).getEObject();
        }
        if (res == null) {
            res = super.adapt(object);
        }
        return res;
    }

    class Helper
    implements IMdSectionHelper {
        Helper() {
        }

        boolean isCurrentEditorOfEditedObject() {
            IEditorInput input;
            IWorkbenchPart part = PropertySection.this.getPart();
            if (part instanceof IEditorPart && (input = ((IEditorPart)part).getEditorInput()) instanceof URIEditorInput) {
                URI uri = ((URIEditorInput)input).getURI();
                Configuration conf = this.getEObject();
                URI resourceURI = conf.eResource().getURI();
                return uri.equals(resourceURI);
            }
            return false;
        }

        @Override
        public boolean isReadOnly() {
            ITabbedPropertySheetPageContributor contributor = null;
            TabbedPropertySheetPage sheetPage = PropertySection.this.getTabbedPropertySheetPage();
            if (sheetPage instanceof PropertiesBrowserPage) {
                contributor = ((PropertiesBrowserPage)sheetPage).getContributor();
            } else if (sheetPage instanceof IAdaptable) {
                contributor = (ITabbedPropertySheetPageContributor)((IAdaptable)sheetPage).getAdapter(ITabbedPropertySheetPageContributor.class);
            } else if (sheetPage instanceof com.indy.ui.custom.out.PropertiesBrowserPage) {
                contributor = ((com.indy.ui.custom.out.PropertiesBrowserPage)sheetPage).getContributor();
            }
            if (contributor != null) {
                if (contributor instanceof IReadOnlyDiagramPropertySheetPageContributor || contributor instanceof DiagramEditor && !((DiagramEditor)contributor).isWritable()) {
                    return true;
                }
                if (contributor instanceof IDiagramWorkbenchPart && ((IDiagramWorkbenchPart)contributor).getDiagramEditPart() != null && !((IDiagramWorkbenchPart)contributor).getDiagramEditPart().isEditModeEnabled()) {
                    return true;
                }
            }
            if (this.isCurrentEditorOfEditedObject()) {
                return false;
            }
            IWorkbenchPart part = PropertySection.this.getPart();
            return part == null || !(part instanceof MdEditor);
        }

        @Override
        public EditingDomain getEditingDomain() {
            return PropertySection.this.getEditingDomain();
        }

        @Override
        public Configuration getEObject() {
            return (Configuration)PropertySection.this.getEObject();
        }

        @Override
        public Collection<EObject> getInput() {
            return PropertySection.this.getInput();
        }
    }
}

