/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.md.diagram.custom.properties;

import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.indy.md.ui.diagram.Messages;
import com.indy.ui.custom.out.Activator;
import com.indy.ui.custom.out.common.properties.AbstractUnboundedControl;
import com.indy.ui.custom.out.common.properties.CustomFeatureEditorDialog;
import com.indy.ui.custom.out.common.properties.ListUnboundedControl;
import com.indy.ui.custom.out.common.properties.StringUnboundedControl;
import com.indy.ui.custom.out.common.properties.UIControl;
import com.indy.ui.custom.out.common.properties.UIControlDescriptor;
import com.indy.ui.custom.out.common.properties.UILinkedControl;
import com.semarchy.xdi.engine.common.exceptions.OtherExceptionI;
import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.Element;
import com.stambia.md.MdNode;
import com.stambia.md.custom.Util;
import com.stambia.md.diagram.custom.properties.AdditionalControlBuilderHelper;
import com.stambia.md.diagram.custom.properties.ComboHelper;
import com.stambia.md.diagram.custom.properties.CustomizedPropertySource;
import com.stambia.md.diagram.custom.properties.IMdSectionHelper;
import com.stambia.md.diagram.custom.properties.MdValueSetter;
import com.stambia.md.diagram.custom.properties.MdValues;
import com.stambia.md.diagram.part.MdDiagramEditorPlugin;
import com.stambia.md.presentation.custom.edit.KeyValueControl;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import com.stambia.tech.TechPackage;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class UIControlDescriptorImpl
implements UIControlDescriptor,
UIControlDescriptor.ValueProvider,
UIControlDescriptor.IUnboundedEditorProvider,
UIControlDescriptor.IRefreshable {
    Property property;
    private WeakHashMap<Object, String> cachedLabels = new WeakHashMap();
    private List<ComboHelper> helpers = new ArrayList<ComboHelper>();
    protected UIControlDescriptor.ValueProvider hintValueProvider;
    private Reference<UIControlDescriptor.IAddtionalControlBuilder> controlBuilder;
    protected IMdSectionHelper sectionHelper;
    protected UIControl uiControl;
    private AdapterFactoryLabelProvider aflp;
    protected UIControlDescriptor.Setter propertySetter;

    public UIControlDescriptorImpl(Property property, IMdSectionHelper helper, MdValueSetter valueSetter, AdapterFactoryLabelProvider aflp) {
        this.property = property;
        this.sectionHelper = helper;
        this.aflp = aflp;
        if (property != null) {
            this.helpers.addAll(ComboHelper.createFromPropertyMetaInf(property, this, helper));
            String hintClassName = (String)property.getHint().get((Object)"com.indy.ui.custom.out.common.properties.hint.valueprovider.className");
            this.hintValueProvider = this.createValueProvider(hintClassName);
            this.propertySetter = newValue -> valueSetter.setValue(newValue, property.getCode());
        }
    }

    private UIControlDescriptor.ValueProvider createValueProvider(String hintClassName) {
        if (hintClassName == null) {
            return null;
        }
        UIControlDescriptor.ValueProvider res = null;
        try {
            Class<?> cl = null;
            try {
                cl = MdDiagramEditorPlugin.class.getClassLoader().loadClass(hintClassName);
            }
            catch (Exception e) {
                cl = Activator.class.getClassLoader().loadClass(hintClassName);
            }
            res = (UIControlDescriptor.ValueProvider)cl.newInstance();
        }
        catch (Exception ex) {
            Activator.getDefault().getLog().log((IStatus)new Status(2, "com.indy.ui.custom.out", Messages.MdPropertySection2_20 + "com.indy.ui.custom.out.common.properties.hint.valueprovider.className", (Throwable)ex));
        }
        return res;
    }

    void setUIControl(UIControl c) {
        this.uiControl = c;
    }

    public void refreshUIControl() {
        Object realValue = this.getValueProvider().getValueFromObject();
        Object ctrlValue = this.getValue4Control(realValue);
        if (ctrlValue != null) {
            this.uiControl.setValue(ctrlValue);
        }
        for (UIControlDescriptor.LinkedControlDescriptor linked : this.getLinkedDescriptors()) {
            Object o;
            ((ComboHelper)linked).setContext(this.sectionHelper.getEObject());
            UILinkedControl ctr = this.uiControl.getLinkedControl(linked);
            ctr.getViewer().setInput((Object)this.sectionHelper.getEObject());
            if (ctr.getViewer() == this.uiControl.getViewer()) {
                this.uiControl.setValue(realValue);
            }
            if (!((o = linked.getValueProvider().getValueFromObject()) instanceof Configuration)) continue;
            StructuredSelection selection = new StructuredSelection(o);
            ctr.getViewer().setSelection((ISelection)selection);
        }
    }

    Object getValue4Control(Object value) {
        if (this.uiControl.getMainControl() instanceof Text || this.uiControl.getMainControl() instanceof StyledText) {
            if (value == null) {
                return "";
            }
            if (value instanceof List) {
                StringBuilder txt = new StringBuilder();
                int i = 0;
                while (i < ((List)value).size()) {
                    Object v;
                    if (i > 0) {
                        txt.append(", ");
                    }
                    if ((v = ((List)value).get(i)) instanceof Element) {
                        txt.append(((Element)v).getName());
                    } else if (v == null) {
                        MdDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(2, "com.indy.md.ui.diagram", NLS.bind((String)Messages.MdPropertySection2_24, (Object)this.property)));
                    } else {
                        txt.append(this.aflp.getText(v));
                    }
                    ++i;
                }
                return txt.toString();
            }
            return value.toString();
        }
        if (this.uiControl.getMainControl() instanceof Button) {
            if (value == null) {
                return false;
            }
            return Boolean.valueOf(value.toString());
        }
        if (this.uiControl.getMainControl() instanceof CCombo) {
            final Configuration conf = this.sectionHelper.getEObject();
            MdValues val = new MdValues(this.property, conf, 1){

                @Override
                public Object evaluate() throws XPathExpressionException {
                    ComboHelper linked;
                    if (!UIControlDescriptorImpl.this.helpers.isEmpty() && (linked = UIControlDescriptorImpl.this.helpers.get(UIControlDescriptorImpl.this.helpers.size() - 1)) != null && linked.xpathValues != null) {
                        return conf.evaluateMdSet(linked.xpathValues, linked.variableResolver);
                    }
                    return super.evaluate();
                }
            };
            if (this.property != null && this.property.getType().equals((Object)PropertyType.REFERENCE)) {
                this.initComboViewerRef((ComboViewer)this.uiControl.getViewer(), value, val.eoValues);
            } else if (this.hintValueProvider != null) {
                this.initComboViewerString((ComboViewer)this.uiControl.getViewer(), value, this.getPotentialValues(conf));
            } else {
                this.initComboViewerString((ComboViewer)this.uiControl.getViewer(), value, val.values);
            }
        } else if (this.uiControl.getMainControl() instanceof org.eclipse.swt.widgets.List) {
            if (this.uiControl.getViewer() != null) {
                return value;
            }
            if (value == null) {
                return new String[0];
            }
            if (value instanceof List) {
                String[] res = new String[((List)value).size()];
                int i = 0;
                while (i < res.length) {
                    Object o = ((List)value).get(i);
                    if (o instanceof String) {
                        res[i] = (String)o;
                    } else if (o != null) {
                        res[i] = o.toString();
                    }
                    ++i;
                }
                return res;
            }
            return new String[]{value.toString()};
        }
        return null;
    }

    private void initComboViewerString(ComboViewer cv, Object value, List<String> values) {
        if (value != null && values != null && !values.contains(value)) {
            values.add(0, value.toString());
        }
        if (values != null) {
            cv.setInput((Object)values.toArray());
        } else {
            cv.setInput(null);
        }
        if (value != null) {
            cv.setSelection((ISelection)new StructuredSelection(value));
        }
    }

    private void initComboViewerRef(ComboViewer cv, Object value, List<EObject> eoValues) {
        if (value != null && eoValues != null && !eoValues.contains(value)) {
            eoValues.add(0, (EObject)value);
        }
        if (eoValues != null) {
            cv.setInput((Object)eoValues.toArray());
        } else {
            cv.setInput(null);
        }
        if (value != null) {
            cv.setSelection((ISelection)new StructuredSelection(value));
        }
    }

    public UIControlDescriptor.Type getType() {
        switch (this.property.getType()) {
            case BOOLEAN: {
                return UIControlDescriptor.Type.BOOLEAN;
            }
            case LIST: {
                return UIControlDescriptor.Type.LIST;
            }
            case PASSWORD: {
                return UIControlDescriptor.Type.PASSWORD;
            }
            case REFERENCE: {
                return UIControlDescriptor.Type.REFERENCE;
            }
            case STRING: 
            case INTEGER: 
            case DATE: {
                return UIControlDescriptor.Type.STRING;
            }
            case FILE: {
                return UIControlDescriptor.Type.FILE;
            }
        }
        return null;
    }

    private Object getValueFromConfiguration(Configuration conf) {
        Object value = null;
        String code = this.getPropertyCode();
        value = code.equals("tech:name") ? conf.getName() : CustomizedPropertySource.getValue(conf, this.property);
        return value;
    }

    public boolean isUnbounded() {
        return this.property.isUnbounded();
    }

    public String getControlLabel() {
        if (this.property.eIsSet((EStructuralFeature)TechPackage.eINSTANCE.getElement_XpathDisplayName()) && !this.property.getXpathDisplayName().isEmpty()) {
            try {
                String label = this.sectionHelper.getEObject().evaluateMdString(this.property.getXpathDisplayName());
                if (label != null && !label.isEmpty()) {
                    return label;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.property.getDisplayName();
    }

    public String getControlTooltype() {
        return this.property.getToolTip();
    }

    public boolean isControlMultiline() {
        return this.property.isMultiLine();
    }

    public boolean isHyperlink() {
        return true;
    }

    public boolean isEditable() {
        return !this.sectionHelper.isReadOnly() && this.property.isEditable();
    }

    public boolean refreshUIOnValueChange() {
        return this.property.isRefreshPropertiesCompositeOnValueChange();
    }

    public String getPropertyCode() {
        return this.property.getCode();
    }

    public int getLabelHorizontalSpan() {
        return 1;
    }

    public int getControlHorizontalSpan() {
        return 1;
    }

    public UIControlDescriptor.ValueProvider getValueProvider() {
        return this;
    }

    public UIControlDescriptor.Setter getPropertySetter() {
        return this.propertySetter;
    }

    public List<UIControlDescriptor.LinkedControlDescriptor> getLinkedDescriptors() {
        return this.helpers;
    }

    public UIControlDescriptor.IUnboundedEditorProvider getUnboundedEditorProvider() {
        return this;
    }

    public String getLabel(Object element) {
        String cachedlabel = this.cachedLabels.get(element);
        if (cachedlabel != null) {
            return cachedlabel;
        }
        if (element == MdValues.nullObject) {
            return "";
        }
        Object str = null;
        if (element instanceof EObject && ((EObject)element).eIsProxy()) {
            str = ((EObject)element).toString();
        } else if (element instanceof MdNode) {
            String parent;
            str = this.aflp.getText(element);
            if (this.getLinkedDescriptors().isEmpty() && (parent = this.aflp.getText((Object)((MdNode)element).eContainer())) != null && str != null) {
                str = parent + "." + (String)str;
            }
        } else if (element instanceof EObject) {
            str = this.aflp.getText(element);
        }
        if (str == null) {
            str = element.toString();
        }
        this.cachedLabels.put(element, (String)str);
        return str;
    }

    public List<Object> getPotentialValues(Object data) {
        if (this.hintValueProvider != null) {
            return this.hintValueProvider.getPotentialValues(data);
        }
        return Collections.emptyList();
    }

    public void dispose() {
        this.property = null;
    }

    public boolean canReadFromControl() {
        return true;
    }

    private Object getComboValue(Viewer viewer, CCombo control) {
        Object res = null;
        if (viewer != null) {
            IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
            res = selection != null ? selection.getFirstElement() : null;
        }
        if (res == MdValues.nullObject) {
            res = null;
        } else if (MdValues.newObject.getName().equals(res)) {
            res = MdValues.newObject;
        } else if (res == null) {
            res = control.getText();
        }
        return res;
    }

    private Object getTextValue(Control control) {
        String value;
        String string = value = control instanceof Text ? ((Text)control).getText() : ((StyledText)control).getText();
        if (this.property != null && this.property.getType().equals((Object)PropertyType.PASSWORD)) {
            if (value != null && !value.isEmpty()) {
                try {
                    String encrypt;
                    SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                    semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                    value = encrypt = semaphoreManager.setSemaphore(true, value);
                }
                catch (OtherExceptionI e1) {
                    MdDiagramEditorPlugin.getInstance().getLog().error("Failed to encrypt password property", (Throwable)e1);
                }
            } else {
                value = null;
            }
        }
        return value;
    }

    public Object getValueFromControl() {
        Object val = null;
        Control control = this.uiControl.getMainControl();
        if (control instanceof CCombo) {
            val = this.getComboValue((Viewer)this.uiControl.getViewer(), (CCombo)control);
        } else if (control instanceof Text || control instanceof StyledText) {
            val = this.getTextValue(control);
        }
        return val;
    }

    public Object getValueFromObject() {
        Object value = null;
        Configuration eob = this.sectionHelper.getEObject();
        if (eob != null && !eob.eIsProxy()) {
            Configuration conf = null;
            if (eob instanceof Configuration) {
                conf = eob;
                value = this.getValueFromConfiguration(conf);
            }
        }
        return value;
    }

    public Object openEditor() {
        Configuration conf = this.sectionHelper.getEObject();
        if (conf == null) {
            return null;
        }
        MdValues mdValues = new MdValues(this.property, conf, 1);
        Object obj = this.getValueFromConfiguration(conf);
        List list = (List)obj;
        CustomFeatureEditorDialog dialog = null;
        MdValues.KeyValueProvider keyValueProvider = null;
        if (this.property.isUnbounded() && this.property.isKeyValue()) {
            String hintClassName;
            if (this.property.getHint().get((Object)"com.indy.ui.custom.out.common.properties.hint.valueprovider.className") != null && (hintClassName = (String)this.property.getHint().get((Object)"com.indy.ui.custom.out.common.properties.hint.valueprovider.className")) != null) {
                try {
                    Class<?> cl = Activator.class.getClassLoader().loadClass(hintClassName);
                    this.hintValueProvider = (UIControlDescriptor.ValueProvider)cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    mdValues.values = this.hintValueProvider.getPotentialValues(null);
                    keyValueProvider = new MdValues.KeyValueProvider(mdValues);
                }
                catch (Exception ex) {
                    Activator.getDefault().getLog().log((IStatus)new Status(2, "com.indy.ui.custom.out", Messages.MdPropertySection2_20 + "com.indy.ui.custom.out.common.properties.hint.valueprovider.className", (Throwable)ex));
                }
            }
            if (keyValueProvider == null && this.property.getType() != PropertyType.REFERENCE && mdValues.values != null && !mdValues.values.isEmpty()) {
                keyValueProvider = new MdValues.KeyValueProvider(mdValues);
            }
            if (keyValueProvider == null && this.property.getType() == PropertyType.REFERENCE && mdValues.eoValues != null) {
                mdValues.eoValues.isEmpty();
            }
            dialog = new CustomFeatureEditorDialog(Display.getCurrent().getActiveShell(), (Object)this.property, (AbstractUnboundedControl)new KeyValueControl((ILabelProvider)this.aflp, keyValueProvider), this.property.getDisplayName(), (Object)list);
        } else {
            dialog = this.getType() == UIControlDescriptor.Type.STRING ? new CustomFeatureEditorDialog(Display.getCurrent().getActiveShell(), (Object)conf, (AbstractUnboundedControl)new StringUnboundedControl((ILabelProvider)this.aflp, this.property.isMultiLine()), this.property.getDisplayName(), (Object)list) : new CustomFeatureEditorDialog(Display.getCurrent().getActiveShell(), (Object)conf, (AbstractUnboundedControl)new ListUnboundedControl((ILabelProvider)this.aflp, (Collection)(this.hintValueProvider != null ? this.hintValueProvider.getPotentialValues((Object)conf) : (this.property.getType() == PropertyType.REFERENCE ? mdValues.eoValues : mdValues.values))), this.property.getDisplayName(), (Object)list);
        }
        if (dialog.open() == 0) {
            return dialog.getResult();
        }
        return null;
    }

    protected boolean hasAttributeValue(Configuration conf) {
        boolean hasValue = false;
        Attribute att = conf.findAttributeByCode(this.property.getFullCode());
        if (att != null) {
            hasValue = true;
        }
        return hasValue;
    }

    protected boolean canAttributeBeDefined(Configuration conf) {
        MdNode mdNode = null;
        if (conf instanceof MdNode) {
            mdNode = (MdNode)conf;
        } else if (conf instanceof Configuration) {
            mdNode = (MdNode)conf.eContainer();
        } else {
            throw new RuntimeException("Unexpected");
        }
        if (mdNode != conf && !this.property.isConfigurable()) {
            return false;
        }
        if (mdNode.isSubMetaDataChildFile()) {
            return this.property.isOverridableOnChildFile();
        }
        if (this.property.getXpathCondition() != null && !this.property.getXpathCondition().equals("")) {
            return Util.isXpathConditionValided((Element)conf, (String)this.property.getXpathCondition());
        }
        return true;
    }

    public boolean isEnabled() {
        boolean enable;
        Configuration conf;
        block5: {
            Configuration eob = this.sectionHelper.getEObject();
            if (eob.eIsProxy() || !(eob instanceof Configuration) || this.property == null) {
                return false;
            }
            conf = eob;
            try {
                boolean bl = enable = !this.sectionHelper.isReadOnly();
                if (enable) break block5;
                return false;
            }
            catch (Exception ex) {
                MdDiagramEditorPlugin.getInstance().getLog().error("Failed to compute Property enablement state", (Throwable)ex);
                return true;
            }
        }
        boolean hasValue = this.hasAttributeValue(conf);
        enable = hasValue = hasValue || this.property.getType() == PropertyType.REFERENCE;
        if (enable && this.property.getXpathCondition() != null && !this.property.getXpathCondition().equals("")) {
            enable = Util.isXpathConditionValided((Element)conf, (String)this.property.getXpathCondition());
        }
        return enable;
    }

    public String getHint(String hintName) {
        if (this.property != null) {
            return (String)this.property.getHint().get((Object)hintName);
        }
        return null;
    }

    public boolean hasHexadecimalControl() {
        if (this.property != null) {
            try {
                return Boolean.valueOf((String)this.property.getHint().get((Object)"com.indy.ui.custom.out.common.properties.hint.hexadecimalEditor"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public UIControlDescriptor.IAddtionalControlBuilder getAdditionalControlBuilder() {
        if (this.controlBuilder == null) {
            this.controlBuilder = new SoftReference<UIControlDescriptor.IAddtionalControlBuilder>(AdditionalControlBuilderHelper.getBuilder(this));
        }
        return this.controlBuilder.get();
    }
}

