/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.microsoft.excel.wizard;

import com.indy.addons.microsoft.excel.Messages;
import com.indy.addons.microsoft.excel.wizard.Constant;
import com.indy.addons.microsoft.excel.wizard.ExcelWizardBean;
import com.indy.addons.microsoft.excel.wizard.ExcelWizardControler;
import com.indy.jdbc.editor.connection.ConnectionController;
import com.indy.jdbc.editor.connection.ConnectionDialog;
import com.indy.jdbc.wizard.ServerWizard;
import com.indy.ui.custom.out.common.properties.AbstractUnboundedControl;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdAttributeNativeEvaluator;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ExcelWizard
extends ServerWizard {
    private static final Logger logger = LogManager.getLogger(ExcelWizard.class);
    private static Image helpImage = null;
    private Page1ReverseMode page1ReverseMode = new Page1ReverseMode();
    private Page2StandardAttributes page2StandardAttributes = new Page2StandardAttributes();
    private Page3CustomSelection page3CustomSelection = new Page3CustomSelection();
    private ExcelWizardControler controler = new ExcelWizardControler();
    private ExcelWizardBean bean = new ExcelWizardBean();

    static {
        try {
            helpImage = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.eclipse.ui/icons/full/etool16/help_contents.png")).createImage();
        }
        catch (Exception ex) {
            logger.warn("Cannot load image", (Throwable)ex);
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page1ReverseMode);
        this.addPage((IWizardPage)this.page2StandardAttributes);
        this.addPage((IWizardPage)this.page3CustomSelection);
        super.addPages();
    }

    public void setNode(MdNode node) {
        super.setNode(node);
        this.controler.setBean(this.bean);
        this.controler.setNode(node);
        this.bean.setPathType(ExcelWizardBean.PATH_TYPE.FILE);
        this.controler.parseUrl();
    }

    private class Page1ReverseMode
    extends WizardPage {
        protected Page1ReverseMode() {
            super(Messages.page1_title);
            this.setTitle(this.getName());
        }

        public void createControl(Composite parent) {
            WizardDialog wizard = (WizardDialog)this.getContainer();
            wizard.setMinimumPageSize(1115, 400);
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            Label helpLabel = new Label(composite, 64);
            helpLabel.setText(Messages.page1_help);
            helpLabel.setLayoutData((Object)new GridData(1, 1, true, false));
            Group filePathGroup = new Group(composite, 0);
            filePathGroup.setText(Messages.page1_mode);
            filePathGroup.setLayout((Layout)new GridLayout());
            filePathGroup.setLayoutData((Object)new GridData(1, 1, true, false));
            final Button filePathButton = new Button((Composite)filePathGroup, 16);
            filePathButton.setText(Messages.page1_file);
            filePathButton.setLayoutData((Object)new GridData());
            filePathButton.setSelection(false);
            final Button folderPathButton = new Button((Composite)filePathGroup, 16);
            folderPathButton.setText(Messages.page1_folder);
            folderPathButton.setLayoutData((Object)new GridData());
            folderPathButton.setSelection(false);
            Button legacyButton = new Button((Composite)filePathGroup, 16);
            legacyButton.setText(Messages.page1_legacy);
            legacyButton.setLayoutData((Object)new GridData());
            legacyButton.setSelection(false);
            this.setControl((Control)composite);
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Button button;
                    Widget widget = event.widget;
                    if (widget instanceof Button && (button = (Button)widget).getSelection()) {
                        if (event.widget == filePathButton) {
                            ((Page1ReverseMode)Page1ReverseMode.this).ExcelWizard.this.bean.setPathType(ExcelWizardBean.PATH_TYPE.FILE);
                            ((Page1ReverseMode)Page1ReverseMode.this).ExcelWizard.this.page2StandardAttributes.setFileVisibile();
                        } else if (event.widget == folderPathButton) {
                            ((Page1ReverseMode)Page1ReverseMode.this).ExcelWizard.this.bean.setPathType(ExcelWizardBean.PATH_TYPE.FOLDER);
                            ((Page1ReverseMode)Page1ReverseMode.this).ExcelWizard.this.page2StandardAttributes.setFolderVisibile();
                        } else {
                            ((Page1ReverseMode)Page1ReverseMode.this).ExcelWizard.this.bean.setPathType(ExcelWizardBean.PATH_TYPE.LEGACY);
                            ((Page1ReverseMode)Page1ReverseMode.this).ExcelWizard.this.page2StandardAttributes.setAllUnvisibile();
                        }
                    }
                }
            };
            filePathButton.addSelectionListener((SelectionListener)listener);
            folderPathButton.addSelectionListener((SelectionListener)listener);
            legacyButton.addSelectionListener((SelectionListener)listener);
            ExcelWizardBean.PATH_TYPE pathType = ExcelWizard.this.bean.getPathType();
            if (pathType != null) {
                switch (pathType) {
                    case FILE: {
                        filePathButton.setSelection(true);
                        break;
                    }
                    case FOLDER: {
                        folderPathButton.setSelection(true);
                        break;
                    }
                    case LEGACY: {
                        legacyButton.setSelection(true);
                        break;
                    }
                }
            }
        }

        public IWizardPage getNextPage() {
            IWizardPage nextPage = null;
            if (ExcelWizardBean.PATH_TYPE.LEGACY == ExcelWizard.this.bean.getPathType()) {
                ExcelWizard.this.page2StandardAttributes.setPageComplete(true);
                nextPage = ExcelWizard.this.page3CustomSelection.getNextPage();
            } else {
                nextPage = super.getNextPage();
            }
            return nextPage;
        }
    }

    private class Page2StandardAttributes
    extends ResetRdbmsUrl {
        private Label filePathLabel;
        private Text filePathText;
        private Button filePathButton;
        private Label folderPathLabel;
        private Text folderPathText;
        private Button folderPathButton;

        protected Page2StandardAttributes() {
            super(Messages.page2_title);
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.checkPath();
            ExcelWizardBean.PATH_TYPE pathType = ExcelWizard.this.bean.getPathType();
            String path = ExcelWizard.this.bean.getFileFolderPath();
            if (pathType != null) {
                switch (pathType) {
                    case FILE: {
                        this.filePathText.setText(path);
                        break;
                    }
                    case FOLDER: {
                        this.folderPathText.setText(path);
                        break;
                    }
                }
            }
        }

        private void checkPath() {
            String errorMessage = ExcelWizard.this.controler.checkPath();
            this.setErrorMessage(errorMessage);
            this.setPageComplete(errorMessage == null);
        }

        public void createControl(Composite parent) {
            ExcelWizardBean.Style style;
            GridLayout gridLayout = new GridLayout(3, false);
            gridLayout.horizontalSpacing = ExcelWizard.helpImage.getBounds().width;
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)gridLayout);
            composite.setLayoutData((Object)new GridData(4, 4));
            Label helpLabel = new Label(composite, 64);
            helpLabel.setText(Messages.page2_help);
            helpLabel.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
            this.filePathLabel = new Label(composite, 0);
            this.filePathLabel.setText(Messages.page2_fileLabel);
            ControlDecoration filePathButtonDeco = new ControlDecoration((Control)this.filePathLabel, 0x1020000);
            filePathButtonDeco.setDescriptionText(Messages.page2_fileToolTip);
            filePathButtonDeco.setImage(helpImage);
            filePathButtonDeco.setShowHover(true);
            filePathButtonDeco.setShowOnlyOnFocus(false);
            this.filePathLabel.setLayoutData((Object)new GridData(1, 1, false, false));
            this.filePathText = new Text(composite, 2048);
            this.filePathText.setLayoutData((Object)new GridData(4, 1, true, false));
            this.filePathText.setText("");
            this.filePathButton = new Button(composite, 8);
            this.filePathButton.setLayoutData((Object)new GridData(3, 1, false, false));
            this.filePathButton.setText("...");
            this.filePathButton.setToolTipText(Messages.page2_fileBrowse);
            this.folderPathLabel = new Label(composite, 0);
            this.folderPathLabel.setText(Messages.page2_folderLabel);
            ControlDecoration folderPathButtonDeco = new ControlDecoration((Control)this.folderPathLabel, 0x1020000);
            folderPathButtonDeco.setDescriptionText(Messages.page2_folderToolTip);
            folderPathButtonDeco.setImage(helpImage);
            folderPathButtonDeco.setShowHover(true);
            folderPathButtonDeco.setShowOnlyOnFocus(false);
            this.folderPathLabel.setLayoutData((Object)new GridData(1, 1, false, false));
            this.folderPathText = new Text(composite, 2048);
            this.folderPathText.setLayoutData((Object)new GridData(4, 1, true, false));
            this.folderPathText.setText("");
            this.folderPathButton = new Button(composite, 8);
            this.folderPathButton.setLayoutData((Object)new GridData(3, 1, false, false));
            this.folderPathButton.setText("...");
            this.folderPathButton.setToolTipText(Messages.page2_folderBrowse);
            Label columnNameStyleLabel = new Label(composite, 0);
            columnNameStyleLabel.setText(Messages.page2_label);
            ControlDecoration columnNameStyleDeco = new ControlDecoration((Control)columnNameStyleLabel, 0x1020000);
            columnNameStyleDeco.setDescriptionText(Messages.page2_toolTip);
            columnNameStyleDeco.setImage(helpImage);
            columnNameStyleDeco.setShowHover(true);
            columnNameStyleDeco.setShowOnlyOnFocus(false);
            columnNameStyleLabel.setLayoutData((Object)new GridData(1, 1, false, false));
            Combo columnNameStyleCombo = new Combo(composite, 2056);
            Set<String> columnNameStyleValues = ExcelWizardBean.Style.stringValues();
            columnNameStyleCombo.setItems(columnNameStyleValues.toArray(new String[columnNameStyleValues.size()]));
            columnNameStyleCombo.setLayoutData((Object)new GridData(1, 1, true, false, 2, 1));
            columnNameStyleCombo.setText("");
            this.setControl((Control)composite);
            FilePathSelectionAdapterModifyListener fileSelectionAdapterModifyListener = new FilePathSelectionAdapterModifyListener(this, this.filePathText){

                @Override
                public String getPathString() {
                    String pathString = filePathText.getText();
                    FileDialog fileBrowser = new FileDialog(this.getShell(), 4096);
                    fileBrowser.setFilterExtensions(Constant.EXTENSIONS);
                    fileBrowser.setFilterPath(pathString);
                    pathString = fileBrowser.open();
                    return pathString;
                }
            };
            FilePathSelectionAdapterModifyListener folderSelectionAdapterModifyListener = new FilePathSelectionAdapterModifyListener(this, this.folderPathText){

                @Override
                public String getPathString() {
                    String pathString = folderPathText.getText();
                    File pathFile = new File(pathString);
                    if (pathFile != null && pathFile.isFile()) {
                        pathString = pathFile.getParent();
                    }
                    DirectoryDialog directoryBrowser = new DirectoryDialog(this.getShell(), 4096);
                    directoryBrowser.setFilterPath(pathString);
                    pathString = directoryBrowser.open();
                    return pathString;
                }
            };
            this.filePathText.addModifyListener((ModifyListener)fileSelectionAdapterModifyListener);
            this.filePathButton.addSelectionListener((SelectionListener)fileSelectionAdapterModifyListener);
            this.folderPathText.addModifyListener((ModifyListener)folderSelectionAdapterModifyListener);
            this.folderPathButton.addSelectionListener((SelectionListener)folderSelectionAdapterModifyListener);
            columnNameStyleCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    Widget widget = event.widget;
                    if (widget instanceof Combo) {
                        Combo combo = (Combo)widget;
                        String columnNameStyle = combo.getText();
                        ((Page2StandardAttributes)Page2StandardAttributes.this).ExcelWizard.this.bean.setColumnNameStyle(columnNameStyle);
                    }
                }
            });
            ExcelWizardBean.PATH_TYPE pathType = ExcelWizard.this.bean.getPathType();
            String path = ExcelWizard.this.bean.getFileFolderPath();
            if (pathType != null) {
                switch (pathType) {
                    case FILE: {
                        this.filePathText.setText(path);
                        this.setFileVisibile();
                        break;
                    }
                    case FOLDER: {
                        this.folderPathText.setText(path);
                        this.setFolderVisibile();
                        break;
                    }
                    default: {
                        this.setAllUnvisibile();
                    }
                }
            }
            if ((style = ExcelWizard.this.bean.getColumnNameStyle()) != null) {
                columnNameStyleCombo.setText(style.toString());
            }
        }

        private void setFileVisibile() {
            this.setFileVisibility(true);
            this.setFolderVisibility(false);
        }

        private void setFolderVisibile() {
            this.setFileVisibility(false);
            this.setFolderVisibility(true);
        }

        private void setAllUnvisibile() {
            this.setFileVisibility(false);
            this.setFolderVisibility(false);
        }

        private void setFileVisibility(boolean visibilty) {
            this.setControlVisibility((Control)this.filePathLabel, visibilty);
            this.setControlVisibility((Control)this.filePathText, visibilty);
            this.setControlVisibility((Control)this.filePathButton, visibilty);
        }

        private void setFolderVisibility(boolean visibilty) {
            this.setControlVisibility((Control)this.folderPathLabel, visibilty);
            this.setControlVisibility((Control)this.folderPathText, visibilty);
            this.setControlVisibility((Control)this.folderPathButton, visibilty);
        }

        private void setControlVisibility(Control control, boolean visibilty) {
            control.setVisible(visibilty);
            ((GridData)control.getLayoutData()).exclude = !visibilty;
            control.getParent().layout(true);
        }

        private abstract class FilePathSelectionAdapterModifyListener
        extends SelectionAdapter
        implements ModifyListener {
            Text pathText;

            FilePathSelectionAdapterModifyListener(Text pathText) {
                this.pathText = pathText;
            }

            public abstract String getPathString();

            public void widgetSelected(SelectionEvent e) {
                String pathString = this.getPathString();
                this.pathText.setText(pathString);
                this.setAndCheckFileFolderPath(pathString);
            }

            public void modifyText(ModifyEvent e) {
                String pathString = this.pathText.getText();
                this.setAndCheckFileFolderPath(pathString);
            }

            private void setAndCheckFileFolderPath(String pathString) {
                ((Page2StandardAttributes)Page2StandardAttributes.this).ExcelWizard.this.bean.setFileFolderPath(pathString);
                Page2StandardAttributes.this.checkPath();
            }
        }
    }

    private class Page3CustomSelection
    extends ResetRdbmsUrl {
        private TableViewer definedNamesTableViewer;
        private CellEditor cellEditor;
        private Label helpLabel;
        private TableColumn fileColumn;

        protected Page3CustomSelection() {
            super(Messages.page3_title);
        }

        private String setHelpText() {
            StringBuffer helpTextBuffer = new StringBuffer(Messages.page3_help_0);
            ExcelWizardBean.PATH_TYPE pathType = ExcelWizard.this.bean.getPathType();
            if (pathType == ExcelWizardBean.PATH_TYPE.FOLDER) {
                helpTextBuffer.append(Messages.page3_help_1);
            }
            helpTextBuffer.append(Messages.page3_help_2);
            String helpText = helpTextBuffer.toString();
            return helpText;
        }

        private void setFileColumn() {
            ExcelWizardBean.PATH_TYPE pathType = ExcelWizard.this.bean.getPathType();
            if (pathType == ExcelWizardBean.PATH_TYPE.FOLDER) {
                this.fileColumn.setWidth(200);
                this.fileColumn.setResizable(true);
            } else {
                this.fileColumn.setWidth(0);
                this.fileColumn.setResizable(false);
            }
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            String helpText = this.setHelpText();
            this.helpLabel.setText(helpText);
            this.helpLabel.getParent().layout(true);
            this.setFileColumn();
            this.definedNamesTableViewer.refresh();
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(4, 4));
            this.helpLabel = new Label(composite, 64);
            String helpText = this.setHelpText();
            this.helpLabel.setText(helpText);
            this.helpLabel.setLayoutData((Object)new GridData(1, 1, true, false));
            ToolBar vertiacalToolBar = new ToolBar(composite, 256);
            vertiacalToolBar.setLayoutData((Object)new GridData(4, 1, true, false));
            ToolItem addButton = new ToolItem(vertiacalToolBar, 8);
            addButton.setToolTipText(Messages.page3_add);
            addButton.setImage(AbstractUnboundedControl.addIcon);
            ToolItem deleteButton = new ToolItem(vertiacalToolBar, 8);
            deleteButton.setToolTipText(Messages.page3_delete);
            deleteButton.setImage(AbstractUnboundedControl.delIcon);
            this.definedNamesTableViewer = new TableViewer(composite, 68416);
            this.definedNamesTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.definedNamesTableViewer.getControl().setLayoutData((Object)new GridData(1808));
            this.cellEditor = new TextCellEditor((Composite)this.definedNamesTableViewer.getTable());
            Table definedNamesTable = this.definedNamesTableViewer.getTable();
            definedNamesTable.setHeaderVisible(true);
            definedNamesTable.setLinesVisible(true);
            TableViewerColumn nameColumnViewer = new TableViewerColumn(this.definedNamesTableViewer, 16384);
            TableColumn nameColumn = nameColumnViewer.getColumn();
            nameColumn.setText(Messages.page3_name);
            nameColumn.setWidth(100);
            TableViewerColumn fileColumnViewer = new TableViewerColumn(this.definedNamesTableViewer, 16384);
            this.fileColumn = fileColumnViewer.getColumn();
            this.fileColumn.setText(Messages.page3_file);
            this.setFileColumn();
            TableViewerColumn sheetColumnViewer = new TableViewerColumn(this.definedNamesTableViewer, 16384);
            TableColumn sheetColumn = sheetColumnViewer.getColumn();
            sheetColumn.setText(Messages.page3_sheet);
            sheetColumn.setWidth(200);
            TableViewerColumn areaColumnViewer = new TableViewerColumn(this.definedNamesTableViewer, 16384);
            TableColumn areaColumn = areaColumnViewer.getColumn();
            areaColumn.setText(Messages.page3_area);
            areaColumn.setWidth(100);
            this.setControl((Control)composite);
            ExcelColumnLabelProvider nameColumnLabelProvider = new ExcelColumnLabelProvider(this){

                @Override
                protected void setText(ExcelWizardBean.DefinedName definedName, String text) {
                    definedName.setName(text);
                }

                @Override
                protected String getText(ExcelWizardBean.DefinedName definedName) {
                    return definedName.getName();
                }
            };
            nameColumnViewer.setLabelProvider((CellLabelProvider)nameColumnLabelProvider);
            nameColumnViewer.setEditingSupport(nameColumnLabelProvider.toEditingSupport());
            ExcelColumnLabelProvider fileColumnLabelProvider = new ExcelColumnLabelProvider(this){

                @Override
                protected void setText(ExcelWizardBean.DefinedName definedName, String text) {
                    definedName.setFile(text);
                }

                @Override
                protected String getText(ExcelWizardBean.DefinedName definedName) {
                    return definedName.getFile();
                }
            };
            fileColumnViewer.setLabelProvider((CellLabelProvider)fileColumnLabelProvider);
            fileColumnViewer.setEditingSupport(fileColumnLabelProvider.toEditingSupport());
            ExcelColumnLabelProvider sheetColumnLabelProvider = new ExcelColumnLabelProvider(this){

                @Override
                protected void setText(ExcelWizardBean.DefinedName definedName, String text) {
                    definedName.setSheet(text);
                }

                @Override
                protected String getText(ExcelWizardBean.DefinedName definedName) {
                    return definedName.getSheet();
                }
            };
            sheetColumnViewer.setLabelProvider((CellLabelProvider)sheetColumnLabelProvider);
            sheetColumnViewer.setEditingSupport(sheetColumnLabelProvider.toEditingSupport());
            ExcelColumnLabelProvider areaColumnLabelProvider = new ExcelColumnLabelProvider(this){

                @Override
                protected void setText(ExcelWizardBean.DefinedName definedName, String text) {
                    definedName.setArea(text);
                }

                @Override
                protected String getText(ExcelWizardBean.DefinedName definedName) {
                    return definedName.getArea();
                }
            };
            areaColumnViewer.setLabelProvider((CellLabelProvider)areaColumnLabelProvider);
            areaColumnViewer.setEditingSupport(areaColumnLabelProvider.toEditingSupport());
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ((Page3CustomSelection)Page3CustomSelection.this).ExcelWizard.this.bean.addDefinedName(new ExcelWizardBean.DefinedName());
                    Page3CustomSelection.this.definedNamesTableViewer.refresh();
                }
            });
            deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ISelection selection = Page3CustomSelection.this.definedNamesTableViewer.getSelection();
                    Object definedNamesInput = Page3CustomSelection.this.definedNamesTableViewer.getInput();
                    if (selection != null && selection instanceof IStructuredSelection && definedNamesInput != null && definedNamesInput instanceof List) {
                        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                        List definedNamesToRemove = structuredSelection.toList();
                        List definedNamesList = (List)definedNamesInput;
                        definedNamesList.removeAll(definedNamesToRemove);
                        Page3CustomSelection.this.definedNamesTableViewer.refresh();
                    }
                }
            });
            this.definedNamesTableViewer.setInput(ExcelWizard.this.bean.getDefinedNames());
        }

        private abstract class ExcelColumnLabelProvider
        extends ColumnLabelProvider {
            private ExcelColumnLabelProvider() {
            }

            protected abstract void setText(ExcelWizardBean.DefinedName var1, String var2);

            protected abstract String getText(ExcelWizardBean.DefinedName var1);

            public String getText(Object element) {
                String text = "";
                if (element instanceof ExcelWizardBean.DefinedName) {
                    ExcelWizardBean.DefinedName definedName = (ExcelWizardBean.DefinedName)element;
                    text = this.getText(definedName);
                }
                return text;
            }

            private void setText(Object element, Object value) {
                if (element instanceof ExcelWizardBean.DefinedName && value != null) {
                    ExcelWizardBean.DefinedName definedName = (ExcelWizardBean.DefinedName)element;
                    String text = value.toString();
                    this.setText(definedName, text);
                    Page3CustomSelection.this.definedNamesTableViewer.refresh(element);
                }
            }

            private EditingSupport toEditingSupport() {
                return new EditingSupport((ColumnViewer)Page3CustomSelection.this.definedNamesTableViewer){

                    protected CellEditor getCellEditor(Object element) {
                        return ((ExcelColumnLabelProvider)ExcelColumnLabelProvider.this).Page3CustomSelection.this.cellEditor;
                    }

                    protected boolean canEdit(Object element) {
                        return true;
                    }

                    protected Object getValue(Object element) {
                        return ExcelColumnLabelProvider.this.getText(element);
                    }

                    protected void setValue(Object element, Object value) {
                        ExcelColumnLabelProvider.this.setText(element, value);
                    }
                };
            }
        }
    }

    private abstract class ResetRdbmsUrl
    extends WizardPage {
        protected ResetRdbmsUrl(String pageName) {
            super(pageName);
            this.setTitle(this.getName());
        }

        public IWizardPage getNextPage() {
            ConnectionDialog cad = ExcelWizard.this.getCad();
            if (ExcelWizard.this.controler != null && cad != null) {
                String rawUrl = ExcelWizard.this.controler.getUrl();
                String evaluatedUrl = MdAttributeNativeEvaluator.evaluate((String)rawUrl, (Configuration)ExcelWizard.this.getNode(), null);
                cad.resetUrl(rawUrl, evaluatedUrl);
                ConnectionController connectionControler = cad.getController();
                connectionControler.getBean().getConnectionProperties().put("pathType", ExcelWizard.this.bean.getPathType().toString());
            }
            return super.getNextPage();
        }
    }
}

