/*
 * Decompiled with CFR 0.152.
 */
package com.indy.cross.ui;

import com.indy.cross.ui.LineageTreeBuilder;
import com.indy.cross.ui.LineageUI;
import com.indy.cross.ui.Messages;
import com.indy.map.compute.graph.Edge;
import com.indy.map.compute.graph.Graph;
import com.indy.map.compute.graph.Vertice;
import com.indy.ui.custom.out.Activator;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.ScalableFigure;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.DirectedGraphLayout;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.statushandlers.StatusManager;

public class LineageDraw2DHelper {
    public static final Font REGULAR_FONT = new Font((Device)Display.getDefault(), "Arial", 9, 0);
    static int SPACE_DECORATION = 2;
    static int WIDTH_DECORATION = 2;
    IPreferenceStore mapEditorPreferences = new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.indy.gmf.map.diagram");
    Color srcColor = Activator.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)this.mapEditorPreferences, (String)"Appearance.sourceColor"));
    Color trgColor = Activator.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)this.mapEditorPreferences, (String)"Appearance.targetColor"));
    Color srcLightColor = Activator.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)this.mapEditorPreferences, (String)"Appearance.sourceColorLight"));
    Color trgLightColor = Activator.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)this.mapEditorPreferences, (String)"Appearance.targetColorLight"));
    Color defaultColor = new Color(null, 220, 220, 220);
    private Map<LineageTreeBuilder.Node, IFigure> nodeFigures = new HashMap<LineageTreeBuilder.Node, IFigure>();
    private Map<LineageTreeBuilder.Node, Collection<LineageTreeBuilder.Node>> ghostPerBase = new HashMap<LineageTreeBuilder.Node, Collection<LineageTreeBuilder.Node>>();
    private Map<LineageTreeBuilder.Node, Set<IFigure>> connectionsFigure = new HashMap<LineageTreeBuilder.Node, Set<IFigure>>();
    private IFigure rootFigure;
    private ILabelProvider labelProvider;
    private LineageUI ui;
    private SelectionState selectionState = new SelectionState();
    private HashMap<Integer, RankInfo> rankMap = new HashMap();
    public static final String DECORATION_LAYER = "decorationLayer";
    public static final String PRIMARY_LAYER = "primaryLayer";
    public static final String CONNECTION_LAYER = "connectionLayer";
    private Viewport viewPort;
    private float zoomScale = 1.0f;

    protected void finalize() throws Throwable {
        this.defaultColor.dispose();
        super.finalize();
    }

    public LineageDraw2DHelper(ILabelProvider labelProvider, LineageUI ui) {
        this.labelProvider = labelProvider;
        ScalableFreeformLayeredPane rootFigure = new ScalableFreeformLayeredPane();
        rootFigure.setLayoutManager((LayoutManager)new FreeformLayout());
        this.rootFigure = rootFigure;
        rootFigure.add((IFigure)new FreeformLayer(), (Object)PRIMARY_LAYER);
        rootFigure.add((IFigure)new ConnectionLayer(), (Object)CONNECTION_LAYER);
        rootFigure.add((IFigure)new FreeformLayer(), (Object)DECORATION_LAYER);
        rootFigure.setBorder((Border)new MarginBorder(25, 25, 25, 25));
        ((ConnectionLayer)rootFigure.getLayer((Object)CONNECTION_LAYER)).setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter(){

            public void route(Connection conn) {
                PointList points = this.calculateBendPoints(conn);
                if (points != null) {
                    conn.setPoints(points);
                }
            }

            protected PointList calculateBendPoints(Connection conn) {
                PointList points = new PointList();
                Point start = conn.getSourceAnchor().getLocation(null);
                Rectangle srcBounds = conn.getSourceAnchor().getOwner().getBounds().getCopy();
                conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)srcBounds);
                Rectangle trgBounds = conn.getTargetAnchor().getOwner().getBounds().getCopy();
                conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)trgBounds);
                Point end = conn.getTargetAnchor().getLocation(null);
                points.addPoint(start);
                if (start.y != end.y) {
                    RankInfo srcRank = LineageDraw2DHelper.this.rankMap.get(((NodeFigure)conn.getSourceAnchor().getOwner()).data.getRank());
                    if (srcBounds != null && srcRank != null) {
                        int middleRank = (int)((float)((int)Math.abs(Math.floor((double)((float)srcBounds.x + (float)srcRank.width * LineageDraw2DHelper.this.zoomScale - (float)trgBounds.x) / 2.0)) + srcBounds.x) + (float)srcRank.width * LineageDraw2DHelper.this.zoomScale);
                        Point pt1 = new Point(middleRank, start.y);
                        points.addPoint(pt1);
                        Point pt2 = new Point(pt1.x, end.y);
                        points.addPoint(pt2);
                    }
                }
                points.addPoint(end);
                conn.translateToRelative((Translatable)points);
                return points;
            }
        });
        this.ui = ui;
    }

    private ConnectionLayer getConnectionLayer() {
        return (ConnectionLayer)((ScalableFreeformLayeredPane)this.rootFigure).getLayer((Object)CONNECTION_LAYER);
    }

    private FreeformLayer getPrimaryLayer() {
        return (FreeformLayer)((ScalableFreeformLayeredPane)this.rootFigure).getLayer((Object)PRIMARY_LAYER);
    }

    public IFigure getRootFigure() {
        return this.rootFigure;
    }

    private PolylineConnection createConnectionFigure(IFigure src, IFigure trg) {
        PolylineConnection poly = new PolylineConnection();
        poly.setLineWidth(1);
        poly.setAntialias(1);
        poly.setForegroundColor(this.defaultColor);
        poly.setSourceAnchor((ConnectionAnchor)new CustomAnchor(src, true));
        poly.setTargetAnchor((ConnectionAnchor)new CustomAnchor(trg, false));
        poly.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
        poly.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent me) {
                LineageDraw2DHelper.this.selectionState.setSelectedFigure((IFigure)me.getSource());
            }
        });
        return poly;
    }

    private IFigure createNodeFigure(LineageTreeBuilder.Node n) {
        NodeFigure f = new NodeFigure(n);
        this.connectionsFigure.put(n, new HashSet());
        return f;
    }

    public IFigure getDecorationLayer() {
        return ((ScalableFreeformLayeredPane)this.rootFigure).getLayer((Object)DECORATION_LAYER);
    }

    private void createFigures(Collection<LineageTreeBuilder.Node> nodes) {
        for (LineageTreeBuilder.Node n : nodes) {
            IFigure f = this.nodeFigures.get(n);
            if (f != null) continue;
            f = this.createNodeFigure(n);
            this.getPrimaryLayer().add(f);
            this.nodeFigures.put(n, f);
            if (!(n instanceof LineageTreeBuilder.GhostNode)) continue;
            LineageTreeBuilder.GhostNode ghostNode = (LineageTreeBuilder.GhostNode)n;
            LineageTreeBuilder.Node base = ghostNode.getBaseNode();
            Collection<LineageTreeBuilder.Node> c = this.ghostPerBase.get(base);
            if (c == null) {
                c = new HashSet<LineageTreeBuilder.Node>();
                this.ghostPerBase.put(base, c);
            }
            c.add(n);
            c.add(base);
        }
        HashMap<ConnectionID, PolylineConnection> connectionMap = new HashMap<ConnectionID, PolylineConnection>();
        for (LineageTreeBuilder.Node n : nodes) {
            PolylineConnection connection;
            ConnectionID i;
            for (LineageTreeBuilder.Node s : n.getSources()) {
                i = new ConnectionID();
                i.src = s;
                i.trg = n;
                connection = (PolylineConnection)connectionMap.get(i);
                if (connection == null) {
                    connection = this.createConnectionFigure(this.nodeFigures.get(s), this.nodeFigures.get(n));
                    this.getConnectionLayer().add((IFigure)connection);
                    connectionMap.put(i, connection);
                    connection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
                }
                this.connectionsFigure.get(s).add((IFigure)connection);
                this.connectionsFigure.get(n).add((IFigure)connection);
            }
            for (LineageTreeBuilder.Node t : n.getTargets()) {
                i = new ConnectionID();
                i.src = n;
                i.trg = t;
                connection = (PolylineConnection)connectionMap.get(i);
                if (connection == null) {
                    connection = this.createConnectionFigure(this.nodeFigures.get(n), this.nodeFigures.get(t));
                    this.getConnectionLayer().add((IFigure)connection);
                    connectionMap.put(i, connection);
                    connection.setTargetDecoration((RotatableDecoration)new PolygonDecoration());
                }
                this.connectionsFigure.get(t).add((IFigure)connection);
                this.connectionsFigure.get(n).add((IFigure)connection);
            }
        }
    }

    public IStructuredSelection getSelection() {
        if (this.selectionState.selectedFigure == null) {
            return StructuredSelection.EMPTY;
        }
        IFigure f = this.selectionState.selectedFigure;
        if (f instanceof NodeFigure) {
            return new StructuredSelection((Object)((NodeFigure)f).data);
        }
        if (f instanceof PolylineConnection) {
            LineageTreeBuilder.Node src = ((NodeFigure)((PolylineConnection)f).getSourceAnchor().getOwner()).data;
            LineageTreeBuilder.Node trg = ((NodeFigure)((PolylineConnection)f).getTargetAnchor().getOwner()).data;
            return new StructuredSelection((Object)new ConnectionWrapper(src, trg));
        }
        return StructuredSelection.EMPTY;
    }

    void setSelectedNode(LineageTreeBuilder.Node node) {
        this.selectionState.setSelectedFigure(this.nodeFigures.get(node));
    }

    public void layout() {
        this.rankMap.clear();
        HashMap<LineageTreeBuilder.Node, Object> draw2Dmap = new HashMap<LineageTreeBuilder.Node, Object>();
        HashMap edgesMap = new HashMap();
        DirectedGraph layoutGraph = new DirectedGraph();
        layoutGraph.setDirection(16);
        layoutGraph.setDefaultPadding(new Insets(8, 20, 8, 20));
        for (LineageTreeBuilder.Node n : this.nodeFigures.keySet()) {
            IFigure f = this.nodeFigures.get(n);
            if (f == null || !f.isVisible()) continue;
            Node draw2DNode = new Node((Object)n);
            draw2DNode.setSize(f.getPreferredSize(-1, -1));
            layoutGraph.nodes.add((Object)draw2DNode);
            draw2Dmap.put(n, draw2DNode);
            edgesMap.put(draw2DNode, new HashSet());
        }
        for (LineageTreeBuilder.Node n : draw2Dmap.keySet()) {
            if (draw2Dmap.get(n) == null) continue;
            for (LineageTreeBuilder.Node s : n.getSources()) {
                if (draw2Dmap.get(s) == null || s == n || !((HashSet)edgesMap.get(draw2Dmap.get(s))).add((Node)draw2Dmap.get(n))) continue;
                layoutGraph.edges.add((Object)new org.eclipse.draw2d.graph.Edge((Node)draw2Dmap.get(s), (Node)draw2Dmap.get(n)));
            }
            for (LineageTreeBuilder.Node s : n.getTargets()) {
                if (draw2Dmap.get(s) == null || s == n || !((HashSet)edgesMap.get(draw2Dmap.get(n))).add((Node)draw2Dmap.get(s))) continue;
                layoutGraph.edges.add((Object)new org.eclipse.draw2d.graph.Edge((Node)draw2Dmap.get(n), (Node)draw2Dmap.get(s)));
            }
        }
        DirectedGraphLayout layout = new DirectedGraphLayout();
        layout.visit(layoutGraph);
        for (LineageTreeBuilder.Node node : draw2Dmap.keySet()) {
            IFigure f = this.nodeFigures.get(node);
            Node _d = (Node)draw2Dmap.get(node);
            f.setBounds(new Rectangle(_d.x, _d.y, f.getPreferredSize((int)-1, (int)-1).width, _d.height));
            Rectangle.SINGLETON.setBounds(f.getBounds());
            f.getParent().translateToAbsolute((Translatable)Rectangle.SINGLETON);
            RankInfo info = this.rankMap.get(node.getRank());
            if (info == null) {
                info = new RankInfo(node.getRank(), Rectangle.SINGLETON.x, Rectangle.SINGLETON.width);
                this.rankMap.put(node.getRank(), info);
            } else {
                info.width = Math.max(info.width, Rectangle.SINGLETON.width);
            }
            info.addFigure(f, f.getSize());
        }
        for (Set set : this.connectionsFigure.values()) {
            for (IFigure ff : set) {
                ((PolylineConnection)ff).layout();
            }
        }
        this.setSelectedNode(null);
    }

    public void refreshGraph(Collection<LineageTreeBuilder.Node> nodes) {
        this.getPrimaryLayer().getChildren().clear();
        this.getConnectionLayer().getChildren().clear();
        this.getDecorationLayer().getChildren().clear();
        this.rankMap.clear();
        this.ghostPerBase.clear();
        this.nodeFigures.clear();
        this.connectionsFigure.clear();
        this.selectionState = new SelectionState();
        this.createFigures(nodes);
        this.layout();
        this.rootFigure.repaint();
    }

    public void hideFigure(List<Object> filtered, HashMap<URI, Set<LineageTreeBuilder.Node>> nodesByURI) {
        HashSet<LineageTreeBuilder.Node> ignoredNodes = new HashSet<LineageTreeBuilder.Node>();
        for (Object o : filtered) {
            if (o instanceof URI) {
                ignoredNodes.addAll((Collection<LineageTreeBuilder.Node>)nodesByURI.get((URI)o));
            }
            for (LineageTreeBuilder.Node n : this.nodeFigures.keySet()) {
                if (n != o) continue;
                ignoredNodes.add(n);
            }
        }
        HideVisitor vis = new HideVisitor();
        List<LineageTreeBuilder.Node> toHide = vis.getNodesToHide(this.nodeFigures.keySet(), ignoredNodes);
        for (LineageTreeBuilder.Node n : this.nodeFigures.keySet()) {
            for (IFigure f : this.connectionsFigure.get(n)) {
                f.setVisible(true);
            }
            this.nodeFigures.get(n).setVisible(true);
        }
        for (LineageTreeBuilder.Node n : this.nodeFigures.keySet()) {
            if (!toHide.contains(n)) continue;
            this.nodeFigures.get(n).setVisible(false);
            for (IFigure f : this.connectionsFigure.get(n)) {
                f.setVisible(false);
            }
        }
        this.getRootFigure().repaint();
    }

    public Collection<LineageTreeBuilder.Node> getNodes() {
        return this.nodeFigures.keySet();
    }

    public void reveal(ISelection selection) {
        if (selection.isEmpty()) {
            this.setSelectedNode(null);
        } else {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof LineageTreeBuilder.Node) {
                IFigure f;
                IFigure nodeFigure = f = this.nodeFigures.get(obj);
                if (f == null) {
                    return;
                }
                this.relocateViewport(nodeFigure);
                if (nodeFigure != this.selectionState.selectedFigure) {
                    this.setSelectedNode((LineageTreeBuilder.Node)obj);
                }
                return;
            }
        }
    }

    private void insertInRank(LineageTreeBuilder.Node synchronizedNode, Collection<LineageTreeBuilder.Node> nodes) {
        int centerYOffset;
        int rank = nodes.iterator().next().getRank();
        ArrayList<LineageTreeBuilder.Node> currentNodeInRank = new ArrayList<LineageTreeBuilder.Node>();
        for (LineageTreeBuilder.Node n : this.nodeFigures.keySet()) {
            if (n.getRank() != rank) continue;
            currentNodeInRank.add(n);
        }
        IFigure syncFigure = this.nodeFigures.get(synchronizedNode);
        int syncY = syncFigure.getBounds().getCenter().y;
        ArrayList<LineageTreeBuilder.Node> before = new ArrayList<LineageTreeBuilder.Node>();
        ArrayList<LineageTreeBuilder.Node> after = new ArrayList<LineageTreeBuilder.Node>();
        for (LineageTreeBuilder.Node n : currentNodeInRank) {
            IFigure f = this.nodeFigures.get(n);
            Rectangle bound = f.getBounds();
            if (bound.y >= syncY) {
                after.add(n);
                continue;
            }
            before.add(n);
        }
        Comparator<LineageTreeBuilder.Node> comp = new Comparator<LineageTreeBuilder.Node>(){

            @Override
            public int compare(LineageTreeBuilder.Node o1, LineageTreeBuilder.Node o2) {
                Rectangle r = LineageDraw2DHelper.this.nodeFigures.get(o1).getBounds();
                Rectangle r2 = LineageDraw2DHelper.this.nodeFigures.get(o2).getBounds();
                return Integer.valueOf(r.y).compareTo(r2.y);
            }
        };
        Collections.sort(before, comp);
        Collections.sort(after, comp);
        Dimension neededBounds = new Dimension();
        ArrayList<LineageTreeBuilder.Node> newNodes = new ArrayList<LineageTreeBuilder.Node>(nodes);
        ArrayList<LineageTreeBuilder.Node> existingNodes = new ArrayList<LineageTreeBuilder.Node>(this.nodeFigures.keySet());
        this.createFigures(newNodes);
        newNodes.removeAll(existingNodes);
        ArrayList<LineageTreeBuilder.Node> rankNodes = new ArrayList<LineageTreeBuilder.Node>();
        rankNodes.addAll(before);
        rankNodes.addAll(newNodes);
        rankNodes.addAll(after);
        for (LineageTreeBuilder.Node n : rankNodes) {
            IFigure f = this.nodeFigures.get(n);
            if (f == null) continue;
            Dimension d = f.getPreferredSize(-1, -1);
            neededBounds = neededBounds.union(d);
        }
        Rectangle r = syncFigure.getBounds();
        int xPosition = 0;
        xPosition = rank < 0 ? r.x - (neededBounds.width + 40) : r.x + this.rankMap.get((Object)Integer.valueOf((int)(rank - 1))).width + 40;
        int off = 36;
        RankInfo startRank = this.rankMap.get(0);
        Point baseCenter = startRank.computeRankBoundaries().getCenter();
        int y = centerYOffset = baseCenter.y - neededBounds.height / 2 - rankNodes.size() * off / 2;
        for (LineageTreeBuilder.Node n : rankNodes) {
            IFigure f = this.nodeFigures.get(n);
            Dimension d = f.getPreferredSize(-1, -1);
            Rectangle b = new Rectangle(xPosition, y, d.width, d.height);
            if (f.isVisible()) {
                y += off;
            }
            f.setBounds(b);
            RankInfo info = this.rankMap.get(rank);
            if (info == null) {
                info = new RankInfo(rank, b.x, b.width);
                this.rankMap.put(rank, info);
            } else {
                info.width = Math.max(info.width, b.width);
            }
            info.addFigure(f, d);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void layout2() {
        ArrayList<Integer> orederedRanks = new ArrayList<Integer>(this.rankMap.keySet());
        Collections.sort(orederedRanks, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                Integer i = Math.abs(o1);
                Integer j = Math.abs(o2);
                return i.compareTo(j);
            }
        });
        HashMap rankNodes = new HashMap();
        for (LineageTreeBuilder.Node n : this.nodeFigures.keySet()) {
            void var5_6;
            List list = (List)rankNodes.get(n.getRank());
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                rankNodes.put(n.getRank(), arrayList);
            }
            var5_6.add(n);
        }
        Rectangle r = null;
        int minY = Integer.MAX_VALUE;
        for (Integer n : orederedRanks) {
            Rectangle rr;
            if (n == 0 || (rr = this.layoutRank((List)rankNodes.get(n))) == null) continue;
            r = r == null ? rr : r.union(rr);
            int baseY = this.rankMap.get((Object)Integer.valueOf((int)0)).computeRankBoundaries().getCenter().y;
            int offset = baseY - rr.height / 2;
            for (LineageTreeBuilder.Node n2 : (List)rankNodes.get(n)) {
                IFigure f = this.nodeFigures.get(n2);
                f.setLocation(new Point(f.getBounds().getLocation().x, f.getBounds().getLocation().y + offset));
                minY = Math.min(minY, f.getBounds().getLocation().y);
            }
        }
        for (LineageTreeBuilder.Node node : this.nodeFigures.keySet()) {
            IFigure f = this.nodeFigures.get(node);
            if (!f.isVisible()) continue;
            f.setLocation(new Point(f.getBounds().getLocation().x, f.getBounds().getLocation().y - minY + 16));
        }
        for (Set set : this.connectionsFigure.values()) {
            for (IFigure ff : set) {
                if (!ff.isVisible()) continue;
                ((PolylineConnection)ff).layout();
            }
        }
        this.getConnectionLayer().repaint();
    }

    private Rectangle layoutRank(List<LineageTreeBuilder.Node> rankNodes) {
        int centerYOffset;
        if (rankNodes.isEmpty()) {
            return null;
        }
        Rectangle rankBounds = null;
        int off = 36;
        int y = centerYOffset = 0;
        for (LineageTreeBuilder.Node n : rankNodes) {
            IFigure f = this.nodeFigures.get(n);
            if (!f.isVisible()) continue;
            f.setLocation(new Point(f.getBounds().getLocation().x, y));
            y += off;
            rankBounds = rankBounds == null ? f.getBounds().getCopy() : rankBounds.union(f.getBounds());
        }
        return rankBounds;
    }

    private Viewport getViewport(IFigure figure) {
        if (this.viewPort == null) {
            IFigure f = figure;
            while (f != null && !(f instanceof Viewport)) {
                f = f.getParent();
            }
            this.viewPort = (Viewport)f;
        }
        return this.viewPort;
    }

    private void relocateViewport(IFigure target) {
        Viewport port = this.getViewport(target);
        if (target != null && port != null) {
            Rectangle exposeRegion = target.getBounds().getCopy();
            target.translateToAbsolute((Translatable)exposeRegion);
            exposeRegion = exposeRegion.expand(20, 0);
            port.getContents().translateToRelative((Translatable)exposeRegion);
            Point offset = port.getContents().getBounds().getLocation();
            exposeRegion.translate(offset.negate());
            exposeRegion.translate(port.getHorizontalRangeModel().getMinimum(), port.getVerticalRangeModel().getMinimum());
            Dimension viewportSize = port.getClientArea().getSize();
            Point topLeft = exposeRegion.getTopLeft();
            Point bottomRight = exposeRegion.getBottomRight().translate(viewportSize.getNegated());
            Point finalLocation = new Point();
            finalLocation.x = viewportSize.width < exposeRegion.width ? Math.min(bottomRight.x, Math.max(topLeft.x, port.getViewLocation().x)) : Math.min(topLeft.x, Math.max(bottomRight.x, port.getViewLocation().x));
            finalLocation.y = viewportSize.height < exposeRegion.height ? Math.min(bottomRight.y, Math.max(topLeft.y, port.getViewLocation().y)) : Math.min(topLeft.y, Math.max(bottomRight.y, port.getViewLocation().y));
            Point startLocation = port.getViewLocation();
            int dx = finalLocation.x - startLocation.x;
            int dy = finalLocation.y - startLocation.y;
            int frames = (Math.abs(dx) + Math.abs(dy)) / 15;
            if (frames == 0) {
                frames = 1;
            }
            int stepX = Math.min(dx / frames, viewportSize.width / 3);
            int stepY = Math.min(dy / frames, viewportSize.height / 3);
            int i = 1;
            while (i < frames) {
                port.setViewLocation(startLocation.x + stepX * i, startLocation.y + stepY * i);
                port.getUpdateManager().performUpdate();
                ++i;
            }
            port.setViewLocation(finalLocation);
        }
    }

    public boolean step(Point where, Viewport port) {
        Rectangle rect = Rectangle.SINGLETON;
        port.getClientArea(rect);
        port.setViewLocation(where);
        return true;
    }

    public void performZoom(float zoomValue) {
        Viewport viewport = this.getViewport(this.getRootFigure());
        ScalableFigure scalableFigure = (ScalableFigure)this.getRootFigure();
        if (viewport != null) {
            Point p1 = viewport.getClientArea().getCenter();
            Point p2 = p1.getCopy();
            Point p = viewport.getViewLocation();
            double prevZoom = this.zoomScale;
            this.zoomScale = zoomValue;
            scalableFigure.setScale((double)this.zoomScale);
            viewport.validate();
            p2.scale((double)zoomValue / prevZoom);
            Dimension dif = p2.getDifference(p1);
            p.x += dif.width;
            p.y += dif.height;
            viewport.setViewLocation(p);
        }
    }

    public void exportAsImage(String path) {
        IFigure f = this.getRootFigure();
        Rectangle r = f.getBounds().getCopy();
        Image img = new Image(null, r.width, r.height);
        GC gc = new GC((Drawable)img);
        SWTGraphics graphics = new SWTGraphics(gc);
        graphics.translate(-r.x, -r.y);
        f.paint((Graphics)graphics);
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{img.getImageData()};
        loader.save(path, 5);
        graphics.dispose();
        gc.dispose();
        img.dispose();
    }

    private class BlendedLabel
    extends Label {
        private BlendedLabel() {
        }

        public void paint(Graphics graphics) {
            graphics.pushState();
            graphics.setAlpha(160);
            super.paint(graphics);
            graphics.popState();
        }
    }

    private class ConnectionID {
        private Object src;
        private Object trg;

        private ConnectionID() {
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConnectionID) {
                ConnectionID id = (ConnectionID)obj;
                return this.src == id.src && this.trg == id.trg || this.src == id.trg && this.trg == id.src;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.src.hashCode() + this.trg.hashCode();
        }
    }

    static class ConnectionWrapper {
        LineageTreeBuilder.Node src;
        LineageTreeBuilder.Node trg;

        ConnectionWrapper(LineageTreeBuilder.Node src, LineageTreeBuilder.Node trg) {
            this.src = src;
            this.trg = trg;
        }

        public LineageTreeBuilder.Node getSrc() {
            return this.src;
        }

        public LineageTreeBuilder.Node getTrg() {
            return this.trg;
        }

        public int hashCode() {
            return this.src.hashCode() - this.trg.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof ConnectionWrapper) {
                return this.src.equals(((ConnectionWrapper)obj).src) && this.trg.equals(((ConnectionWrapper)obj).trg);
            }
            return false;
        }
    }

    private class CustomAnchor
    extends ChopboxAnchor {
        boolean isLeft;

        CustomAnchor(IFigure owner, boolean left) {
            super(owner);
            this.isLeft = false;
            this.isLeft = !left;
        }

        public Point getLocation(Point reference) {
            Rectangle r = Rectangle.SINGLETON;
            r.setBounds(this.getBox());
            r.translate(-1, -1);
            r.resize(1, 1);
            this.getOwner().translateToAbsolute((Translatable)r);
            Dimension d = r.getSize();
            float centerX = this.isLeft ? r.x : r.x + d.width;
            float centerY = (float)r.y + 0.5f * (float)d.height;
            return new Point((double)centerX, (double)Math.round(centerY));
        }
    }

    private class HideVisitor {
        private HideVisitor() {
        }

        public List<LineageTreeBuilder.Node> getNodesToHide(Collection<LineageTreeBuilder.Node> nodes, Collection<LineageTreeBuilder.Node> ignored) {
            Graph g = new Graph();
            HashMap<Vertice, LineageTreeBuilder.Node> datas = new HashMap<Vertice, LineageTreeBuilder.Node>();
            HashSet<Vertice> startingPoints = new HashSet<Vertice>();
            for (LineageTreeBuilder.Node n : nodes) {
                Vertice v2;
                Vertice v1 = g.createVertice((Object)n);
                if (n.isStartingPoint() && !ignored.contains(n)) {
                    startingPoints.add(v1);
                }
                datas.put(v1, n);
                for (LineageTreeBuilder.Node s : n.getSources()) {
                    v2 = g.createVertice((Object)s);
                    datas.put(v2, s);
                    g.createEdge(v2, v1);
                    if (!s.isStartingPoint() || ignored.contains(s)) continue;
                    startingPoints.add(v2);
                }
                for (LineageTreeBuilder.Node s : n.getTargets()) {
                    v2 = g.createVertice((Object)s);
                    datas.put(v2, s);
                    g.createEdge(v1, v2);
                    if (!s.isStartingPoint() || ignored.contains(s)) continue;
                    startingPoints.add(v2);
                }
            }
            Stack<Vertice> stack = new Stack<Vertice>();
            stack.addAll(startingPoints);
            while (!stack.isEmpty()) {
                Vertice v = (Vertice)stack.pop();
                if (v.getState() == Vertice.State.VISITED) continue;
                v.setState(Vertice.State.VISITED);
                for (Edge e : g.getAdjacentEdges(v)) {
                    if (e.getEnd() == v) {
                        if (ignored.contains(datas.get(e.getStart()))) continue;
                        stack.push(e.getStart());
                        continue;
                    }
                    if (ignored.contains(datas.get(e.getEnd()))) continue;
                    stack.push(e.getEnd());
                }
            }
            ArrayList<LineageTreeBuilder.Node> res = new ArrayList<LineageTreeBuilder.Node>();
            for (Vertice v : datas.keySet()) {
                if (v.getState() == Vertice.State.VISITED) continue;
                res.add((LineageTreeBuilder.Node)datas.get(v));
            }
            return res;
        }
    }

    public class NodeFigure
    extends Figure {
        private LineageTreeBuilder.Node data;
        private IFigure synchronizeFigure;
        private RectangleFigure ghostFigure = null;

        NodeFigure(LineageTreeBuilder.Node data) {
            this.data = data;
            this.initContent();
            this.initListener();
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.synchronizeFigure.setVisible(visible);
        }

        private void initContent() {
            GridLayout gl = null;
            gl = new GridLayout();
            this.setLayoutManager((LayoutManager)gl);
            gl.verticalSpacing = SPACE_DECORATION;
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            BlendedLabel l = this.data instanceof LineageTreeBuilder.GhostNode ? new BlendedLabel() : new Label();
            l.setBackgroundColor(LineageDraw2DHelper.this.defaultColor);
            l.setOpaque(true);
            l.setIcon(LineageDraw2DHelper.this.labelProvider.getImage((Object)this.data));
            l.setText(LineageDraw2DHelper.this.labelProvider.getText((Object)this.data));
            l.setFont(REGULAR_FONT);
            this.add((IFigure)l, new GridData(1, 1, false, false));
            this.setCursor(Cursors.HAND);
            this.ghostFigure = new RectangleFigure();
            this.ghostFigure.setFill(false);
            this.ghostFigure.setOpaque(true);
            this.ghostFigure.setBackgroundColor(ColorConstants.lightBlue);
            this.ghostFigure.setForegroundColor(ColorConstants.lightBlue);
            this.ghostFigure.setSize(-1, WIDTH_DECORATION);
            this.ghostFigure.setLineWidth(WIDTH_DECORATION);
            this.ghostFigure.setVisible(false);
            if (this.data instanceof LineageTreeBuilder.GhostNode) {
                this.ghostFigure.setLineStyle(3);
            }
            this.add((IFigure)this.ghostFigure, new GridData(4, 1, false, false));
            if (this.data.isStartingPoint()) {
                LineBorder b = new LineBorder(ColorConstants.lightBlue);
                b.setWidth(3);
                ((IFigure)this.getChildren().get(0)).setBorder((Border)b);
            }
            ImageFigure s = new ImageFigure();
            s.setCursor(Cursors.HAND);
            s.setOpaque(true);
            s.setSize(16, 16);
            if (this.data.getOrientation() == 10 && !this.data.isSrcSynchronized()) {
                s.setImage(LineageUI.imageRegistry.get("srcArrow"));
                s.setToolTip((IFigure)new Label(Messages.LineageDraw2DHelper_9));
                if (this.data.isSrcSynchronized()) {
                    s.setVisible(false);
                }
            } else if (this.data.getOrientation() == 1 && !this.data.isTrgSynchronized()) {
                s.setImage(LineageUI.imageRegistry.get("trgArrow"));
                s.setToolTip((IFigure)new Label(Messages.LineageDraw2DHelper_10));
                if (this.data.isTrgSynchronized()) {
                    s.setVisible(false);
                }
            } else {
                s.setVisible(false);
            }
            this.synchronizeFigure = s;
            if (!(this.data instanceof LineageTreeBuilder.GhostNode) && !this.data.isMdLink() && this.data.getOrientation() != -1) {
                LineageDraw2DHelper.this.getDecorationLayer().add(this.synchronizeFigure);
            }
            s.addMouseListener((MouseListener)new MouseListener.Stub(){

                public void mousePressed(MouseEvent me) {
                    boolean proceedSync = false;
                    switch (NodeFigure.this.data.getOrientation()) {
                        case 10: {
                            if (NodeFigure.this.data.isSrcSynchronized()) break;
                            proceedSync = true;
                            break;
                        }
                        case 1: {
                            if (NodeFigure.this.data.isTrgSynchronized()) break;
                            proceedSync = true;
                            break;
                        }
                        default: {
                            if (NodeFigure.this.data.isTrgSynchronized() && NodeFigure.this.data.isSrcSynchronized()) break;
                            proceedSync = true;
                        }
                    }
                    if (proceedSync) {
                        try {
                            new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell()).run(true, true, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    block3: {
                                        try {
                                            ((NodeFigure)(this).NodeFigure.this).LineageDraw2DHelper.this.ui.getSynchronizer().readNext((this).NodeFigure.this.data, monitor);
                                        }
                                        catch (Exception ex) {
                                            if (ex instanceof InterruptedException) {
                                                Thread.currentThread().interrupt();
                                            }
                                            if (monitor.isCanceled()) break block3;
                                            throw new InvocationTargetException(ex);
                                        }
                                    }
                                }
                            });
                        }
                        catch (Exception e) {
                            if (e instanceof InterruptedException) {
                                Thread.currentThread().interrupt();
                            }
                            StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.lineage.ui", Messages.LineageDraw2DHelper_11, e.getCause()));
                            return;
                        }
                        Collection<LineageTreeBuilder.Node> nodes = NodeFigure.this.data.getOrientation() == 10 ? NodeFigure.this.data.getSources() : NodeFigure.this.data.getTargets();
                        NodeFigure.this.synchronizeFigure.getParent().remove(NodeFigure.this.synchronizeFigure);
                        if (!nodes.isEmpty()) {
                            LineageDraw2DHelper.this.insertInRank(NodeFigure.this.data, nodes);
                            for (IFigure f : ((NodeFigure)NodeFigure.this).LineageDraw2DHelper.this.nodeFigures.values()) {
                                if (!f.isVisible()) continue;
                                ((NodeFigure)f).layout();
                            }
                            boolean filter = false;
                            for (LineageTreeBuilder.Node n : nodes) {
                                if (n.getContainerLevelNames().contains(((NodeFigure)NodeFigure.this).LineageDraw2DHelper.this.ui.getContainerLevel().name())) continue;
                                filter = true;
                            }
                            ((NodeFigure)NodeFigure.this).LineageDraw2DHelper.this.rootFigure.repaint();
                            ((NodeFigure)NodeFigure.this).LineageDraw2DHelper.this.ui.refreshFiltersContent(((NodeFigure)NodeFigure.this).LineageDraw2DHelper.this.nodeFigures.keySet());
                            if (filter) {
                                ((NodeFigure)NodeFigure.this).LineageDraw2DHelper.this.ui.filterGraph();
                            }
                            LineageDraw2DHelper.this.getConnectionLayer().repaint();
                            LineageDraw2DHelper.this.relocateViewport(((NodeFigure)NodeFigure.this).LineageDraw2DHelper.this.nodeFigures.get(nodes.iterator().next()));
                        }
                        if (((NodeFigure)NodeFigure.this).LineageDraw2DHelper.this.selectionState.selectedFigure != NodeFigure.this) {
                            LineageDraw2DHelper.this.setSelectedNode(NodeFigure.this.data);
                        }
                    }
                }
            });
            s.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

                public void mouseEntered(MouseEvent me) {
                    ((IFigure)me.getSource()).setBorder((Border)new LineBorder(Display.getCurrent().getSystemColor(26), 1));
                }

                public void mouseExited(MouseEvent me) {
                    ((IFigure)me.getSource()).setBorder(null);
                }
            });
        }

        private void initListener() {
            this.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

                public void mouseEntered(MouseEvent me) {
                    ((NodeFigure)NodeFigure.this).LineageDraw2DHelper.this.selectionState.setHoveredFigure((IFigure)me.getSource());
                }

                public void mouseExited(MouseEvent me) {
                    ((NodeFigure)NodeFigure.this).LineageDraw2DHelper.this.selectionState.setHoveredFigure(null);
                }
            });
            this.addMouseListener((MouseListener)new MouseListener.Stub(){

                public void mousePressed(MouseEvent me) {
                    ((NodeFigure)NodeFigure.this).LineageDraw2DHelper.this.selectionState.setSelectedFigure((IFigure)me.getSource());
                }
            });
            this.addFigureListener(new FigureListener(){

                public void figureMoved(IFigure source) {
                    if (source instanceof NodeFigure) {
                        NodeFigure nf = (NodeFigure)source;
                        if (nf.synchronizeFigure.getParent() == null) {
                            return;
                        }
                        Rectangle nodeBounds = source.getBounds().getCopy();
                        nf.translateToAbsolute((Translatable)nodeBounds);
                        Rectangle syncBounds = nf.synchronizeFigure.getBounds().getCopy();
                        nf.synchronizeFigure.translateToAbsolute((Translatable)syncBounds);
                        Point location = null;
                        if (nf.data.getOrientation() == 10) {
                            location = new Point(nodeBounds.x - syncBounds.width, nodeBounds.y);
                        } else if (nf.data.getOrientation() == 1) {
                            location = new Point(nodeBounds.x + nodeBounds.width, nodeBounds.y);
                        }
                        if (location != null) {
                            nf.synchronizeFigure.getParent().translateToRelative((Translatable)location);
                            nf.synchronizeFigure.setLocation(location);
                        }
                    }
                }
            });
        }

        public LineageTreeBuilder.Node getData() {
            return this.data;
        }
    }

    private class RankInfo {
        int rankNumber;
        int x;
        int width;
        Set<IFigure> figures = new HashSet<IFigure>();

        RankInfo(int rankNumber, int x, int width) {
            this.rankNumber = rankNumber;
            this.x = x;
            this.width = width;
        }

        void addFigure(IFigure f, Dimension figureSize) {
            this.figures.add(f);
        }

        Rectangle computeRankBoundaries() {
            Rectangle r = null;
            for (IFigure f : this.figures) {
                r = r == null ? f.getBounds().getCopy() : r.union(f.getBounds());
            }
            return r;
        }
    }

    private class SelectionState {
        private IFigure selectedFigure = null;
        private IFigure hoveredFigure = null;
        private List<IFigure> selectedFigureTargets = new ArrayList<IFigure>();
        private List<IFigure> hoveredFigureTargets = new ArrayList<IFigure>();

        private SelectionState() {
        }

        private void clearRecursiveFeedback(NodeFigure f, int orientation) {
            if (f == null) {
                return;
            }
            ((IFigure)f.getChildren().get(0)).setBackgroundColor(LineageDraw2DHelper.this.defaultColor);
            ((IFigure)f.getChildren().get(0)).setForegroundColor(null);
            switch (orientation) {
                case 10: {
                    for (IFigure s : LineageDraw2DHelper.this.connectionsFigure.get(f.data)) {
                        if (((PolylineConnection)s).getTargetAnchor().getOwner() != f) continue;
                        s.setForegroundColor(LineageDraw2DHelper.this.defaultColor);
                        ((PolylineConnection)s).setLineWidth(1);
                    }
                    for (LineageTreeBuilder.Node n : f.data.getSources()) {
                        NodeFigure nf = (NodeFigure)LineageDraw2DHelper.this.nodeFigures.get(n);
                        this.clearRecursiveFeedback(nf, orientation);
                    }
                    break;
                }
                case 1: {
                    for (IFigure s : LineageDraw2DHelper.this.connectionsFigure.get(f.data)) {
                        if (((PolylineConnection)s).getTargetAnchor().getOwner() != f) continue;
                        s.setForegroundColor(LineageDraw2DHelper.this.defaultColor);
                        ((PolylineConnection)s).setLineWidth(1);
                    }
                    for (LineageTreeBuilder.Node n : f.data.getTargets()) {
                        NodeFigure nf = (NodeFigure)LineageDraw2DHelper.this.nodeFigures.get(n);
                        this.clearRecursiveFeedback(nf, orientation);
                    }
                    break;
                }
            }
        }

        private void colorRecursiveFeedback(NodeFigure f, Color color, int orientation) {
            ((IFigure)f.getChildren().get(0)).setBackgroundColor(color);
            ((IFigure)f.getChildren().get(0)).setForegroundColor(ColorConstants.white);
            if (color == LineageDraw2DHelper.this.trgLightColor) {
                ((IFigure)f.getChildren().get(0)).setForegroundColor(null);
            }
            switch (orientation) {
                case 10: {
                    for (IFigure s : LineageDraw2DHelper.this.connectionsFigure.get(f.data)) {
                        if (((PolylineConnection)s).getTargetAnchor().getOwner() != f) continue;
                        IFigure parent = s.getParent();
                        parent.remove(s);
                        parent.add(s);
                        s.setForegroundColor(color);
                        ((PolylineConnection)s).setLineWidth(2);
                    }
                    for (LineageTreeBuilder.Node n : f.data.getSources()) {
                        if (n.getOrientation() == -1) continue;
                        this.colorRecursiveFeedback((NodeFigure)LineageDraw2DHelper.this.nodeFigures.get(n), color, orientation);
                    }
                    break;
                }
                case 1: {
                    for (IFigure s : LineageDraw2DHelper.this.connectionsFigure.get(f.data)) {
                        if (((PolylineConnection)s).getSourceAnchor().getOwner() != f) continue;
                        IFigure parent = s.getParent();
                        parent.remove(s);
                        parent.add(s);
                        s.setForegroundColor(color);
                        ((PolylineConnection)s).setLineWidth(2);
                    }
                    for (LineageTreeBuilder.Node n : f.data.getTargets()) {
                        if (n.getOrientation() == -1) continue;
                        this.colorRecursiveFeedback((NodeFigure)LineageDraw2DHelper.this.nodeFigures.get(n), color, orientation);
                    }
                    break;
                }
            }
        }

        public void setSelectedFigure(IFigure figure) {
            this.setHoveredFigure(null);
            if (this.selectedFigure != null) {
                if (this.selectedFigure instanceof PolylineConnection) {
                    this.selectedFigure.setForegroundColor(LineageDraw2DHelper.this.defaultColor);
                    ((Polyline)this.selectedFigure).setLineWidth(1);
                } else if (this.selectedFigure instanceof NodeFigure) {
                    ((IFigure)this.selectedFigure.getChildren().get(0)).setBackgroundColor(LineageDraw2DHelper.this.defaultColor);
                    ((IFigure)this.selectedFigure.getChildren().get(0)).setForegroundColor(null);
                    this.undecorateGhosts(this.selectedFigure);
                    for (IFigure f : this.selectedFigureTargets) {
                        if (f instanceof PolylineConnection) {
                            f.setForegroundColor(LineageDraw2DHelper.this.defaultColor);
                            ((Polyline)f).setLineWidth(1);
                            continue;
                        }
                        if (!(f instanceof NodeFigure)) continue;
                        this.clearRecursiveFeedback((NodeFigure)f, 10);
                        this.clearRecursiveFeedback((NodeFigure)f, 1);
                    }
                }
                for (IFigure f : this.selectedFigureTargets) {
                    ((IFigure)f.getChildren().get(0)).setForegroundColor(null);
                }
                this.selectedFigureTargets.clear();
            }
            this.selectedFigure = this.selectedFigure == figure ? null : figure;
            if (figure != null) {
                if (this.selectedFigure instanceof NodeFigure) {
                    IFigure parent;
                    IFigure parent2;
                    ((IFigure)this.selectedFigure.getChildren().get(0)).setBackgroundColor(ColorConstants.lightBlue);
                    ((IFigure)this.selectedFigure.getChildren().get(0)).setForegroundColor(ColorConstants.white);
                    LineageTreeBuilder.Node node = ((NodeFigure)this.selectedFigure).data;
                    for (LineageTreeBuilder.Node s : node.getSources()) {
                        ((IFigure)LineageDraw2DHelper.this.nodeFigures.get(s).getChildren().get(0)).setBackgroundColor(LineageDraw2DHelper.this.srcColor);
                        this.selectedFigureTargets.add(LineageDraw2DHelper.this.nodeFigures.get(s));
                        ((IFigure)LineageDraw2DHelper.this.nodeFigures.get(s).getChildren().get(0)).setForegroundColor(ColorConstants.white);
                        for (LineageTreeBuilder.Node n : s.getSources()) {
                            for (IFigure ff : LineageDraw2DHelper.this.connectionsFigure.get(n)) {
                                if (((PolylineConnection)ff).getTargetAnchor().getOwner() != LineageDraw2DHelper.this.nodeFigures.get(s)) continue;
                                parent2 = ff.getParent();
                                parent2.remove(ff);
                                parent2.add(ff);
                                ff.setForegroundColor(LineageDraw2DHelper.this.srcLightColor);
                                ((PolylineConnection)ff).setLineWidth(2);
                            }
                            if (n.getOrientation() == -1 || s.getOrientation() == -1) continue;
                            this.colorRecursiveFeedback((NodeFigure)LineageDraw2DHelper.this.nodeFigures.get(n), LineageDraw2DHelper.this.srcLightColor, 10);
                        }
                        for (IFigure f : LineageDraw2DHelper.this.connectionsFigure.get(s)) {
                            if (((PolylineConnection)f).getTargetAnchor().getOwner() != this.selectedFigure) continue;
                            f.setForegroundColor(LineageDraw2DHelper.this.srcColor);
                            this.selectedFigureTargets.add(f);
                            parent = f.getParent();
                            parent.remove(f);
                            parent.add(f);
                            ((Polyline)f).setLineWidth(2);
                        }
                    }
                    for (LineageTreeBuilder.Node s : node.getTargets()) {
                        ((IFigure)LineageDraw2DHelper.this.nodeFigures.get(s).getChildren().get(0)).setBackgroundColor(LineageDraw2DHelper.this.trgColor);
                        this.selectedFigureTargets.add(LineageDraw2DHelper.this.nodeFigures.get(s));
                        ((IFigure)LineageDraw2DHelper.this.nodeFigures.get(s).getChildren().get(0)).setForegroundColor(ColorConstants.white);
                        for (LineageTreeBuilder.Node n : s.getTargets()) {
                            for (IFigure ff : LineageDraw2DHelper.this.connectionsFigure.get(n)) {
                                if (((PolylineConnection)ff).getSourceAnchor().getOwner() != LineageDraw2DHelper.this.nodeFigures.get(s)) continue;
                                parent2 = ff.getParent();
                                parent2.remove(ff);
                                parent2.add(ff);
                                ff.setForegroundColor(LineageDraw2DHelper.this.trgLightColor);
                                ((PolylineConnection)ff).setLineWidth(2);
                            }
                            if (n.getOrientation() == -1 || s.getOrientation() == -1) continue;
                            this.colorRecursiveFeedback((NodeFigure)LineageDraw2DHelper.this.nodeFigures.get(n), LineageDraw2DHelper.this.trgLightColor, 1);
                        }
                        for (IFigure f : LineageDraw2DHelper.this.connectionsFigure.get(s)) {
                            if (((PolylineConnection)f).getSourceAnchor().getOwner() != this.selectedFigure) continue;
                            f.setForegroundColor(LineageDraw2DHelper.this.trgColor);
                            this.selectedFigureTargets.add(f);
                            parent = f.getParent();
                            parent.remove(f);
                            parent.add(f);
                            ((Polyline)f).setLineWidth(2);
                        }
                    }
                    this.decorateGhosts(this.selectedFigure);
                } else if (this.selectedFigure instanceof PolylineConnection) {
                    this.selectedFigure.setForegroundColor(ColorConstants.lightBlue);
                    IFigure parent = this.selectedFigure.getParent();
                    parent.remove(this.selectedFigure);
                    parent.add(this.selectedFigure);
                    ((Polyline)this.selectedFigure).setLineWidth(2);
                }
            }
            LineageDraw2DHelper.this.ui.notifyListeners();
        }

        private void decorateGhosts(IFigure figure) {
            Collection<LineageTreeBuilder.Node> c;
            LineageTreeBuilder.Node node = ((NodeFigure)figure).data;
            if (node instanceof LineageTreeBuilder.GhostNode) {
                node = ((LineageTreeBuilder.GhostNode)node).getBaseNode();
            }
            if ((c = LineageDraw2DHelper.this.ghostPerBase.get(node)) != null) {
                for (LineageTreeBuilder.Node n : c) {
                    IFigure f = LineageDraw2DHelper.this.nodeFigures.get(n);
                    ((NodeFigure)f).ghostFigure.setVisible(true);
                    f.repaint();
                }
            }
        }

        private void undecorateGhosts(IFigure figure) {
            Collection<LineageTreeBuilder.Node> c;
            LineageTreeBuilder.Node node = ((NodeFigure)figure).data;
            if (node instanceof LineageTreeBuilder.GhostNode) {
                node = ((LineageTreeBuilder.GhostNode)node).getBaseNode();
            }
            if ((c = LineageDraw2DHelper.this.ghostPerBase.get(node)) != null) {
                for (LineageTreeBuilder.Node n : c) {
                    IFigure f = LineageDraw2DHelper.this.nodeFigures.get(n);
                    ((NodeFigure)f).ghostFigure.setVisible(false);
                    f.repaint();
                }
            }
        }

        public void setHoveredFigure(IFigure figure) {
            for (IFigure f : this.hoveredFigureTargets) {
                if (this.selectedFigureTargets.contains(f)) continue;
                f.setForegroundColor(LineageDraw2DHelper.this.defaultColor);
                IFigure parent = f.getParent();
                parent.remove(f);
                parent.add(f, 0);
            }
            this.hoveredFigureTargets.clear();
            this.hoveredFigure = figure;
            if (this.hoveredFigure instanceof NodeFigure) {
                IFigure parent;
                LineageTreeBuilder.Node node = ((NodeFigure)this.hoveredFigure).data;
                for (LineageTreeBuilder.Node s : node.getSources()) {
                    for (IFigure f : LineageDraw2DHelper.this.connectionsFigure.get(s)) {
                        if (((PolylineConnection)f).getTargetAnchor().getOwner() != this.hoveredFigure) continue;
                        this.hoveredFigureTargets.add(f);
                        if (this.selectedFigureTargets.contains(f)) continue;
                        f.setForegroundColor(LineageDraw2DHelper.this.srcColor);
                        parent = f.getParent();
                        parent.remove(f);
                        parent.add(f);
                    }
                }
                for (LineageTreeBuilder.Node s : node.getTargets()) {
                    for (IFigure f : LineageDraw2DHelper.this.connectionsFigure.get(s)) {
                        if (((PolylineConnection)f).getSourceAnchor().getOwner() != this.hoveredFigure) continue;
                        this.hoveredFigureTargets.add(f);
                        if (this.selectedFigureTargets.contains(f)) continue;
                        f.setForegroundColor(LineageDraw2DHelper.this.trgColor);
                        parent = f.getParent();
                        parent.remove(f);
                        parent.add(f);
                    }
                }
            }
        }
    }
}

