/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.httprest.impl;

import com.indy.connector.httprest.core.WebServiceExchange;
import com.indy.connector.httprest.core.WebServiceInvoker;
import com.indy.connector.httprest.core.WebServiceMetaData;
import com.indy.engine.action.common.SecretValueImpl;
import com.indy.engine.common.tools.OutputStreamTransformer;
import com.indy.engine.common.tools.impl.JavaObjectHandler;
import com.indy.engine.common.tools.impl.JavaRealObjectHandler;
import com.indy.engine.core.ISecretService;
import com.indy.engine.core.UtilsService;
import com.stambia.httprest.impl.WebServiceInvokerImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;

public class WebServiceJavaHandler
implements JavaRealObjectHandler<WebServiceExchange, WebServiceMetaData> {
    private WebServiceInvoker webServiceInvoker;
    private static UnaryOperator<String> resolveExtValue = t -> {
        try {
            return new SecretValueImpl(t, arg_0 -> ((ISecretService)UtilsService.getSecretService()).decryptString(arg_0), arg_0 -> ((ISecretService)UtilsService.getSecretService()).encryptString(arg_0)).resolveStringSecretValue();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    };

    public void init(WebServiceMetaData metadata, JavaObjectHandler.InitHandler iHandler) throws Exception {
        metadata.init();
        this.webServiceInvoker = new WebServiceInvokerImpl(metadata);
        for (Map.Entry<String, String> entry : this.getContentPathSerializers(metadata).entrySet()) {
            iHandler.addProperty("addContentPathSerializer", entry.getKey(), entry.getValue());
        }
    }

    private Map<String, String> getContentPathSerializers(WebServiceMetaData metadata) {
        HashMap<String, String> map = new HashMap<String, String>();
        String currentPath = "*/*/requestbody";
        if (metadata.request != null) {
            if (metadata.request.content != null) {
                if (metadata.request.content.mediaType == WebServiceMetaData.ContentType.JSON) {
                    map.put(currentPath + "/" + metadata.request.content.id, "json");
                } else if (metadata.request.content.mediaType == WebServiceMetaData.ContentType.XML) {
                    map.put(currentPath + "/" + metadata.request.content.id, "xml");
                }
            }
            if (metadata.request.multipart != null) {
                this.addSerializersFromMultipart(map, metadata.request.multipart, currentPath);
            }
        }
        return map;
    }

    private void addSerializersFromMultipart(Map<String, String> map, WebServiceMetaData.MultipartMetadata multipartMd, String currentPath) {
        currentPath = (String)currentPath + "/" + multipartMd.id;
        for (WebServiceMetaData.PartMetadata partMd : multipartMd.parts) {
            String partPath = (String)currentPath + "/" + partMd.partName;
            if (partMd.part != null) {
                if (partMd.part.mediaType == WebServiceMetaData.ContentType.JSON) {
                    map.put(partPath + "/" + partMd.part.id, "json");
                } else if (partMd.part.mediaType == WebServiceMetaData.ContentType.XML) {
                    map.put(partPath + "/" + partMd.part.id, "xml");
                }
            }
            if (partMd.multipart == null) continue;
            this.addSerializersFromMultipart(map, partMd.multipart, partPath);
        }
    }

    public void handleObject(WebServiceExchange exchange, WebServiceMetaData metadata, OutputStreamTransformer.StatisticHandler sh) throws Exception {
        WebServiceExchange.WebServiceResponse wsre;
        if (metadata.securityParams != null && "oauth2".equals(metadata.securityParams.get("type"))) {
            String clientId = (String)metadata.securityParams.get("clientId");
            String clientSecret = (String)metadata.securityParams.get("clientSecret");
            String username = (String)metadata.securityParams.get("username");
            String password = (String)metadata.securityParams.get("password");
            String securedClientId = (String)resolveExtValue.apply(clientId);
            String securedClientSecret = (String)resolveExtValue.apply(clientSecret);
            String securedUser = (String)resolveExtValue.apply(username);
            String securedPassword = (String)resolveExtValue.apply(password);
            metadata.securityParams.put("clientId", securedClientId);
            metadata.securityParams.put("clientSecret", securedClientSecret);
            metadata.securityParams.put("username", securedUser);
            metadata.securityParams.put("password", securedPassword);
        }
        if ((wsre = this.webServiceInvoker.handleRequest(metadata, exchange)) != null) {
            this.handleStatistics(sh, Integer.valueOf(wsre.respInfos.statusCode));
        }
    }

    private void handleStatistics(OutputStreamTransformer.StatisticHandler sh, int statusCode) {
        sh.handle("HTTP_REQUEST_SENT", 1L);
        if (statusCode < 300) {
            sh.handle("HTTP_REQUEST_SUCCESS", 1L);
            sh.handle("HTTP_RESPONSE_2XX", 1L);
        } else {
            sh.handle("HTTP_REQUEST_FAILURE", 1L);
            if (statusCode < 400) {
                sh.handle("HTTP_RESPONSE_3XX", 1L);
            } else if (statusCode < 500) {
                sh.handle("HTTP_RESPONSE_4XX", 1L);
            } else if (statusCode < 600) {
                sh.handle("HTTP_RESPONSE_5XX", 1L);
            }
        }
    }

    public int batchSize() {
        return 1;
    }

    public void close() throws Exception {
    }
}

