<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:proc="http://www.example.org/proc" xmlns:map="http://www.indy.com/v2/map" xmlns:common="http://exslt.org/common" xmlns:mdj="java:com.semarchy.xdi.designer.generation.xsl.global.Functions" xmlns:wbi="java:com.semarchy.xdi.designer.generation.xsl.global.WorkbenchInvocation" xmlns:mdv="java:com.semarchy.xdi.designer.generation.xsl.global.Variables" xmlns:mds="java:com.semarchy.xdi.designer.generation.xsl.global.Strings" xmlns:fn="http://www.w3.org/2005/02/xpath-functions" xmlns:saxon="http://saxon.sf.net/" exclude-result-prefixes="fn mdj saxon xsl common" xmlns:UUID="java.util.UUID" extension-element-prefixes="saxon">
	<!--Crée un seul proc en allant chercher toute les références
Supprime les étapes et les liens qui sont désactivés par les generationCondition
Les altId sont récupérés
Il faut virer les conditions génération-->
	<xsl:param name="startDir"/>
	<xsl:param name="endDir"/>
	<xsl:param name="eltID"/>
	<xsl:preserve-space elements="p th td br"/>
	<xsl:output method="xml" media-type="text/html" doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN" doctype-system="DTD/xhtml1-strict.dtd" cdata-section-elements="script style" indent="yes"  encoding="UTF-8"/>
	<xsl:template match="/">
		
		<xsl:apply-templates select="proc:process | subProcess" mode="html"/>
	</xsl:template>
	
	<xsl:template match="proc:process | subProcess" mode="html">
	
	 <xsl:apply-templates select="proc:process | subProcess" mode="html"/>
	 <xsl:if test="(@id=$eltID)">
	 <html xmlns="http://www.w3.org/1999/xhtml">
			<head>
				<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
				<link rel="StyleSheet" href="plugin/com.indy.ui.help/html/styles/main_eclipse.css" type="text/css"/>
				<link rel="StyleSheet" href="customCss.css" type="text/css"/>
			</head>
			<body>
				<h2><xsl:value-of select="@name"/></h2>
				<p>
					<!-- img -->
				</p>
				<h3 id="Description">Description</h3>
				<p><xsl:call-template name="break">
   					 <xsl:with-param name="text" select="@description" />
  					</xsl:call-template></p>
				<h3 id="Parameters">Parameters</h3>
				<table>
					<tr>
						<th colspan="1" rowspan="1" style="text-align: left;">Name</th>
						<th colspan="1" rowspan="1" style="text-align: left;">Type</th>
						<th colspan="1" rowspan="1" style="text-align: left;">Default</th>
						<th colspan="1" rowspan="1" style="text-align: left;">Description</th>
					</tr>
					<xsl:for-each select="./parameter">
						<tr>
							<td colspan="1" rowspan="1"><xsl:value-of select="proc:formatParameterName(@name)"/></td>
							<td colspan="1" rowspan="1"><xsl:value-of select="@type"/></td>
							<td colspan="1" rowspan="1"><xsl:value-of select="@value"/></td>
							<td colspan="1" rowspan="1"> 
							
							<xsl:call-template name="break">
   								 <xsl:with-param name="text" select="@description" />
  							</xsl:call-template>
							</td>
						</tr>
					</xsl:for-each>
				</table>
			</body>
		</html>
	 </xsl:if>
		
					
</xsl:template>
	
	<xsl:function name="proc:formatParameterName">
		<xsl:param name="name"/>
		<xsl:value-of select="concat(upper-case(substring($name, 1, 1)), mdj:replaceAll2(substring($name, 2),'([a-z])([A-Z])','([a-z])([A-Z])', '$1 $2'))"/>
	</xsl:function>

	<xsl:template name="break">
		<xsl:param name="text" />
		<xsl:choose>
			<xsl:when test="contains($text, '&#xD;')">
				<xsl:value-of select="substring-before($text, '&#xD;')" />
				<br />
				<xsl:call-template name="break">
					<xsl:with-param name="text"
						select="substring-after($text, '&#xD;')" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
