<?xml version="1.0" ?>
<xsl:stylesheet
	xmlns:gen="java:com.semarchy.xdi.designer.generation.xsl.gene.GeneratedMap"
	xmlns:mdj="java:com.semarchy.xdi.designer.generation.xsl.global.Functions"
	xmlns:mdv="java:com.semarchy.xdi.designer.generation.xsl.global.Variables"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:ref="http://www.stambia.com/ref"
	xmlns:saxon="http://saxon.sf.net/"
	xmlns:tech="http://www.stambia.com/tech"
	xmlns:indyParse="http://www.stambia.com/indyParse"
	xmlns:ecore="http://www.eclipse.org/emf/2002/Ecore"
	xmlns:proc="http://www.example.org/proc"
	xmlns:func="http://www.stambia.com/func"
	xmlns:rdbms="http://www.stambia.com/rdbms"
	xmlns:md="http://www.stambia.com/md"
	xmlns:user="http://www.stambia.com/user"
	xmlns:UUID="java.util.UUID"
	xmlns:mds="java:com.semarchy.xdi.designer.generation.xsl.global.Strings"
	xmlns:map="http://www.stambia.com/map"
	xmlns:saxono="http://www.example.org/saxono"
	xmlns:xslo="http://www.example.org/xslo"
	xmlns:foo="http://www.example.org/foo"
	xmlns:procGen="http://www.stambia.com/procGen/com.semarchy.xdi.designer.generation.xsl.test.TExtensionElementFactory"
	xmlns:graph="java:com.semarchy.xdi.designer.generation.xsl.gene.process"
	xmlns:stack="java:com.semarchy.xdi.designer.generation.xsl.test.StackedVariableManager"
	version="2.0"
	extension-element-prefixes="saxon ref indyParse tech procGen"
	exclude-result-prefixes="ecore tech UUID proc func md rdbms mds user mdj mdv tech map saxon graph stack">

	<xsl:template name="pushTpl">
		<xsl:param name="stepNode" />
		<xsl:for-each select="$stepNode/mdLink">
			<xsl:variable name="cur" select="." />
			<procGen:pushVar variableName="string($cur/@name)" select="mdj:getRef(., string($cur/@expression))" mode="xsl" isMdLink="true"/>
		</xsl:for-each>
		<xsl:for-each select="$stepNode/xslVariable">
			<xsl:variable name="cur" select="." />
			<xsl:choose>
				<xsl:when test="$cur/@type='xsl'">
					<xsl:variable name="__parseVar">
						<saxon:call-template name="initVar_{$cur/@srcId}" />
					</xsl:variable>
					<procGen:pushVar variableName="string($cur/@name)" select="$__parseVar" mode="xsl"/>
				</xsl:when>
				<xsl:when test="./@type='xpath' and $cur/@needParse='true'">
					<xsl:variable name="__parseVar">
						<saxon:call-template name="initVar_{$cur/@srcId}" />
					</xsl:variable>
					<procGen:pushVar variableName="string($cur/@name)" select="$__parseVar" mode="xpath"/>
				</xsl:when>
				<xsl:when test="./@type='xpath'">
					<procGen:pushVar variableName="string($cur/@name)" select="string($cur/@expression)" mode="xpath" />
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="popTpl">
		<xsl:param name="stepNode" />

		<xsl:for-each select="$stepNode/*[name()='xslVariable' or name()='mdLink']">
			<xsl:variable name="cur" select="." />
			<procGen:popVar variableName="string($cur/@name)" />
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="eval__XXX">
		<xsl:param name="nodeId" />
		<xsl:param name="__repetetitions" />
		<xsl:param name="generated" />
		<xsl:param name="hasRepetition" />
		<xsl:choose>
			<xsl:when test="$generated=true()">
				<xsl:choose>
					<xsl:when test="$hasRepetition=false()">
						<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'START','')" />
						<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'GENERATE','')" />
						<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'END','')" />
					</xsl:when>
					<xsl:when test="$hasRepetition=true() and count($__repetetitions)>0">
						<xsl:for-each select="$__repetetitions">
							<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'START','')" />
							<xsl:variable name="__nodeInfoId">
								<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'ITERATION',if (current()/@name !='') then current()/@name else concat('', position()))" />
							</xsl:variable>
							<xsl:value-of select="stack:storeValue($__nodeInfoId, current())" />
							<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'END','')" />
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'START','')" />
						<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'NO_GENERATE','')" />
						<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'END','')" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'START','')" />
				<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'NO_GENERATE','')" />
				<xsl:value-of select="graph:handleGenerationEvent($nodeId, 'END','')" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>


	<xsl:param name="genMap" />

	<xsl:template name="root" match="/">

		<xsl:for-each select="node[1]">
			<result>
				<xsl:call-template name="metadataTrigger">
					<xsl:with-param name="this" select="$__oneProc/*[1]" />
				</xsl:call-template>

				<xsl:value-of select="graph:handleGenerationEvent(current()/@id, 'START', '')" />
				<xsl:value-of select="graph:handleGenerationEvent(current()/@id, 'GENERATE', '')" />
				<xsl:value-of select="graph:handleGenerationEvent(current()/@id, 'END', '')" />
				<xsl:call-template name="main">
					<xsl:with-param	name="oneProcNode"
						select="$__oneProc/*[(name()='proc:process' or name()='subProcess' or name()='actionCode') and @id=current()/@id]" />
				</xsl:call-template>


				<xsl:copy-of select="$allConnection/*[name()='connection']" />
			</result>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="generate">
		<xsl:param name="graphNode" />
		<xsl:param name="nodeInfoId" />
		<xsl:param name="processNode" />
		<!-- during generation, we need the '.' to be the oneProcessNode-->
		<xsl:variable name="__nodeCtx" select="if (exists($processNode)) then $processNode else (.)" />
		<xsl:for-each select="$graphNode/parameter[@needParse='true']">
			<xsl:variable name="__tplSuffix" select="./@srcId" />
			<xsl:variable name="__pName" select="./@name" />
			<xsl:for-each select="$__nodeCtx">
				<xsl:variable name="__gen">
					<saxon:call-template name="initParameter_{$__tplSuffix}" />
				</xsl:variable>
				<xsl:value-of select="gen:store($genMap, concat($nodeInfoId, '.parameter.',$__pName), $__gen)" />
			</xsl:for-each>
		</xsl:for-each>

		<xsl:if test="$graphNode/@type='ACTION'">
	
			<xsl:choose>
				<xsl:when test="exists($graphNode/@moduleName)">
					<xsl:for-each select="$graphNode">
						<xsl:value-of select="gen:store($genMap, concat($nodeInfoId, '.module'), $graphNode/@moduleName)" />
					</xsl:for-each>
				</xsl:when>
				<xsl:when test="exists($graphNode/@moduleNameNeedParse)">
					<xsl:for-each select="$graphNode">
						<xsl:variable name="moduleName">
							<saxon:call-template
								name="initActionModuleName_{$graphNode/@srcId}" />
						</xsl:variable>
						<xsl:if test="$moduleName!=''">
							<xsl:value-of
								select="gen:store($genMap, concat($nodeInfoId, '.module'), $moduleName)" />
						</xsl:if>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<!-- do nothing, it will be handled by the mdLinks-->
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
 	

		<xsl:if test="$graphNode/@hasCode='true'">
			<xsl:for-each select="$__nodeCtx">
				<xsl:variable name="__gen">
				<saxon:call-template name="initAction_{$graphNode/@srcId}" />
			</xsl:variable>
			<xsl:value-of select="gen:store($genMap, concat($nodeInfoId, '.code'), $__gen)" />
			</xsl:for-each>
			
		</xsl:if>
		<xsl:if test="$graphNode/@executionCondition='true'">
			<xsl:for-each select="$__nodeCtx">
				<xsl:variable name="__gen">
					<saxon:call-template name="initExecutionConditionLink_{$graphNode/@srcId}" />
				</xsl:variable>
				<xsl:value-of select="gen:store($genMap, concat($nodeInfoId, '|--', graph:getLinkInputNodeInfoId($nodeInfoId), '.executionCondition'), $__gen)" />
			</xsl:for-each>
			
		</xsl:if>
		<xsl:if test="$graphNode/@dynamicName='true'">
			<xsl:for-each select="$__nodeCtx">
				<xsl:variable name="__gen">
				<saxon:call-template name="initStepDynamicName_{$graphNode/@id}" />
			</xsl:variable>
			<xsl:value-of select="gen:store($genMap, concat($nodeInfoId, '.dynamicName'), $__gen)" />
			</xsl:for-each>
		</xsl:if>
		<xsl:if test="$graphNode/@semaphoreName='true'">
			<xsl:for-each select="$__nodeCtx">
				<xsl:variable name="__gen">
					<saxon:call-template name="initStepSemaphoreName_{$graphNode/@id}" />
				</xsl:variable>
			<xsl:value-of select="gen:store($genMap, concat($nodeInfoId, '.semaphoreName'), $__gen)" />
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="main">
		<xsl:param name="oneProcNode" />
		
		<xsl:variable name="currentNode" select="." />
		<xsl:value-of select="jstack:push($__jStack, string($oneProcNode/@name))"/>		
		<xsl:if test="@withContext='true'">
			<procGen:pushVar variableName="'this'" select="$oneProcNode" mode="xsl"/>
			<xsl:if test="@contextHasContent='true'">
				<xsl:call-template name="pushTpl">
					<xsl:with-param name="stepNode" select="$currentNode" />
				</xsl:call-template>

			</xsl:if>
		</xsl:if>

		<xsl:for-each select="node">
			<xsl:sort select="@generationOrder" data-type="number" />
			<xsl:variable name="__cuNodeId" select="string(./@id)" />
			<xsl:variable name="__cuNode" select="if (./@isLink='true') then saxon:evaluate(graph:getProcNodeXPathExpression($currentNode/@id), $__oneProc) else $oneProcNode/child::node()[@id=$__cuNodeId]" />

			<xsl:variable name="needPush" select="@evalNeedsMdLink='true'"/>
			<!-- to handle steps which are using their own mdLinks in their condition/repetitionQuery -->
			<xsl:if test="$needPush">
				<xsl:call-template name="pushTpl">
					<xsl:with-param name="stepNode" select="." />
				</xsl:call-template>
			</xsl:if>
			
			<xsl:call-template name="eval__XXX">
				<xsl:with-param name="nodeId" select="./@id" />
				<xsl:with-param name="generated" select="if (./@condition!='') then mdj:evaluateCondition($__cuNode, string(./@condition)) else true()" />
				<xsl:with-param	name="__repetetitions" select="if(./@repetitionQuery!='') then func:repetitionValues(./@repetitionQueryHash) else ''" />
				<xsl:with-param name="hasRepetition" select="./@repetitionQuery!=''" />
			</xsl:call-template>
			
			<xsl:if test="$needPush">
				<xsl:call-template name="popTpl">
					<xsl:with-param name="stepNode" select="." />
				</xsl:call-template>
			</xsl:if>
		</xsl:for-each>

		<xsl:variable name="currentNodeInfoId">
			<xsl:value-of select="graph:handleGenerationEvent(@id, 'BUILD_CONTENT', '')" />
		</xsl:variable>

		<xsl:if test="graph:needGeneration($currentNodeInfoId)=true()">
			<xsl:variable name="__firstNodeInfoIdWithRepetition" select="graph:getFirstNodeInfoIdWithRepetition($currentNodeInfoId)" />
			<xsl:choose>
				<xsl:when test="exists($__firstNodeInfoIdWithRepetition)">
					<xsl:for-each select="stack:getStoredValue($__firstNodeInfoIdWithRepetition)">
						<xsl:call-template name="generate">
							<xsl:with-param name="nodeInfoId" select="$currentNodeInfoId" />
							<xsl:with-param name="graphNode" select="$currentNode" />
							<xsl:with-param name="processNode" select="." /><!-- in repetition queries, the . must be the repetition value -->
						</xsl:call-template>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="generate">
						<xsl:with-param name="nodeInfoId" select="$currentNodeInfoId" />
						<xsl:with-param name="graphNode" select="$currentNode" />
						<xsl:with-param name="processNode" select="$oneProcNode" />
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>


		<xsl:if test="$this/name()='actionCode' and $this/@technology ='com.indy.engine.actionCodes.JdbcActionCodeI'">
			<xsl:variable name="__conTrigger">
				<xsl:call-template name="connectionTrigger">
					<xsl:with-param name="this" select="$this" />
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="exists($__conTrigger)">
				<xsl:copy-of select="$__conTrigger/connection" />
				<xsl:for-each select="$__conTrigger/parameter">
					<xsl:if test="gen:isStored($genMap, concat($currentNodeInfoId, '.parameter.',./@name))=false()">
						<xsl:value-of select="gen:store($genMap, concat($currentNodeInfoId, '.parameter.',./@name), ./@value)" />
					</xsl:if>
				</xsl:for-each>
			</xsl:if>
		</xsl:if>


		<xsl:if test="$this/name()='actionCode' and exists($this/metaDataLink)">
			<xsl:for-each select="$this/metaDataLink">
				<xsl:variable name="metaDataLink"  select="stack:getCurrentValue(./@name, true())" />
				<xsl:variable name="level" 	select="if ($metaDataLink) then mdj:getLevel($metaDataLink) else None" />
				<xsl:variable name="metaDataLinkType" select="$level/../metaDataLinkType[level=concat('#',$level/@code)]" />
				<xsl:for-each select="$metaDataLinkType/parameter">
					<xsl:if test="exists($this/parameter[@name=current()/@name])=false() and gen:isStored($genMap, concat($currentNodeInfoId, '.parameter.',./@name))=false() and (../(technology=$this/@technology or technology='*'))">
						<xsl:variable name="value" select="mdj:evaluate($metaDataLink,@value)" />
						<xsl:variable name="connValue">
							<xsl:if test="exists($value)">
								<xsl:if test="mdj:isNode($value)">
									<xsl:if test="not($value/text()!='')">
										<xsl:apply-templates select="$value" mode="connection" />
									</xsl:if>
								</xsl:if>
							</xsl:if>
						</xsl:variable>
						<xsl:variable name="value" select="if ($connValue!='') then $connValue else $value" />
						<xsl:if test="$value!=''">
							<xsl:value-of select="gen:store($genMap, concat($currentNodeInfoId, '.parameter.',./@name), $value)" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
				<xsl:for-each select="$metaDataLinkType/actionCodeProperty[@name='moduleName']">
					<xsl:if test="gen:isStored($genMap, concat($currentNodeInfoId, '.module'))=false() and (../(technology=$this/@technology or technology='*'))">
						<xsl:variable name="value" select="mdj:evaluate($metaDataLink,@value)" />
						<xsl:variable name="connValue">
							<xsl:if test="exists($value)">
								<xsl:if test="mdj:isNode($value)">
									<xsl:if test="not($value/text()!='')">
										<xsl:apply-templates select="$value" mode="connection" />
									</xsl:if>
								</xsl:if>
							</xsl:if>
						</xsl:variable>
						<xsl:variable name="value" select="if ($connValue!='') then $connValue else $value" />
						<xsl:if test="$value!=''">
							<xsl:value-of select="gen:store($genMap, concat($currentNodeInfoId, '.module'), $value)" />
						</xsl:if>
					</xsl:if>
				</xsl:for-each>
			</xsl:for-each>
		</xsl:if>


		<xsl:for-each select="graph:getChildrenInstance($currentNodeInfoId)">

			<xsl:if test="graph:isEvaluated(current())=true()">
				<xsl:value-of select="graph:handleGenerationEvent(current(), 'PUSH', '')" />
				<xsl:variable name="currentChildren" select="$currentNode/node[@id=graph:getNodeId(current())]" />
				<xsl:variable name="__cuNodeId" select="graph:getNodeId(current())" />
				<xsl:variable name="__cuNode" select="if ($currentChildren/@isLink='true') then saxon:evaluate(graph:getProcNodeXPathExpression($currentChildren/@id), $__oneProc) else $oneProcNode/child::node()[@id=$__cuNodeId]" />

				<xsl:choose>
					<xsl:when test="$currentChildren/@repetitionQuery!=''">
						<xsl:choose>
							<xsl:when test="$currentChildren/@repetitionVar!=''">
								<xsl:variable name="__repetitionValue" 	select="stack:getStoredValue(current())" />

								<procGen:pushVar variableName="string($currentChildren/@repetitionVar)" select="$__repetitionValue" mode="xsl"/>
								<xsl:for-each select="$currentChildren">
									<xsl:call-template name="main">
										<xsl:with-param name="oneProcNode" select="$__cuNode" />
									</xsl:call-template>
								</xsl:for-each>
								<procGen:popVar variableName="string($currentChildren/@repetitionVar)" />
							</xsl:when>
							<xsl:otherwise>
								<xsl:variable name="curChildId" select="current()" />

								<xsl:for-each select="$currentChildren">
									<xsl:call-template name="main">
										<xsl:with-param	name="oneProcNode" select="$__cuNode" />
									</xsl:call-template>
								</xsl:for-each>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:for-each select="$currentChildren">
							<xsl:call-template name="main">
								<xsl:with-param name="oneProcNode" select="$__cuNode" />
							</xsl:call-template>
						</xsl:for-each>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:value-of select="graph:handleGenerationEvent(current(), 'POP', '')" />
			</xsl:if>
		</xsl:for-each>

		<xsl:if test="@withContext='true'">
			<xsl:if test="@contextHasContent='true'">
				<xsl:call-template name="popTpl">
					<xsl:with-param name="stepNode" select="$currentNode" />
				</xsl:call-template>
			</xsl:if>
			<procGen:popVar variableName="'this'" />
		</xsl:if>
		<xsl:value-of select="jstack:pop($__jStack)"/>
	</xsl:template>
</xsl:stylesheet>