<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:proc="http://www.example.org/proc" xmlns:deliv="http://www.stambia.com/deliv" 
xmlns:mdj="java:com.semarchy.xdi.designer.generation.xsl.global.Functions" xmlns:mdv="java:com.semarchy.xdi.designer.generation.xsl.global.Variables" xmlns:fn="http://www.w3.org/2005/02/xpath-functions" 
xmlns:saxon="http://saxon.sf.net/" xmlns:ref="http://www.stambia.com/ref" xmlns:tech="http://www.stambia.com/tech" xmlns:rdbms="http://www.example.org/rdbms" 
xmlns:prop="java:java.util.Properties" xmlns:sr="java:java.io.StringReader"
exclude-result-prefixes="mdj mdv saxon xsl proc deliv fn ref tech rdbms" extension-element-prefixes="saxon">


	<xsl:variable name="sqlParametersMap">
		<map name="JDBC.URL" xpath="JDBC_URL"/>
		<map name="JDBC.PASSWORD" xpath="ENCRYPTED_JDBC_PASSWORD"/>
		<map name="JDBC.DRIVER" xpath="JDBC_DRIVER"/>
		<map name="JDBC.USER" xpath="JDBC_USER"/>
		<map name="JDBC.CONNECTION_POOL_ENABLED" xpath="JDBC.CONNECTION_POOL_ENABLED"/>
		<map name="JDBC.CONNECTION_POOL_IDLE_TIMEOUT" xpath="JDBC.CONNECTION_POOL_IDLE_TIMEOUT"/>
		<map name="JDBC.CONNECTION_POOL_MAX_LIFETIME" xpath="JDBC.CONNECTION_POOL_MAX_LIFETIME"/>
		<map name="JDBC.CONNECTION_POOL_MIN_IDLE" xpath="JDBC.CONNECTION_POOL_MIN_IDLE"/>
		<map name="JDBC.CONNECTION_POOL_VALIDATION_TIMEOUT" xpath="JDBC.CONNECTION_POOL_VALIDATION_TIMEOUT"/>
		<map name="JDBC.CONNECTION_POOL_KEEP_ALIVE" xpath="JDBC.CONNECTION_POOL_KEEP_ALIVE"/>
		<map name="JDBC.CONNECTION_POOL_MAX_SIZE" xpath="JDBC.CONNECTION_POOL_MAX_SIZE"/>
		<map name="JDBC.BATCH_SIZE" xpath="JDBC.BATCH_SIZE"/>
		<map name="JDBC.FETCH_SIZE" xpath="JDBC.FETCH_SIZE"/>
		<map name="TECH.OBJECT_START_DELIMITER" xpath="OBJECT_START_DELIMITER"/>
		<map name="TECH.OBJECT_END_DELIMITER" xpath="OBJECT_END_DELIMITER"/>
		<map name="JDBC.READ_AUTOCOMMIT_MODE" xpath="JDBC_READ_AUTOCOMMIT_MODE"/>
		<map name="JDBC.CONNECTION_INIT_SQLS" xpath="JDBC.CONNECTION_INIT_SQLS"/>
		<map name="JDBC.MODULE" xpath="JDBC.MODULE"/>
	</xsl:variable>

	<xsl:template match="node()" mode="connection">
		<xsl:variable name="performGen" select="./tech:genExtractConnection()"/>
		<xsl:choose>
			<xsl:when test="((name()='server' and @defType='com.stambia.rdbms.server') or name()='file' or name()='record' or name()='hbaseServer')">
				<xsl:call-template name="extractConnection">
					<xsl:with-param name="forceRDBMS" select="true()"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="$performGen">
				<xsl:call-template name="extractConnection">
					<xsl:with-param name="forceRDBMS" select="tech:genIsRdbmsConnection()"/>
				</xsl:call-template>
			</xsl:when>
			
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="extractConnection">
		<xsl:param name="forceRDBMS"/>
		
		<!-- reference to the connectionDefinition -->
		<xsl:if test="not($allConnection/connection[@name=current()/tech:connectionName()])">
			<xsl:variable name="connectionDefinition" select="./ref:genConnectionDefinition()"/>
			<xsl:if test="exists($connectionDefinition) or $forceRDBMS">
				<xsl:variable name="connTrans">
					<connection name="{tech:connectionName()}" type="{if ($forceRDBMS) then 'RDBMS' else $connectionDefinition/tech:connectionType()}">
						<xsl:variable name="current" select="."/>
						<xsl:if test="$forceRDBMS">
							<xsl:for-each select="$sqlParametersMap/map">
								<xsl:call-template name="addParameter">
									<xsl:with-param name="name" select="@name"/>
									<xsl:with-param name="value" select="$current/mdj:xpath(.,current()/@xpath)"/>
								</xsl:call-template>
							</xsl:for-each>
						</xsl:if>
						<xsl:if test="exists($connectionDefinition)">
							<xsl:variable name="forcedParams" select="string-join($sqlParametersMap/map/@name, ';')" />
							<xsl:for-each select="$connectionDefinition/parameter">
								<xsl:if test="not($forceRDBMS and contains($forcedParams, @name))">
									<xsl:call-template name="addParameter">
										<xsl:with-param name="name" select="@name" />
										<xsl:with-param name="value" select="$current/mdj:xpath(.,current()/@xPathExpressionCode)" />
									</xsl:call-template>
								</xsl:if>
								
							</xsl:for-each>
						</xsl:if>
						
						<xsl:call-template name="createDataTypeParameters">
							<xsl:with-param name="dataTypeRef" select="mdj:xpath(.,'VARCHAR_TYPE_REF')"/>
							<xsl:with-param name="type">VARCHAR</xsl:with-param>
						</xsl:call-template>
						<xsl:call-template name="createDataTypeParameters">
							<xsl:with-param name="type">NUMERIC</xsl:with-param>
							<xsl:with-param name="dataTypeRef" select="mdj:xpath(.,'NUMERIC_TYPE_REF')"/>
						</xsl:call-template>
						<xsl:call-template name="createDataTypeParameters">
							<xsl:with-param name="type">DATE</xsl:with-param>
							<xsl:with-param name="dataTypeRef" select="mdj:xpath(.,'DATE_TYPE_REF')"/>
						</xsl:call-template>
						<xsl:for-each select="mdj:xpath(.,'PROPERTY_REF')">
							<xsl:call-template name="addParameter">
								<xsl:with-param name="name" select="concat('JDBC.PROPERTY.',mdj:xpath(.,'NAME'))"/>
								<xsl:with-param name="value" select="mdj:xpath(.,'VALUE')"/>
							</xsl:call-template>
						</xsl:for-each>
						<xsl:for-each select="mdj:xpath(.,'ADDITIONAL_PROPERTY_REF')">
							<parameter name="{.}" type="Boolean" value="true"/>
						</xsl:for-each>
						
						<!-- fix bug 3112 : allow to provider properties from an xPathExpression -->
					<xsl:variable name="additional" select="prop:new()"/>
					<xsl:value-of select="prop:load($additional,sr:new($current/tech:genConnectionExtraProperties()))" />
					<xsl:if test="prop:isEmpty($additional)=false()">
						<xsl:for-each select="prop:keySet($additional)">
							<xsl:call-template name="addParameter">
								<xsl:with-param name="name" select="."/>
								<xsl:with-param name="value" select="prop:getProperty($additional, .)"/>
							</xsl:call-template>
						</xsl:for-each>
					</xsl:if>
				
						<xsl:if test="../parameter/@name='SQL_TRANSACTION_NAME'">
							<transaction name="{../parameter[@name='SQL_TRANSACTION_NAME']/@value}"/>
						</xsl:if>
					</connection>
				</xsl:variable>
				<saxon:assign name="allConnection">
					<xsl:if test="not($allConnection/temp)">
						<xsl:copy-of select="$allConnection"/>
					</xsl:if>
					<xsl:copy-of select="$connTrans" copy-namespaces="no"/>
				</saxon:assign>
			</xsl:if>
			
		</xsl:if>
		<xsl:value-of select="tech:connectionName()"/>
	</xsl:template>
	<xsl:template match="connection[@type='RDBMS']" mode="transaction">
		<xsl:param name="process"/>
		<xsl:element name="{name()}">
			<xsl:copy-of select="@*|*"/>
			<xsl:for-each select="distinct-values($process//parameter[@name='SQL_CONNECTION' and @value=current()/@name]/../parameter[@name='SQL_TRANSACTION_NAME' and @value!='']/@value)">
				<transaction name="{.}"/>
			</xsl:for-each>
		</xsl:element>
	</xsl:template>
	<!---->
	<xsl:template name="createDataTypeParameters">
		<xsl:param name="dataTypeRef"/>
		<xsl:param name="type">
			<!--VARCHAR, NUMERIC ou DATE-->
		</xsl:param>
		<xsl:if test="$dataTypeRef">
			<xsl:variable name="size" select="mdj:xpath($dataTypeRef,'MAX_SIZE')"/>
			<xsl:variable name="mask" select="mdj:xpath($dataTypeRef,'SIMPLE_MASK')"/>
			<xsl:variable name="code" select="mdj:xpath($dataTypeRef,'SQL_TYPE')"/>
			<xsl:if test="$code">
				<parameter name="TECH.{$type}_TYPE" type="String" value="{$code}"/>
			</xsl:if>
			<xsl:if test="$size">
				<parameter name="TECH.{$type}_MAX_SIZE" type="String" value="{$size}"/>
			</xsl:if>
			<xsl:if test="$mask">
				<parameter name="TECH.{$type}_MASK" type="String" value="{$mask}"/>
			</xsl:if>
		</xsl:if>
	</xsl:template>
	<xsl:variable name="allConnection" saxon:assignable="yes">
		<temp/>
		<!--ne pas effacer la balise temp autrement e-->
	</xsl:variable>
	<xsl:template name="addParameter">
		<xsl:param name="name"/>
		<xsl:param name="value"/>
		<xsl:param name="type">String</xsl:param>
		<xsl:for-each select="$value">
			<xsl:if test=".!=''">
				<parameter name="{$name}{if (position()=1) then '' else concat('.',position())}" type="{$type}" value="{.}"/>
			</xsl:if>
		</xsl:for-each> 
	</xsl:template>
	<xsl:template name="connectionTrigger">
		<xsl:param name="this"/>
		<xsl:choose>
			<xsl:when test="$this/@technology ='com.indy.engine.actionCodes.JdbcActionCodeI' and not($this/parameter[@name='SQL_CONNECTION']/@value!='')">
				<!--Si jdbc et pas de SQL CONNECTION alors on cherche parmis le premier metaDataLink du noeud ou père-->
				<xsl:variable name="mdlink" select="$this/ancestor-or-self::*[exists(metaDataLink[1])][1]/metaDataLink[1]"/>
				<xsl:variable name="variable" select="mdj:getMdRef($mdlink[1])"/>
				<xsl:variable name="connRef" select="mdj:xpath($variable,'TARGET_CONNECTION_REF')"/>
				<xsl:if test="$connRef">
					<xsl:variable name="connName">
						<xsl:apply-templates mode="connection" select="$connRef"/>
					</xsl:variable>
					<parameter name="SQL_CONNECTION" type="String" value="{$connName}"/>
					<xsl:value-of select="mdv:addMap('SQL_CONNECTION','ok')"/>
				</xsl:if>
			</xsl:when>
			<xsl:when test="$this/metaDataLink[1] and $this/parameter[@name='SQL_CONNECTION']/@value=''">
				<!--Si jdbc et pas de SQL CONNECTION alors on cherche parmis le premier metaDataLink du noeud-->
				<xsl:variable name="variable" select="mdj:getMdRef($this/metaDataLink[1]) "/>
				<xsl:variable name="connRef" select="mdj:xpath($variable,'TARGET_CONNECTION_REF')"/>
				<xsl:if test="$connRef">
					<xsl:variable name="connName">
						<xsl:apply-templates mode="connection" select="$connRef"/>
					</xsl:variable>
					<parameter name="SQL_CONNECTION" type="String" value="{$connName}"/>
					<xsl:value-of select="mdv:addMap('SQL_CONNECTION','ok')"/>
				</xsl:if>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="metadataTrigger">
		<xsl:param name="this"/>
		<xsl:for-each select="$this/metaDataLink[@input='true' or @output='true' or @fault='true']">
			<xsl:variable name="variable" select="mdj:getMdRef(.) "/>
			<xsl:variable name="type" select="$variable/tech:ioMetaDataType()"/>
			<xsl:if test="$type!=''">
				<metaDataLink>
					<xsl:copy-of select="@*"/>
					<metaData type="{$type}" name="{$variable/tech:ioMetaDataName()}" resource="{$variable/tech:ioMetaDataResource()}" id="{$variable/tech:ioMetaDataId()}" internetMediaType="{$variable/tech:ioMetaDataInternetMediaType()}">
						<xsl:value-of select="$variable/tech:ioMetaData()"/>
					</metaData>
				</metaDataLink>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
