<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:mdj="java:com.semarchy.xdi.designer.generation.xsl.global.Functions" xmlns:xslo="http://www.example.org/xslo" xmlns:proc="http://www.example.org/proc" xmlns:deliv="http://www.stambia.com/deliv" xmlns:common="http://exslt.org/common" xmlns:rdbms="http://www.example.org/rdbms" xmlns:mdv="java:com.semarchy.xdi.designer.generation.xsl.global.Variables" xmlns:fn="http://www.w3.org/2005/02/xpath-functions" xmlns:ex="http://www.stambia.com/externalize" xmlns:UUID="java.util.UUID" exclude-result-prefixes="UUID ex fn mdv rdbms common proc xslo xsl">
	<!--Calcul les préfixes des actions et des paramètres
Cherche aprmis tous les datalinks les paramètres de connexion
Modifie l'aspect du fichier pour qu'il corresponde à un delivery-->
	<xsl:namespace-alias stylesheet-prefix="xslo" result-prefix="xsl"/>
	<xsl:param name="userName"/>
	<xsl:param name="externalize">false</xsl:param>
	<xsl:param name="mode">normal</xsl:param>
	<xsl:param name="conf"/>
	<xsl:param name="allowedScriptErrors">false</xsl:param>
	<xsl:param name="allowedVariableErrors">false</xsl:param>
	<xsl:param name="regex">(v_a_r_([0-9]+)_r_a_v)</xsl:param>
	<xsl:param name="externalize_file_in"/>
	<xsl:param name="externalize_file_out"/>
	<xsl:param name="packageId"/>
	<xsl:param name="xdgAggregatedMdPath"/>
	<xsl:output method="xml" encoding="UTF-8" cdata-section-elements="linkCondition step metaData"/>
	<xsl:include href="global.xsl"/>
	<xsl:variable name="root" select="."/>
	<xsl:variable name="indexes" select="if ($externalize) then document(mdj:normalizeURI($externalize_file_in))/*/* else None"/>
	<xsl:template match="/">
		<xsl:variable name="dateTime" select="current-dateTime()"/>
		<xsl:value-of select="mdv:resetMap('foundVar')" />
		<deliv:delivery configurationCode="{$conf}" allowedScriptErrors="{$allowedScriptErrors}" allowedVariableErrors="{$allowedVariableErrors}" processId="{*/altId[@origin='compilation']/@value}" exportDate="{$dateTime}" exportUser="{$userName}">
			<xsl:if test="not($externalize='true')">
				<xsl:attribute name="buildDate" select="$dateTime"/>
				<xsl:attribute name="buildUser" select="$userName"/>
			</xsl:if>
			<xsl:if test="$externalize='true'">
				<xsl:choose>
					<xsl:when test="not($packageId)">
						<xsl:attribute name="packageId" select="*/@id"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="packageId" select="$packageId"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:attribute name="externalized">true</xsl:attribute>
				<xsl:attribute name="regex" select="$regex"/>
			</xsl:if>
			<xsl:if test="not($externalize='true') and not($packageId='')">
				<xsl:attribute name="packageId" select="$packageId"/>
			</xsl:if>
			<xsl:if test="*/@metaInf!=''">
				<xsl:copy-of select="*/@metaInf" copy-namespaces="no"/>
			</xsl:if>
			<xsl:if test="*/@dynamicName!=''">
				<xsl:copy-of select="*/@dynamicName" copy-namespaces="no"/>
			</xsl:if>
			<xsl:attribute name="id"><xsl:value-of select="*/@id"/></xsl:attribute>
			<xsl:variable name="all">
				<xsl:apply-templates>
					<xsl:with-param name="isBeginProcess">true</xsl:with-param>
				</xsl:apply-templates>
			</xsl:variable>
			<xsl:variable name="connection">
				<xsl:apply-templates select="*/connection" mode="transaction">
					<xsl:with-param name="process" select="/"/>
				</xsl:apply-templates>
			</xsl:variable>
			<xsl:variable name="connection">
				<xsl:apply-templates select="$connection" mode="parseParameter"/>
			</xsl:variable>
			<xsl:variable name="parameter">
				<xsl:apply-templates select="proc:process/parameter">
					<xsl:with-param name="prefixe" select="proc:process/@name"/>
				</xsl:apply-templates>
			</xsl:variable>
			<xsl:variable name="metaDataLink">
				<xsl:apply-templates select="proc:process/metaDataLink" mode="metaDataLink"/>
			</xsl:variable>
			<xsl:variable name="final">
				<xsl:apply-templates select="$all" mode="final"/>
			</xsl:variable>
			<!-- fix bug 3076 -->
			<!-- fix bug DI-1332: must be done before loop on externalized keys -->
			<xsl:for-each select="proc:process/parameter/@value">
				<xsl:call-template name="parseParameter"/>
			</xsl:for-each>
			<!-- fix DI-2570 : mdLinks can contains informations coming from externalized attributes --> 
			<xsl:for-each select="proc:process/metaDataLink/metaData/@*">
				<xsl:call-template name="parseParameter"/>
			</xsl:for-each>
			<xsl:variable name="_externalize">
				<xsl:for-each select="mdv:getMapKeys('foundVar')">
					<xsl:variable name="ref" select="$indexes//*[@index=current()]"/>
					<xsl:variable name="path">
						<xsl:for-each select="$ref/ancestor-or-self::*">/<xsl:value-of select="@name"/>
						</xsl:for-each>
					</xsl:variable>
					<xsl:if test="exists($ref)">
						<externalize nodeId="{$ref/../@id}" nodePath="{$path}" nodeType="{$ref/../@defType}" displayName="{$ref/@displayName}" xmlName="{$ref/@xmlName}" index="{$ref/@index}">
							<xsl:copy-of select="$ref/value" copy-namespaces="no"/>
						</externalize>					
					</xsl:if>
					
				</xsl:for-each>
			</xsl:variable>
			<xsl:variable name="_externalize">
				<xsl:for-each-group select="$_externalize/externalize" group-by="@nodeId">
					<externalize>
						<xsl:copy-of select="@nodeId | @nodePath | @nodeType | @nodeName"/>
						<xsl:for-each select="$_externalize/externalize[@nodeId=current()/@nodeId]">
							<property>
								<xsl:copy-of select="@xmlName | @index | @displayName"/>
							</property>
						</xsl:for-each>
					</externalize>
				</xsl:for-each-group>
			</xsl:variable>
			<xsl:if test="$mode!='debug'">
				<xsl:copy-of copy-namespaces="no" select="$_externalize"/>
				<xsl:copy-of copy-namespaces="no" select="$connection"/>
				<xsl:copy-of copy-namespaces="no" select="$parameter"/>
				<xsl:copy-of copy-namespaces="no" select="$metaDataLink"/>
				<xsl:copy-of select="*/altId" copy-namespaces="no"/>
				<xsl:copy-of copy-namespaces="no" select="$final"/>
			</xsl:if>
			<xsl:if test="$mode='debug'">
				<all>
					<xsl:copy-of select="$all"/>
				</all>
				<connection>
					<xsl:copy-of select="$connection"/>
				</connection>
				<final>
					<xsl:copy-of select="$final"/>
				</final>
			</xsl:if>
			
			<xsl:if test="$externalize='true'">
				<xsl:result-document href="file:///{$externalize_file_out}">
					<xsl:variable name="__packageId">
						<xsl:choose>
							<xsl:when test="not($packageId)">
								<xsl:value-of select="*/@id"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$packageId"/>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:variable>
					
					<ex:externalize packageId="{$__packageId}" userName="{$userName}" date="{$dateTime}" processId="{*/altId[@origin='compilation']/@value}" configurationCode="{$conf}">
						<xsl:apply-templates mode="externalize" select="$indexes">
							<xsl:with-param name="externalize" select="$externalize"/>
						</xsl:apply-templates>
					</ex:externalize>
				</xsl:result-document>
			</xsl:if>
		</deliv:delivery>
	</xsl:template>
	<xsl:template match="value" mode="externalize">
		<xsl:copy-of select="."/>
	</xsl:template>
	<xsl:template match="*" mode="externalize">
		<xsl:param name="externalize" tunnel="yes"/>
		<xsl:if test="exists(descendant-or-self::ex:attribute[@index=mdv:getMapKeys('foundVar')])">
			<xsl:element name="{name()}">
				<xsl:copy-of select="@*[name()!='already']"/>
				<xsl:apply-templates select="*" mode="externalize"/>
			</xsl:element>
		</xsl:if>
	</xsl:template>
	<xsl:template match="*">
		<xsl:element name="{name()}">
			<xsl:apply-templates select="@*|node()"/>
		</xsl:element>
	</xsl:template>
	<xsl:template match="@*">
		<xsl:copy/>
	</xsl:template>
	<xsl:template match="parameter">
		<xsl:param name="prefixe"/>
		<parameter vName="{@name}" name="{concat($prefixe,'/',@name)}">
			<!--{concat('INDY.',$prefixe,'.',@name)}-->
			<xsl:apply-templates select="@type | @value | @input | @output | @fault"/>
		</parameter>
	</xsl:template>
	<xsl:template match="metaDataLink" mode="metaDataLink">
		<xsl:for-each select="metaData">
			<metaData>
				<xsl:copy-of select="@*"/>
				<xsl:copy-of select="../@input | ../@output | ../@fault"/>
				<xsl:copy-of select="text()"/>
			</metaData>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="proc:process | subProcess">
		<xsl:param name="prefixe"/>
		<xsl:param name="isBeginProcess">false</xsl:param>
		<xsl:variable name="name" select="if ($prefixe!='') then concat($prefixe,'/',@name) else @name"/>
		<process>
			<xsl:attribute name="actionName" select="$name"/>
			<xsl:attribute name="isBeginProcess" select="$isBeginProcess"/>
			<xsl:apply-templates select="subProcess" mode="step">
				<xsl:with-param name="prefixe" select="$name"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="actionCode" mode="step">
				<xsl:with-param name="prefixe" select="$name"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="*/link | */bindLink">
				<xsl:with-param name="prefixe" select="$name"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="metaDataLink">
				<xsl:with-param name="prefixe" select="$name"/>
			</xsl:apply-templates>
		</process>
		<xsl:apply-templates select="subProcess">
			<xsl:with-param name="prefixe" select="$name"/>
			<xsl:with-param name="isBeginProcess" select="'false'"/>
		</xsl:apply-templates>
	</xsl:template>
	<xsl:template match="actionCode | subProcess" mode="step">
		<xsl:param name="prefixe"/>
		<xsl:variable name="name" select="concat($prefixe,'/', @name )"/>
		<step id="{@id}" type="{if (name()='actionCode') then 'Code' else 'Process'}" actionName="{$name}" nbCycles="{if (not(@nbCycles)) then '1' else @nbCycles}" toleratedError="{if (not(@toleratedError)) then 'false' else @toleratedError}" isBeginAction="{if (not(@isBeginAction)) then 'false' else @isBeginAction}" restartPoint="{if (@restartPoint!='') then @restartPoint else 'default'}">
			<xsl:if test="@metaInf!=''">
				<xsl:copy-of select="@metaInf" copy-namespaces="no"/>
			</xsl:if>
			<xsl:if test="@dynamicName!=''">
				<xsl:copy-of select="@dynamicName" copy-namespaces="no"/>
			</xsl:if>
			<xsl:if test="@semaphoreName!=''">
				<xsl:copy-of select="@semaphoreName" copy-namespaces="no"/>
			</xsl:if>
			<xsl:if test="@stopBindOnError!=''">
				<xsl:copy-of select="@stopBindOnError" copy-namespaces="no"/>
			</xsl:if>
			<xsl:if test="@encrypted!=''">
				<xsl:copy-of select="@encrypted" copy-namespaces="no"/>
			</xsl:if>
			<xsl:apply-templates select="@technology|@module"/>
			<xsl:value-of select="resultCode"/>
			<xsl:apply-templates select="altId"/>
			<xsl:apply-templates select="parameter">
				<xsl:with-param name="prefixe" select="$name"/>
			</xsl:apply-templates>
			<xsl:apply-templates select="metaDataLink">
				<xsl:with-param name="prefixe" select="$name"/>
			</xsl:apply-templates>
		</step>
	</xsl:template>
	<xsl:template name="addAttr">
		<xsl:param name="prefixe"/>
		<xsl:param name="name"/>
		<xsl:variable name="newName">
			<xsl:choose>
				<xsl:when test="string-length($name)=0">
					<xsl:value-of select="@name"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$name"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:for-each select="@*">
			<xsl:choose>
				<xsl:when test="name(.)='name'">
					<xsl:attribute name="name" select="concat($prefixe,'/',$newName)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:apply-templates select="."/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>
	<xsl:template match="@targetId | @generationCondition | @generationType | @description"/>
	<xsl:template match="link/@executionCondition | bindLink/@executionCondition">
		<xsl:if test=".!=''">
			<xsl:attribute name="linkCondition" select="."/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="link/@executionType | bindLink/@executionType ">
		<xsl:if test=".!=''">
			<xsl:attribute name="type" select="if (.='OK_KO') then 'ANY' else ."/>
		</xsl:if>
	</xsl:template>
	<xsl:template match="link | bindLink">
		<xsl:param name="prefixe"/>
		<xsl:variable name="sourceName" select="../@name"/>
		<xsl:variable name="current" select="."/>
		<xsl:if test="$sourceName">
			<xsl:for-each select="descendant-or-self::*/@targetId">
				<xsl:variable name="targetName" select="$current/../../*[@id=current()]/@name"/>
				<xsl:if test="$targetName">
					<link type="OK" sourceName="{concat($prefixe,'/', $sourceName)}" targetName="{concat($prefixe,'/', $targetName)}" mandatory="1">
						<xsl:apply-templates select="$current/@*"/>
						<xsl:if test="not($current/@id)">
							<xsl:attribute name="id" select="concat('_',UUID:randomUUID())"/>
						</xsl:if>
					</link>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	<xsl:template match="parameter/connection | metaDataLink | parameter[not(@value)]  | parameter/@id | parameter/@file | parameter[@value='']" mode="final"/>
	<xsl:template match="*" mode="final">
		<xsl:element name="{name()}">
			<xsl:apply-templates mode="final" select="@*|node()"/>
			<xsl:call-template name="parseParameter"/>
		</xsl:element>
	</xsl:template>
	<xsl:template mode="final" match="@*">
		<xsl:call-template name="parseParameter"/>
		<xsl:copy/>
	</xsl:template>
	<xsl:template name="parseParameter">
		<xsl:if test="$externalize='true' and .!=''">
			<xsl:analyze-string select="." regex="{$regex}">
				<xsl:matching-substring>
					<xsl:variable select="regex-group(2)" name="index"/>
					<xsl:if test="$index!=''">
						<xsl:value-of select="mdv:putMapValue('foundVar',$index,'true')"/>
					</xsl:if>
				</xsl:matching-substring>
			</xsl:analyze-string>
		</xsl:if>
	</xsl:template>
	<xsl:template match="*" mode="parseParameter">
		<xsl:element name="{name()}">
			<xsl:apply-templates mode="parseParameter" select="@*|node()"/>
			<xsl:call-template name="parseParameter"/>
		</xsl:element>
	</xsl:template>
	<xsl:template mode="parseParameter" match="@*">
		<xsl:call-template name="parseParameter"/>
		<xsl:copy/>
	</xsl:template>
</xsl:stylesheet>
