--
-- You have to replace XDI_RUNTIME_SCHEDULER occurrences with the
-- org.quartz.scheduler.instanceName parameter value contained into
-- engineScheduler.properties file.
--

--
-- drop tables that are no longer used
--
drop table stb_job_listeners;
drop table stb_trigger_listeners;
--
-- drop columns that are no longer used
--
alter table stb_job_details drop column is_volatile;
alter table stb_triggers drop column is_volatile;
alter table stb_fired_triggers drop column is_volatile;

--
-- add new columns that replace the 'is_stateful' column
--
alter table stb_job_details add column is_nonconcurrent bool;
alter table stb_job_details add column is_update_data bool;
update stb_job_details set is_nonconcurrent = is_stateful;
update stb_job_details set is_update_data = is_stateful;
alter table stb_job_details drop column is_stateful;
alter table stb_fired_triggers add column is_nonconcurrent bool;
update stb_fired_triggers set is_nonconcurrent = is_stateful;
alter table stb_fired_triggers drop column is_stateful;

--
-- add new 'sched_name' column to all tables --- replace "XDI_RUNTIME_SCHEDULER" with your scheduler's configured name
--
alter table stb_blob_triggers add column sched_name varchar(120) not null DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table stb_calendars add column sched_name varchar(120) not null DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table stb_cron_triggers add column sched_name varchar(120) not null DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table stb_fired_triggers add column sched_name varchar(120) not null DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table stb_job_details add column sched_name varchar(120) not null DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table stb_locks add column sched_name varchar(120) not null DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table stb_paused_trigger_grps add column sched_name varchar(120) not null DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table stb_scheduler_state add column sched_name varchar(120) not null DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table stb_simple_triggers add column sched_name varchar(120) not null DEFAULT 'XDI_RUNTIME_SCHEDULER';
alter table stb_triggers add column sched_name varchar(120) not null DEFAULT 'XDI_RUNTIME_SCHEDULER';

--
-- add new 'sched_time' column to stb_fired_triggers
--
alter table stb_fired_triggers add column sched_time BIGINT NULL;
update stb_fired_triggers set sched_time = fired_time;
alter table stb_fired_triggers ALTER COLUMN  sched_time SET  NOT NULL;

--
-- drop all primary and foreign key constraints, so that we can define new ones
--
alter table stb_triggers drop constraint stb_triggers_job_name_fkey;
alter table stb_blob_triggers drop constraint stb_blob_triggers_pkey;
alter table stb_blob_triggers drop constraint stb_blob_triggers_trigger_name_fkey;
alter table stb_simple_triggers drop constraint stb_simple_triggers_pkey;
alter table stb_simple_triggers drop constraint stb_simple_triggers_trigger_name_fkey;
alter table stb_cron_triggers drop constraint stb_cron_triggers_pkey;
alter table stb_cron_triggers drop constraint stb_cron_triggers_trigger_name_fkey;
alter table stb_job_details drop constraint stb_job_details_pkey;
alter table stb_job_details add primary key (sched_name, job_name, job_group);
alter table stb_triggers drop constraint stb_triggers_pkey;

--
-- add all primary and foreign key constraints, based on new columns
--
alter table stb_triggers add primary key (sched_name, trigger_name, trigger_group);
alter table stb_triggers add foreign key (sched_name, job_name, job_group) references stb_job_details(sched_name, job_name, job_group);
alter table stb_blob_triggers add primary key (sched_name, trigger_name, trigger_group);
alter table stb_blob_triggers add foreign key (sched_name, trigger_name, trigger_group) references stb_triggers(sched_name, trigger_name, trigger_group);
alter table stb_cron_triggers add primary key (sched_name, trigger_name, trigger_group);
alter table stb_cron_triggers add foreign key (sched_name, trigger_name, trigger_group) references stb_triggers(sched_name, trigger_name, trigger_group);
alter table stb_simple_triggers add primary key (sched_name, trigger_name, trigger_group);
alter table stb_simple_triggers add foreign key (sched_name, trigger_name, trigger_group) references stb_triggers(sched_name, trigger_name, trigger_group);
alter table stb_fired_triggers drop constraint stb_fired_triggers_pkey;
alter table stb_fired_triggers add primary key (sched_name, entry_id);
alter table stb_calendars drop constraint stb_calendars_pkey;
alter table stb_calendars add primary key (sched_name, calendar_name);
alter table stb_locks drop constraint stb_locks_pkey;
alter table stb_locks add primary key (sched_name, lock_name);
alter table stb_paused_trigger_grps drop constraint stb_paused_trigger_grps_pkey;
alter table stb_paused_trigger_grps add primary key (sched_name, trigger_group);
alter table stb_scheduler_state drop constraint stb_scheduler_state_pkey;
alter table stb_scheduler_state add primary key (sched_name, instance_name);

--
-- add new simprop_triggers table
--
CREATE TABLE stb_simprop_triggers
 (
    SCHED_NAME VARCHAR(120) NOT NULL,
    TRIGGER_NAME VARCHAR(200) NOT NULL,
    TRIGGER_GROUP VARCHAR(200) NOT NULL,
    STR_PROP_1 VARCHAR(512) NULL,
    STR_PROP_2 VARCHAR(512) NULL,
    STR_PROP_3 VARCHAR(512) NULL,
    INT_PROP_1 INT NULL,
    INT_PROP_2 INT NULL,
    LONG_PROP_1 BIGINT NULL,
    LONG_PROP_2 BIGINT NULL,
    DEC_PROP_1 NUMERIC(13,4) NULL,
    DEC_PROP_2 NUMERIC(13,4) NULL,
    BOOL_PROP_1 BOOL NULL,
    BOOL_PROP_2 BOOL NULL,
    PRIMARY KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP),
    FOREIGN KEY (SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
    REFERENCES stb_TRIGGERS(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
);

--
-- create indexes for faster queries
--
CREATE INDEX IDX_STB_J_REQ_RECOVERY
  ON STB_JOB_DETAILS (SCHED_NAME, REQUESTS_RECOVERY);
CREATE INDEX IDX_STB_J_GRP
  ON STB_JOB_DETAILS (SCHED_NAME, JOB_GROUP);

CREATE INDEX IDX_STB_T_J
  ON STB_TRIGGERS (SCHED_NAME, JOB_NAME, JOB_GROUP);
CREATE INDEX IDX_STB_T_JG
  ON STB_TRIGGERS (SCHED_NAME, JOB_GROUP);
CREATE INDEX IDX_STB_T_C
  ON STB_TRIGGERS (SCHED_NAME, CALENDAR_NAME);
CREATE INDEX IDX_STB_T_G
  ON STB_TRIGGERS (SCHED_NAME, TRIGGER_GROUP);
CREATE INDEX IDX_STB_T_STATE
  ON STB_TRIGGERS (SCHED_NAME, TRIGGER_STATE);
CREATE INDEX IDX_STB_T_N_STATE
  ON STB_TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP, TRIGGER_STATE);
CREATE INDEX IDX_STB_T_N_G_STATE
  ON STB_TRIGGERS (SCHED_NAME, TRIGGER_GROUP, TRIGGER_STATE);
CREATE INDEX IDX_STB_T_NEXT_FIRE_TIME
  ON STB_TRIGGERS (SCHED_NAME, NEXT_FIRE_TIME);
CREATE INDEX IDX_STB_T_NFT_ST
  ON STB_TRIGGERS (SCHED_NAME, TRIGGER_STATE, NEXT_FIRE_TIME);
CREATE INDEX IDX_STB_T_NFT_MISFIRE
  ON STB_TRIGGERS (SCHED_NAME, MISFIRE_INSTR, NEXT_FIRE_TIME);
CREATE INDEX IDX_STB_T_NFT_ST_MISFIRE
  ON STB_TRIGGERS (SCHED_NAME, MISFIRE_INSTR, NEXT_FIRE_TIME, TRIGGER_STATE);
CREATE INDEX IDX_STB_T_NFT_ST_MISFIRE_GRP
  ON STB_TRIGGERS (SCHED_NAME, MISFIRE_INSTR, NEXT_FIRE_TIME, TRIGGER_GROUP, TRIGGER_STATE);

CREATE INDEX IDX_STB_FT_TRIG_INST_NAME
  ON STB_FIRED_TRIGGERS (SCHED_NAME, INSTANCE_NAME);
CREATE INDEX IDX_STB_FT_INST_JOB_REQ_RCVRY
  ON STB_FIRED_TRIGGERS (SCHED_NAME, INSTANCE_NAME, REQUESTS_RECOVERY);
CREATE INDEX IDX_STB_FT_J_G
  ON STB_FIRED_TRIGGERS (SCHED_NAME, JOB_NAME, JOB_GROUP);
CREATE INDEX IDX_STB_FT_JG
  ON STB_FIRED_TRIGGERS (SCHED_NAME, JOB_GROUP);
CREATE INDEX IDX_STB_FT_T_G
  ON STB_FIRED_TRIGGERS (SCHED_NAME, TRIGGER_NAME, TRIGGER_GROUP);
CREATE INDEX IDX_STB_FT_TG
  ON STB_FIRED_TRIGGERS (SCHED_NAME, TRIGGER_GROUP);


commit;