#!/bin/bash
#
# Copyright (c) Semarchy.  All rights reserved.
#
# PRODUCT Semarchy xDI Runtime
#   
#	This script allows to stop a Runtime.
#
#	Note:
#	To have an overview of the possible parameters, use the -usage parameter
#	
#	Examples:
#	stopengine.sh -usage
#	stopengine.sh -port 42200
#

# resolve links - $0 may be a softlink
PRG="$0"

while [ -h "$PRG" ]; do
  ls=`ls -ld "$PRG"`
  link=`expr "$ls" : '.*-> \(.*\)$'`
  if expr "$link" : '/.*' > /dev/null; then
    PRG="$link"
  else
    PRG=`dirname "$PRG"`/"$link"
  fi
done

PRGDIR=`dirname "$PRG"`

. "$PRGDIR"/initvariables.sh

"$RUNJAVA" $ADD_OPEN_OPTIONS $XDI_RUNTIME_OPTS -classpath "$XDI_RUNTIME_CLASSPATH" "${XDI_RUNTIME_VM_PROPERTIES[@]}" com.indy.engine.launcher.MainLauncher -mainclass com.indy.engine.command.EngineStopI -conf "$XDI_RUNTIME_CONF_FILE_LOCATION" "$@"      