<?xml version="1.0" encoding="utf-8"?>
<!-- XSLT to convert expression's expression and join/filter's expression attribute into element-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml" indent="yes"/>

  <!-- copy all content other than the query attribute -->
   <xsl:template match="node()|@*">
        <xsl:copy>
            <xsl:apply-templates select="node()|@*[not(name()='expression')]"/>
        </xsl:copy>
   </xsl:template>

   <!-- match uuid so that we can insert query after -->
   <xsl:template match="expression|join|filter">
      <xsl:copy>
         <!--  <xsl:apply-templates select="@*[not(name()='expression')]|node()"/> -->
          <xsl:copy-of select="@*[not(name()='expression')]|node()"/>
          <xsl:element name="expression">
         <!-- navigate up one level to reach the query attribute -->
         <xsl:value-of select="@expression"/>
       </xsl:element>     
       </xsl:copy>
       <!-- add our query element -->
       
   </xsl:template>
</xsl:stylesheet>
