#!/bin/bash
#
# Copyright (c) Semarchy.  All rights reserved.
#
# PRODUCT Semarchy xDI Runtime
#   
#	This script initializes some of the variables that will be used in the startup scripts of the Runtime.
#	It will be executed at the beginning of the following scripts:
#		-	startcommand.sh
#		-	startdelivery.sh
#		-	startengine.sh / stopengine.sh
#

# resolve links - $0 may be a softlink
PRG="$0"

while [ -h "$PRG" ]; do
  ls=`ls -ld "$PRG"`
  link=`expr "$ls" : '.*-> \(.*\)$'`
  if expr "$link" : '/.*' > /dev/null; then
    PRG="$link"
  else
    PRG=`dirname "$PRG"`/"$link"
  fi
done

XDI_RUNTIME_HOME=`dirname "$PRG"`

# Folder containing the Runtime configuration file (defaults the 'properties' folder that is inside the Runtime directory)
if [ -z "$XDI_RUNTIME_PROPERTIES_LOCATION" ]; then 
	XDI_RUNTIME_PROPERTIES_LOCATION="$XDI_RUNTIME_HOME"/properties
fi

# Path to the Runtime Configuration file (engineParameters.xml)
XDI_RUNTIME_CONF_FILE_LOCATION="$XDI_RUNTIME_PROPERTIES_LOCATION"/engineParameters.xml

XDI_RUNTIME_LIB_HOME="$XDI_RUNTIME_HOME"/lib
XDI_RUNTIME_CLASSPATH="$XDI_RUNTIME_HOME":"$XDI_RUNTIME_PROPERTIES_LOCATION"

XDI_RUNTIME_BUILD_HOME="$XDI_RUNTIME_HOME"/build/lib
XDI_RUNTIME_BUILD_CLASSPATH="$XDI_RUNTIME_CLASSPATH":"$XDI_RUNTIME_LIB_HOME"/internal/commons-lang3-3.18.0.jar:"$XDI_RUNTIME_LIB_HOME"/internal/commons-io-2.17.0.jar:"$XDI_RUNTIME_LIB_HOME"/internal/commons-codec-1.18.0.jar:"$XDI_RUNTIME_LIB_HOME"/internal/commons-compress-1.27.1.jar:"$XDI_RUNTIME_BUILD_HOME"/ant-1.10.15.jar:"$XDI_RUNTIME_BUILD_HOME"/ant-launcher-1.10.15.jar:"$XDI_RUNTIME_BUILD_HOME"/saxon9b-9.1.0.8-extended.jar:"$XDI_RUNTIME_BUILD_HOME"/saxon-s9api-9.1.0.8b.jar:"$XDI_RUNTIME_BUILD_HOME"/ant-contrib-1.0b3.jar:"$XDI_RUNTIME_BUILD_HOME"/saxon-xpath-9.1.0.8.jar:"$XDI_RUNTIME_BUILD_HOME"/stax2-api-4.2.2.jar:"$XDI_RUNTIME_BUILD_HOME"/woodstox-core-7.0.0.jar:"$XDI_RUNTIME_BUILD_HOME"/saxon-jdom-9.1.0.8b.jar:"$XDI_RUNTIME_BUILD_HOME"/jsqlparser-4.5.jar:"$XDI_RUNTIME_BUILD_HOME"/com.semarchy.xdi.designer.generation.jar:"$XDI_RUNTIME_BUILD_HOME"/com.indy.libraries.build.jar:"$XDI_RUNTIME_LIB_HOME"/core/indyEngineCore.jar:"$XDI_RUNTIME_LIB_HOME"/core/indyEngineShared.jar:"$XDI_RUNTIME_LIB_HOME"/internal/indyEngineCommon.jar:"$XDI_RUNTIME_LIB_HOME"/internal/indyEngine.jar:"$XDI_RUNTIME_LIB_HOME"/indyEngineCoreModule.jar:"$XDI_RUNTIME_LIB_HOME"/core/jakarta.xml.bind-api-4.0.2.jar:"$XDI_RUNTIME_LIB_HOME"/internal/guava-33.3.1-jre.jar:"$XDI_RUNTIME_LIB_HOME"/internal/failureaccess-1.0.2.jar:"$XDI_RUNTIME_LIB_HOME"/internal/HikariCP-6.3.0.jar:"$XDI_RUNTIME_LIB_HOME"/core/log4j-api-2.24.3.jar:"$XDI_RUNTIME_LIB_HOME"/core/log4j-core-2.24.3.jar:"$XDI_RUNTIME_LIB_HOME"/core/log4j-jul-2.24.3.jar:"$XDI_RUNTIME_BUILD_HOME"/org.eclipse.osgi.jar:"$XDI_RUNTIME_BUILD_HOME"/org.eclipse.emf.common.jar:"$XDI_RUNTIME_BUILD_HOME"/org.eclipse.emf.ecore.jar:"$XDI_RUNTIME_BUILD_HOME"/org.eclipse.emf.ecore.xmi.jar:"$XDI_RUNTIME_BUILD_HOME"/com.semarchy.xdi.designer.core.jar

XDI_RUNTIME_CLASSPATH="$XDI_RUNTIME_CLASSPATH":"$XDI_RUNTIME_LIB_HOME"/indyEngineLauncher.jar:"$XDI_RUNTIME_LIB_HOME"/indyEngineCoreModule.jar
XDI_RUNTIME_CORE="$XDI_RUNTIME_LIB_HOME"/core/**/*.jar
XDI_RUNTIME_INTERNAL="$XDI_RUNTIME_LIB_HOME"/internal/*.jar
XDI_RUNTIME_MODULES_PATH="$XDI_RUNTIME_HOME"/modules

# Java Properties to be added in all the Runtime scripts (startengine.sh / stopengine.sh, startdelivery.sh and startcommand.sh)
XDI_RUNTIME_VM_PROPERTIES=(
	"-Dcom.indy.engine.installation.folder=$XDI_RUNTIME_HOME"
	-Djava.util.logging.manager=org.apache.logging.log4j.jul.LogManager
	-Dlog4j1.compatibility=true
	-Dlog4j2.julLoggerAdapter=org.apache.logging.log4j.jul.CoreLoggerAdapter
	"-Dstambia.classpath.v1.internal=$XDI_RUNTIME_INTERNAL"
	"-Dstambia.classpath.v1.core=$XDI_RUNTIME_CORE;$XDI_RUNTIME_MODULES_PATH/core/*.jar"
	"-Dxdi.designer.module.path.v1=$XDI_RUNTIME_MODULES_PATH"
	"-Dorg.quartz.properties=$XDI_RUNTIME_PROPERTIES_LOCATION/engineScheduler.properties"
)

# Add the JAVA 9 specific start-up parameters
ADD_OPEN_OPTIONS=--add-opens=java.base/java.net=ALL-UNNAMED
ADD_OPEN_OPTIONS="$ADD_OPEN_OPTIONS --add-opens=java.base/java.lang=ALL-UNNAMED"
ADD_OPEN_OPTIONS="$ADD_OPEN_OPTIONS --add-opens=java.base/java.io=ALL-UNNAMED"
ADD_OPEN_OPTIONS="$ADD_OPEN_OPTIONS --add-opens=java.base/java.util=ALL-UNNAMED"
ADD_OPEN_OPTIONS="$ADD_OPEN_OPTIONS --add-opens=java.base/java.util.concurrent=ALL-UNNAMED"
ADD_OPEN_OPTIONS="$ADD_OPEN_OPTIONS --add-opens=java.naming/com.sun.jndi.ldap=ALL-UNNAMED"
ADD_OPEN_OPTIONS="$ADD_OPEN_OPTIONS --add-opens=java.naming/javax.naming.directory=ALL-UNNAMED"
ADD_OPEN_OPTIONS="$ADD_OPEN_OPTIONS --add-opens=java.base/java.nio=ALL-UNNAMED"
ADD_OPEN_OPTIONS="$ADD_OPEN_OPTIONS --add-opens=java.base/sun.security.ssl=ALL-UNNAMED"
ADD_OPEN_OPTIONS="$ADD_OPEN_OPTIONS --add-opens=java.base/sun.security.util=ALL-UNNAMED"
ADD_OPEN_OPTIONS="$ADD_OPEN_OPTIONS --add-opens=java.base/sun.net.www.protocol.http=ALL-UNNAMED"
ADD_OPEN_OPTIONS="$ADD_OPEN_OPTIONS --add-opens=java.base/sun.net.www.http=ALL-UNNAMED"

# define which java to run	
if [ -z "$JAVA_HOME" ]; then
	RUNJAVA=java
else
	RUNJAVA="$JAVA_HOME"/bin/java
fi
