#!/bin/bash
#
# Copyright (c) Semarchy.  All rights reserved.
#
# PRODUCT Semarchy xDI Runtime
#   
#	This script allows to execute the specified delivery
#
#	Note:
#	To have an overview of the possible parameters, use the -usage parameter
#	
#	Examples:
#	startdelivery.sh -usage
#	startdelivery.sh -name "mydeliv"
#

# resolve links - $0 may be a softlink
PRG="$0"

while [ -h "$PRG" ]; do
  ls=`ls -ld "$PRG"`
  link=`expr "$ls" : '.*-> \(.*\)$'`
  if expr "$link" : '/.*' > /dev/null; then
    PRG="$link"
  else
    PRG=`dirname "$PRG"`/"$link"
  fi
done

PRGDIR=`dirname "$PRG"`

. "$PRGDIR"/initvariables.sh

"$RUNJAVA" $ADD_OPEN_OPTIONS $XDI_RUNTIME_OPTS -classpath "$XDI_RUNTIME_CLASSPATH" "${XDI_RUNTIME_VM_PROPERTIES[@]}" com.indy.engine.launcher.MainLauncher -mainclass com.indy.engine.StartDelivery -conf "$XDI_RUNTIME_CONF_FILE_LOCATION" "$@"