/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.build;

import com.indy.gmf.map.diagram.build.AbstractBuildVisitor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class DeltaBuildVisitor
extends AbstractBuildVisitor
implements IResourceDeltaVisitor {
    public boolean visit(IResourceDelta delta) throws CoreException {
        if (delta.getResource().getType() == 2) {
            if (delta.getResource().getName().equals("indy.build")) {
                return false;
            }
            if (delta.getResource().getName().equals("indy.diagram")) {
                return false;
            }
        }
        if (delta.getResource().getType() != 1) {
            return true;
        }
        if (this.requestBuild((IFile)delta.getResource())) {
            this.toBuild.add((IFile)delta.getResource());
        } else {
            IFile iFile;
            for (IFile iFile2 : this.getUsages((IFile)delta.getResource())) {
                if (!this.requestBuild(iFile2) || this.toBuild.contains(iFile2)) continue;
                this.toBuild.add(iFile2);
            }
            if (this.isDeletedBuiltFile(delta) && (iFile = this.getMappingFileFromBuiltObject((IFile)delta.getResource())) != null && this.requestBuild(iFile) && !this.toBuild.contains(iFile)) {
                this.toBuild.add(iFile);
            }
        }
        return true;
    }

    private boolean isDeletedBuiltFile(IResourceDelta delta) {
        IResource resource;
        return delta.getKind() == 2 && ((resource = delta.getResource()).getType() == 1 && "md".equals(resource.getFileExtension()) || "proc".equals(resource.getFileExtension())) && "indy.build".equals(resource.getProjectRelativePath().segment(0));
    }

    private IFile getMappingFileFromBuiltObject(IFile resource) {
        if (("md".equals(resource.getFileExtension()) || "proc".equals(resource.getFileExtension())) && "indy.build".equals(resource.getProjectRelativePath().segment(0))) {
            Path p = new Path("");
            int i = 1;
            while (i < resource.getProjectRelativePath().segmentCount() - 1) {
                p = p.append("/" + resource.getProjectRelativePath().segment(i));
                ++i;
            }
            p = p.append(resource.getName().substring(0, resource.getName().lastIndexOf(".")) + ".map");
            IFile mapFile = (IFile)resource.getProject().findMember((IPath)p);
            if (mapFile != null && mapFile.exists()) {
                return mapFile;
            }
        }
        return null;
    }
}

