/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom;

import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.Field;
import com.indy.map.ILogicalField;
import com.indy.map.IMetaData;
import com.indy.map.IReferencable;
import com.indy.map.MapModelItem;
import com.indy.map.Query;
import com.indy.map.QueryField;
import com.indy.map.diagram.part.MapDiagramEditorUtil;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RItem;
import com.indy.map.ref.RProblem;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.gmf.StambiaGMFEditingDomainFactory;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.internal.mapmode.IdentityMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MapDiagramUtil {
    private static Logger logger = LogManager.getLogger(MapDiagramUtil.class);
    private static final String ICON_ERROR_MESSAGE = "Failed to load icon";
    public static Image errorIcon;
    public static Image warningIcon;
    public static Image infoIcon;
    static final Font FONT;
    private static IdentityMapMode mapMode;

    static {
        try {
            errorIcon = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.edit/icons/full/obj32x16/Error32x16.png")).createImage();
        }
        catch (Exception ex) {
            logger.error(ICON_ERROR_MESSAGE, (Throwable)ex);
        }
        try {
            warningIcon = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.edit/icons/full/obj32x16/Warning32x16.png")).createImage();
        }
        catch (Exception ex) {
            logger.error(ICON_ERROR_MESSAGE, (Throwable)ex);
        }
        try {
            infoIcon = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.edit/icons/full/obj32x16/Info32x16.png")).createImage();
        }
        catch (Exception ex) {
            logger.error(ICON_ERROR_MESSAGE, (Throwable)ex);
        }
        FONT = new Font((Device)Display.getCurrent(), "Arial", 9, 0);
        mapMode = new IdentityMapMode();
    }

    private MapDiagramUtil() {
    }

    public static URI getDiagramURI(URI modelURI) {
        String diagramfileName = "." + modelURI.lastSegment().replaceAll(modelURI.fileExtension(), modelURI.fileExtension() + "_diagram");
        return modelURI.trimSegments(1).appendSegment(diagramfileName);
    }

    public static void createAndOpenDiagram(final URI modelURI, Shell shell) {
        final URI domainModelURI = modelURI;
        try {
            final Shell shell2 = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            new ProgressMonitorDialog(shell).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    TransactionalEditingDomain editingDomain = StambiaGMFEditingDomainFactory.instanceGMF.createEditingDomain();
                    ResourceSet resourceSet = editingDomain.getResourceSet();
                    resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
                    EObject diagramRoot = null;
                    try {
                        try {
                            Resource resource = resourceSet.getResource(domainModelURI, true);
                            diagramRoot = (EObject)resource.getContents().get(0);
                            IFile diagramFile = MapDiagramUtil.createDiagramFile(diagramRoot);
                            MapDiagramEditorUtil.setCharset(diagramFile);
                            URI diagramModelURI = Util.convertIPathToEMFURI2((IPath)diagramFile.getFullPath());
                            URI diagramResourceURI = MapDiagramEditorUtil.createDiagram(diagramModelURI, domainModelURI, monitor, shell2).getURI();
                            MapDiagramEditorUtil.openDiagram(diagramResourceURI);
                        }
                        catch (Exception ex) {
                            logger.error("Failed to create diagram {}", (Object)modelURI, (Object)ex);
                            editingDomain.dispose();
                        }
                    }
                    finally {
                        editingDomain.dispose();
                    }
                }
            });
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            logger.error("Failed to open diagram", (Throwable)e);
        }
    }

    private static IFile createDiagramFile(EObject eo) {
        String str = URIUtils.getProcDiagramURI((URI)eo.eResource().getURI()).toPlatformString(true);
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(str));
    }

    public static Image getProblemTypeIcon(RProblem p) {
        if (p.getProblemType() == RProblem.Type.ERROR) {
            return errorIcon;
        }
        if (p.getProblemType() == RProblem.Type.WARNING) {
            return warningIcon;
        }
        if (p.getProblemType() == RProblem.Type.INFO) {
            return infoIcon;
        }
        return null;
    }

    private static WrappingLabel wrappLabel(String message, Image img) {
        WrappingLabel l = new WrappingLabel(message, img);
        l.setFont(FONT);
        l.setTextWrap(true);
        l.setIconAlignment(8);
        return l;
    }

    public static IFigure updateExpressionToolTip(MapModelItem expression) {
        ArrayList<WrappingLabel> tooltipFigures = new ArrayList<WrappingLabel>();
        if (expression != null && expression instanceof IReferencable) {
            Field field;
            EObject eObject;
            IReferencable ref = (IReferencable)expression;
            RItem it = (RItem)ref.getMapReference();
            if (it != null) {
                it.getProblem().stream().filter(p -> p.getProblemType().ordinal() > RProblem.Type.NONE.ordinal()).map(p -> MapDiagramUtil.wrappLabel(p.getErrorMessage(), MapDiagramUtil.getProblemTypeIcon(p))).forEach(tooltipFigures::add);
            }
            if (expression instanceof ILogicalField) {
                ILogicalField iLogicalField = (ILogicalField)expression;
                iLogicalField.getExpression().stream().map(e -> (RExpression)e.getMapReference()).filter(e -> e != null).flatMap(e -> e.getProblem().stream()).filter(p -> p.getProblemType().ordinal() > RProblem.Type.NONE.ordinal()).map(p -> MapDiagramUtil.wrappLabel(p.getErrorMessage(), MapDiagramUtil.getProblemTypeIcon(p))).forEach(tooltipFigures::add);
            }
            if (it != null && expression instanceof IMetaData && !(expression instanceof Query) && it.getProblem(RProblem.ERROR_PROXY_FIELDS) == null && !(expression instanceof QueryField) && (((IMetaData)expression).getRef() == null || ((IMetaData)expression).getRef().eIsProxy())) {
                WrappingLabel l = new WrappingLabel(Messages.MapDiagramUtil_13, errorIcon);
                l.setFont(FONT);
                tooltipFigures.add(l);
            }
            if (expression instanceof Field && (eObject = (field = (Field)expression).getRef()) instanceof MdNode) {
                MdNode node = (MdNode)eObject;
                if (!field.getName().equals(node.getName()) && node.getName() != null) {
                    WrappingLabel l = new WrappingLabel(Messages.MapDiagramUtil_14, warningIcon);
                    l.setFont(FONT);
                    tooltipFigures.add(l);
                } else if (!field.getName().equals(node.getName()) && !node.getAttribute().isEmpty()) {
                    String value = ((Attribute)node.getAttribute().get(0)).getValue();
                    if (!((Field)expression).getName().equals(value)) {
                        WrappingLabel l = new WrappingLabel(Messages.MapDiagramUtil_14, warningIcon);
                        l.setFont(FONT);
                        tooltipFigures.add(l);
                    }
                }
            }
        }
        if (tooltipFigures.isEmpty()) {
            return null;
        }
        TooltipFigure2 f = new TooltipFigure2();
        ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout(false);
        layout.setStretchMajorAxis(false);
        layout.setStretchMinorAxis(false);
        f.setLayoutManager((LayoutManager)layout);
        for (IFigure iFigure : tooltipFigures) {
            f.add(iFigure);
        }
        return f;
    }

    public static class TooltipFigure2
    extends Figure
    implements IMapMode {
        public int LPtoDP(int logicalUnit) {
            return mapMode.LPtoDP(logicalUnit);
        }

        public int DPtoLP(int deviceUnit) {
            return mapMode.DPtoLP(deviceUnit);
        }

        public Translatable LPtoDP(Translatable t) {
            return mapMode.LPtoDP(t);
        }

        public Translatable DPtoLP(Translatable t) {
            return mapMode.DPtoLP(t);
        }
    }
}

