/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom;

import com.indy.gmf.map.diagram.custom.preferences.MapPreferenceConstants;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.DocumentRoot;
import com.indy.map.Map;
import com.indy.map.MapFactory;
import com.indy.map.diagram.part.MapCreationWizardPage;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.EMFResourceUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class MapQuickCreationWizard
extends Wizard
implements INewWizard {
    static final String EXTENSION = "map";
    private Logger logger = LogManager.getLogger(MapQuickCreationWizard.class);
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected MapCreationWizardPage domainModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.MapQuickCreationWizard_1);
        this.setDefaultPageImageDescriptor(MapDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/MappingWizard.png"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.domainModelFilePage = new MapCreationWizardPage("DomainModelFile", this.getSelection(), null){

            @Override
            public void createControl(Composite parent) {
                this.setFileName("default.map");
                super.createControl(parent);
                this.setFileName(this.getFileName().substring(0, this.getFileName().lastIndexOf(".map")));
            }

            @Override
            protected boolean validatePage() {
                boolean retour = true;
                this.setFileExtension(MapQuickCreationWizard.EXTENSION);
                retour = super.validatePage();
                this.setFileExtension(null);
                return retour;
            }
        };
        this.domainModelFilePage.setTitle(Messages.MapQuickCreationWizard_2);
        this.domainModelFilePage.setDescription(Messages.MapQuickCreationWizard_3);
        this.addPage((IWizardPage)this.domainModelFilePage);
    }

    public boolean performFinish() {
        block7: {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

                protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                    MapQuickCreationWizard.this.domainModelFilePage.setFileExtension(MapQuickCreationWizard.EXTENSION);
                    ResourceSetImpl resSet = new ResourceSetImpl();
                    resSet.setURIConverter((URIConverter)new InternalResourceURIConverter());
                    Resource modelResource = resSet.createResource(MapQuickCreationWizard.this.domainModelFilePage.getURI());
                    ((XMLResource)modelResource).getDefaultSaveOptions().put("ENCODING", "UTF-8");
                    DocumentRoot docRoot = MapFactory.eINSTANCE.createDocumentRoot();
                    Map model = MapFactory.eINSTANCE.createMap();
                    docRoot.setMap(model);
                    if (model.getTech() == null) {
                        EObject tech = null;
                        URI uri = null;
                        try {
                            uri = ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).getResourceURIByFileId(MapPreferenceConstants.getString("techMapId"));
                            Resource techResource = resSet.getResource(uri, true);
                            tech = EMFResourceUtil.getRootElement((Resource)techResource);
                        }
                        catch (Exception ex) {
                            MapQuickCreationWizard.this.logger.error(Messages.MapQuickCreationWizard_6, (Object)uri, (Object)ex);
                        }
                        model.setTech(tech);
                    }
                    try {
                        modelResource.getContents().add((Object)docRoot);
                        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                        options.put("com.indy.gmf.map.SAVE_OPTION_NO_REF_SAVE", Boolean.TRUE);
                        options.put("com.indy.gmf.proc.util.ProcResourceImpl.saveOption.noCrossRefModel", Boolean.TRUE);
                        modelResource.save(options);
                    }
                    catch (IOException e) {
                        ErrorDialog.openError((Shell)MapQuickCreationWizard.this.getContainer().getShell(), (String)"", null, (IStatus)new Status(4, "com.indy.gmf.map.diagram", "Failed to save " + String.valueOf(modelResource.getURI()), (Throwable)e));
                    }
                    WorkspaceSynchronizer.getFile((Resource)modelResource).setCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
                    modelResource.unload();
                }
            };
            try {
                this.getContainer().run(false, true, (IRunnableWithProgress)op);
                if (!this.isOpenNewlyCreatedDiagramEditor()) break block7;
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new URIEditorInput(this.domainModelFilePage.getURI()), "com.indy.map.diagram.part.MapDiagramEditorID");
                }
                catch (PartInitException e) {
                    ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)"", null, (IStatus)e.getStatus());
                    return false;
                }
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof CoreException) {
                    ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)"", null, (IStatus)((CoreException)e.getTargetException()).getStatus());
                } else {
                    this.logger.error("Error creating diagram", e.getTargetException());
                }
                return false;
            }
        }
        return true;
    }
}

