/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom;

import com.indy.gmf.map.diagram.custom.Messages;
import com.indy.map.DocumentRoot;
import com.indy.map.Map;
import com.indy.map.diagram.part.MapDiagramEditorUtil;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.emf.StambiaURIHelper;
import com.semarchy.xdi.designer.core.models.EMFResourceOptions;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class MapQuickInitDiagramFileAction
implements IObjectActionDelegate {
    private final Logger logger = LogManager.getLogger(MapQuickInitDiagramFileAction.class);
    ISelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return;
        }
        this.selection = selection;
        action.setEnabled(true);
    }

    public void run(IAction action) {
        WorkspaceJob j = new WorkspaceJob(Messages.MapQuickInitDiagramFileAction_0){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
                try {
                    ResourceSet rs = editingDomain.getResourceSet();
                    ((ResourceSetImpl)rs).setURIResourceMap(new WeakHashMap());
                    rs.setURIConverter((URIConverter)new InternalResourceURIConverter(false));
                    rs.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_BATCH_VALIDATION, Boolean.TRUE);
                    rs.getLoadOptions().put("com.indy.gmf.map.LOAD_OPTION_NO_MAP_REF_SYNC", Boolean.TRUE);
                    rs.getLoadOptions().put("com.indy.gmf.map.LOAD_OPTION_NO_MAP_UPDATE", Boolean.TRUE);
                    rs.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
                    rs.getLoadOptions().put("PROCESS_DANGLING_HREF", "RECORD");
                    for (IFile file : (IStructuredSelection)MapQuickInitDiagramFileAction.this.selection) {
                        if (!"map".equals(file.getFileExtension())) continue;
                        URI domainModelURI = Util.convertIPathToEMFURI2((IPath)file.getFullPath());
                        try {
                            StambiaURIHelper h = new StambiaURIHelper(domainModelURI, null);
                            URI diagramResourceURI = h.getDiagramResourceUri();
                            IFile diagramFile = Util.convertEMFURIToFile((URI)diagramResourceURI);
                            if (diagramFile != null) {
                                diagramFile.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
                                if (diagramFile.exists()) {
                                    diagramFile.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
                                }
                            }
                            Resource mapResource = rs.getResource(domainModelURI, true);
                            Map map = ((DocumentRoot)mapResource.getContents().get(0)).getMap();
                            map.eSetDeliver(false);
                            map.setDiagram(null);
                            map.eSetDeliver(true);
                            HashMap<String, Object> saveOptions = new HashMap<String, Object>();
                            saveOptions.put("ENCODING", "UTF-8");
                            saveOptions.put("com.indy.gmf.map.SAVE_OPTION_NO_REF_SAVE", Boolean.TRUE);
                            saveOptions.put("com.indy.gmf.proc.util.ProcResourceImpl.saveOption.noCrossRefModel", Boolean.TRUE);
                            try {
                                mapResource.save(saveOptions);
                            }
                            finally {
                                if (mapResource != null) {
                                    mapResource.unload();
                                    rs.getResources().remove((Object)mapResource);
                                }
                            }
                            MapDiagramEditorUtil.openDiagram(domainModelURI);
                        }
                        catch (Exception e) {
                            MapQuickInitDiagramFileAction.this.logger.warn("Error while opening diagram", (Throwable)e);
                        }
                    }
                }
                finally {
                    editingDomain.dispose();
                }
                return Status.OK_STATUS;
            }
        };
        j.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        j.schedule();
    }
}

