/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.actions;

import com.indy.gmf.map.diagram.custom.actions.AbstractSortFilterAction;
import com.indy.map.Datastore;
import com.indy.map.IContainer;
import com.indy.map.ref.RDatastore;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;

public class FilterAction
extends AbstractSortFilterAction {
    private static final String FILTER_MODE = "filterMode";
    public static final String DISABLE_FILTER_MODE = "com.indy.gmf.map.diagram.filter.disable";
    public static final String MAPPED_FILTER_MODE = "com.indy.gmf.map.diagram.filter.mapped";
    public static final String UNMAPPED_FILTER_MODE = "com.indy.gmf.map.diagram.filter.unmapped";
    public static final String USED_FILTER_MODE = "com.indy.gmf.map.diagram.filter.used";
    public static final String UNUSED_FILTER_MODE = "com.indy.gmf.map.diagram.filter.unused";

    @Override
    public void run(IAction action) {
        if (action.isChecked()) {
            this.putDetail(FILTER_MODE, action.getId());
        }
        for (Object obj : this.editPart.getChildren()) {
            if (!(obj instanceof ListCompartmentEditPart)) continue;
            for (Object obj2 : ((ListCompartmentEditPart)obj).getChildren()) {
                ((GraphicalEditPart)obj2).refresh();
            }
        }
    }

    public static String getFilterMode(GraphicalEditPart gep) {
        EAnnotation annotation = FilterAction.getSortAnnotation(gep);
        if (annotation != null) {
            String str = (String)annotation.getDetails().get((Object)FILTER_MODE);
            if (str == null) {
                return DISABLE_FILTER_MODE;
            }
            return str;
        }
        return DISABLE_FILTER_MODE;
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (this.ed != null) {
            String mode = FilterAction.getFilterMode(this.editPart);
            if (action.getId().equals(mode)) {
                action.setChecked(true);
            } else {
                action.setChecked(false);
            }
            boolean enabled = true;
            try {
                IContainer c = (IContainer)this.editPart.resolveSemanticElement();
                if (c instanceof Datastore && ((RDatastore)((Datastore)c).getMapReference()).isHierarchical()) {
                    enabled = false;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            action.setEnabled(enabled);
        }
    }
}

