/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.actions;

import com.indy.gmf.map.diagram.custom.actions.AbstractSortFilterAction;
import com.indy.map.Datastore;
import com.indy.map.IContainer;
import com.indy.map.ref.RDatastore;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;

public class SortAction
extends AbstractSortFilterAction {
    public static final String SORT_BY_NAME_ID = "com.indy.gmf.map.diagram.sort.name";
    public static final String SORT_BY_POSITION_ID = "com.indy.gmf.map.diagram.sort.position";
    static final String SORT_MODE = "sortMode";

    @Override
    public void run(IAction action) {
        if (action.isChecked()) {
            this.putDetail(SORT_MODE, action.getId());
            this.refresh();
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (this.ed != null && this.editPart != null) {
            IContainer container = (IContainer)this.editPart.resolveSemanticElement();
            if (container instanceof Datastore && ((RDatastore)((Datastore)container).getMapReference()).isHierarchical()) {
                action.setEnabled(false);
            } else {
                action.setEnabled(true);
                if (action.getId().equals(SortAction.getSortMode(this.editPart))) {
                    action.setChecked(true);
                } else {
                    action.setChecked(false);
                }
            }
        }
    }

    public static String getSortMode(GraphicalEditPart gep) {
        EAnnotation annotation = SortAction.getSortAnnotation(gep);
        if (annotation != null) {
            String str = (String)annotation.getDetails().get((Object)SORT_MODE);
            if (str == null) {
                return SORT_BY_POSITION_ID;
            }
            return str;
        }
        return SORT_BY_POSITION_ID;
    }
}

