/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.edit.parts.ClauseEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.ContainerEditPart;
import com.indy.map.Map;
import com.indy.map.diagram.edit.parts.FilterEditPart;
import com.indy.map.diagram.edit.parts.JoinEditPart;
import com.indy.map.diagram.edit.parts.OperatorEditPart;
import com.indy.map.ref.RMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.zoom.ZoomListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;

public abstract class AbstractPolygonDecorationEditPolicy
extends GraphicalEditPolicy
implements ZoomListener {
    private List<IFigure> polygons = new ArrayList<IFigure>();
    private Adapter semanticListener;
    private Adapter refModelAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.getEventType() == 9000) {
                AbstractPolygonDecorationEditPolicy.this.refresh();
            }
        }
    };
    private EditPartListener editPartListener = new EditPartListener.Stub(){

        public void childAdded(EditPart child, int index) {
            if (child instanceof ContainerEditPart || child instanceof JoinEditPart || child instanceof FilterEditPart || child instanceof OperatorEditPart) {
                ((IGraphicalEditPart)child).getFigure().addFigureListener(AbstractPolygonDecorationEditPolicy.this.childMoveListener);
                AbstractPolygonDecorationEditPolicy.this.registerSemanticAdapter(((IGraphicalEditPart)child).resolveSemanticElement());
                if (AbstractPolygonDecorationEditPolicy.this.semanticListener != null) {
                    ((IGraphicalEditPart)child).resolveSemanticElement().eAdapters().add((Object)AbstractPolygonDecorationEditPolicy.this.semanticListener);
                }
            } else if (child instanceof JoinEditPart) {
                AbstractPolygonDecorationEditPolicy.this.refresh();
            }
        }

        public void removingChild(EditPart child, int index) {
            if (child instanceof ContainerEditPart || child instanceof JoinEditPart || child instanceof FilterEditPart || child instanceof OperatorEditPart) {
                ((IGraphicalEditPart)child).getFigure().removeFigureListener(AbstractPolygonDecorationEditPolicy.this.childMoveListener);
                AbstractPolygonDecorationEditPolicy.this.unregisterSemanticAdapter(((IGraphicalEditPart)child).resolveSemanticElement());
            } else if (child instanceof JoinEditPart) {
                AbstractPolygonDecorationEditPolicy.this.refresh();
            }
        }
    };
    private FigureListener childMoveListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            AbstractPolygonDecorationEditPolicy.this.refresh();
        }
    };

    protected abstract Adapter createSemanticAdapter();

    public AbstractPolygonDecorationEditPolicy() {
        this.semanticListener = this.createSemanticAdapter();
    }

    protected void registerSemanticAdapter(EObject obj) {
        if (obj != null && this.semanticListener != null) {
            obj.eAdapters().add((Object)this.semanticListener);
        }
    }

    protected void unregisterSemanticAdapter(EObject obj) {
        if (obj != null && this.semanticListener != null) {
            obj.eAdapters().remove((Object)this.semanticListener);
        }
    }

    private static long cross(Point o, Point a, Point b) {
        return (a.x - o.x) * (b.y - o.y) - (a.y - o.y) * (b.x - o.x);
    }

    /*
     * Unable to fully structure code
     */
    protected List<Point> quickHull(List<Point> points) {
        block9: {
            Collections.sort(points, new Comparator<Point>(){

                @Override
                public int compare(Point o1, Point o2) {
                    if (o1.x == o2.x) {
                        return o1.y - o2.y;
                    }
                    return o1.x - o2.x;
                }
            });
            sz = points.size();
            k = 0;
            hull = new ArrayList<Point>();
            if (sz <= 1) break block9;
            i = 0;
            ** GOTO lbl18
            {
                hull.remove(--k);
                do {
                    if (k >= 2 && AbstractPolygonDecorationEditPolicy.cross((Point)hull.get(k - 2), (Point)hull.get(k - 1), points.get(i)) <= 0L) continue block0;
                    if (k < hull.size()) {
                        hull.set(k++, points.get(i));
                    } else {
                        hull.add(k++, points.get(i));
                    }
                    ++i;
lbl18:
                    // 2 sources

                } while (i < sz);
            }
            i = sz - 2;
            t = k + 1;
            ** GOTO lbl32
            {
                hull.remove(--k);
                do {
                    if (k >= t && AbstractPolygonDecorationEditPolicy.cross((Point)hull.get(k - 2), (Point)hull.get(k - 1), points.get(i)) <= 0L) continue block2;
                    if (k < hull.size()) {
                        hull.set(k++, points.get(i));
                    } else {
                        hull.add(k++, points.get(i));
                    }
                    --i;
lbl32:
                    // 2 sources

                } while (i >= 0);
            }
            if (k > 1) {
                hull.remove(k - 1);
            }
            return hull;
        }
        return points;
    }

    public abstract void refresh();

    protected abstract IFigure createPolygon(PointList var1);

    protected void addPolygon(IFigure f) {
        this.polygons.add(f);
    }

    public void activate() {
        RMap ref;
        Object obj2;
        ((DiagramRootEditPart)this.getHost().getViewer().getRootEditPart()).getZoomManager().addZoomListener((ZoomListener)this);
        this.getHost().addEditPartListener(this.editPartListener);
        if (this.semanticListener != null) {
            ((IGraphicalEditPart)this.getHost()).resolveSemanticElement().eAdapters().add((Object)this.semanticListener);
        }
        for (Object obj2 : this.getHost().getChildren()) {
            if (!(obj2 instanceof ContainerEditPart) && !(obj2 instanceof ClauseEditPart)) continue;
            ((IGraphicalEditPart)obj2).getFigure().addFigureListener(this.childMoveListener);
            if (this.semanticListener != null) {
                ((IGraphicalEditPart)obj2).resolveSemanticElement().eAdapters().add((Object)this.semanticListener);
            }
            this.registerSemanticAdapter(((IGraphicalEditPart)obj2).resolveSemanticElement());
        }
        obj2 = ((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        if (obj2 instanceof Map && (ref = (RMap)((Map)obj2).getMapReference()) != null) {
            ref.eAdapters().add((Object)this.refModelAdapter);
        }
        super.activate();
        this.refresh();
    }

    public void deactivate() {
        if (this.refModelAdapter != null && this.refModelAdapter.getTarget() != null) {
            this.refModelAdapter.getTarget().eAdapters().remove((Object)this.refModelAdapter);
        }
        if (this.semanticListener != null && this.semanticListener.getTarget() != null) {
            this.semanticListener.getTarget().eAdapters().remove((Object)this.semanticListener);
        }
        ((DiagramRootEditPart)this.getHost().getViewer().getRootEditPart()).getZoomManager().removeZoomListener((ZoomListener)this);
        this.getHost().removeEditPartListener(this.editPartListener);
        for (Object obj : this.getHost().getChildren()) {
            if (!(obj instanceof ContainerEditPart) && !(obj instanceof ClauseEditPart)) continue;
            ((IGraphicalEditPart)obj).getFigure().removeFigureListener(this.childMoveListener);
            if (this.semanticListener != null) {
                ((IGraphicalEditPart)obj).resolveSemanticElement().eAdapters().remove((Object)this.semanticListener);
            }
            if (!((IGraphicalEditPart)obj).isActive()) continue;
            this.unregisterSemanticAdapter(((IGraphicalEditPart)obj).resolveSemanticElement());
        }
        this.clearFigures();
        super.deactivate();
    }

    protected void clearFigures() {
        for (IFigure f : this.polygons) {
            this.getLayer("customSetLayer").remove(f);
        }
        this.polygons.clear();
    }

    public void zoomChanged(double zoom) {
        this.refresh();
    }

    protected PointList generateCubicBezier(PrecisionPoint start, PrecisionPoint c1, PrecisionPoint c2, PrecisionPoint end) {
        PointList l = new PointList();
        double t = 0.01;
        while (t < 1.0) {
            double x = Math.pow(1.0 - t, 3.0) * start.preciseX() + 3.0 * Math.pow(1.0 - t, 2.0) * t * c1.preciseX() + 3.0 * (1.0 - t) * t * t * c2.preciseX() + Math.pow(t, 3.0) * end.preciseX();
            double y = Math.pow(1.0 - t, 3.0) * start.preciseY() + 3.0 * Math.pow(1.0 - t, 2.0) * t * c1.preciseY() + 3.0 * (1.0 - t) * t * t * c2.preciseY() + Math.pow(t, 3.0) * end.preciseY();
            l.addPoint((Point)new PrecisionPoint(x, y));
            t += 0.1;
        }
        return l;
    }

    protected PrecisionPoint circleInter(Point center, Point pointA, Point pointB) {
        double baX = pointB.x - pointA.x;
        double caX = center.x - pointA.x;
        double baY = pointB.y - pointA.y;
        double caY = center.y - pointA.y;
        double bBy2 = baX * caX + baY * caY;
        double a = baX * baX + baY * baY;
        double pBy2 = bBy2 / a;
        double radius = 45.0;
        double c = caX * caX + caY * caY - radius * radius;
        double q = c / a;
        double disc = pBy2 * pBy2 - q;
        if (disc < 0.0) {
            return null;
        }
        double tmpSqrt = Math.sqrt(disc);
        double abScalingFactor1 = -pBy2 + tmpSqrt;
        double abScalingFactor2 = -pBy2 - tmpSqrt;
        PrecisionPoint p1 = new PrecisionPoint((double)pointA.x - baX * abScalingFactor1, (double)pointA.y - baY * abScalingFactor1);
        if (disc == 0.0) {
            return p1;
        }
        PrecisionPoint p2 = new PrecisionPoint((double)pointA.x - baX * abScalingFactor2, (double)pointA.y - baY * abScalingFactor2);
        LineSeg s = new LineSeg(pointA, pointB);
        if (s.containsPoint((Point)p1, 1)) {
            return p1;
        }
        return p2;
    }

    protected class PointComparator
    implements Comparator<Point> {
        protected Point refPoint;

        public PointComparator(Point refPoint) {
            this.refPoint = refPoint;
        }

        @Override
        public int compare(Point o1, Point o2) {
            double aTanB;
            double aTanA = Math.atan2(o1.y - this.refPoint.y, o1.x - this.refPoint.x);
            if (aTanA < (aTanB = Math.atan2(o2.y - this.refPoint.y, o2.x - this.refPoint.x))) {
                return -1;
            }
            if (aTanB < aTanA) {
                return 1;
            }
            return 0;
        }
    }
}

