/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.edit.parts.ClauseEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.ContainerEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.InheritanceLinkEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.LinkEditPart;
import com.indy.gmf.map.diagram.custom.edit.policies.AbstractPolygonDecorationEditPolicy;
import com.indy.gmf.map.diagram.custom.edit.policies.MappingHighlightingEditPolicy;
import com.indy.gmf.map.diagram.custom.edit.policies.SourceSetDecorationEditPolicy;
import com.indy.gmf.map.diagram.custom.preferences.MapPreferenceConstants;
import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.Join;
import com.indy.map.Map;
import com.indy.map.Operator;
import com.indy.map.diagram.edit.parts.OperatorEditPart;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RSourceSet;
import com.indy.ui.custom.out.Activator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IPolygonAnchorableFigure;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;

public class DataSetDecorationEditPolicy
extends AbstractPolygonDecorationEditPolicy {
    public static final String DATASET_FEEDBACK_ROLE = "dataSet.role";
    private List<IFigure> connections = new ArrayList<IFigure>();
    private HashMap<DataSet, IFigure> dataSetFigureMap = new HashMap();

    private List<Point> getAllPoints(DataSet ds, boolean onlyDataset) {
        ArrayList<Point> l = new ArrayList<Point>();
        for (Object ep : ((IGraphicalEditPart)this.getHost()).getChildren()) {
            if (!(ep instanceof ContainerEditPart) && !(ep instanceof ClauseEditPart) && !(ep instanceof OperatorEditPart)) continue;
            IGraphicalEditPart child = (IGraphicalEditPart)ep;
            EObject model = child.resolveSemanticElement();
            if (!ds.getContainer().contains((Object)model) && !ds.getFilter().contains(model) && !ds.getOperator().contains(model) && !ds.getJoin().contains(model)) continue;
            Rectangle bounds = child.getFigure().getBounds().getCopy();
            child.getFigure().translateToAbsolute((Translatable)bounds);
            int expansion = 15;
            bounds.expand(expansion, expansion);
            if (model instanceof Join && ((Join)model).isInheritance()) {
                if ((((Join)model).getLeft() == null || !ds.getParent().contains((Object)((Join)model).getLeft().getDataset())) && (((Join)model).getRight() == null || !ds.getParent().contains((Object)((Join)model).getRight().getDataset()))) continue;
                l.add(new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2));
                continue;
            }
            if (model instanceof Operator) {
                if (((Operator)model).getFilteredDataSet() != ds) continue;
                l.add(new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2));
                continue;
            }
            l.add(new Point(bounds.x, bounds.y));
            l.add(new Point(bounds.x + bounds.width, bounds.y));
            l.add(new Point(bounds.x + bounds.width, bounds.y + bounds.height));
            l.add(new Point(bounds.x, bounds.y + bounds.height));
        }
        return l;
    }

    @Override
    protected void clearFigures() {
        super.clearFigures();
        this.dataSetFigureMap.clear();
        for (IFigure f : this.connections) {
            this.getLayer("Connection Layer").remove(f);
        }
        this.connections.clear();
    }

    protected boolean isEnabled() {
        return !MapPreferenceConstants.getBoolean("mapShowSourceSet");
    }

    @Override
    public void refresh() {
        this.clearFigures();
        if (!this.isEnabled()) {
            return;
        }
        boolean onlyDataset = !((SourceSetDecorationEditPolicy)this.getHost().getEditPolicy((Object)"sourceSet.role")).isEnabled();
        Map map = (Map)((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        MappingHighlightingEditPolicy policy = (MappingHighlightingEditPolicy)this.getHost().getEditPolicy((Object)"hightlightMappingRole");
        IContainer target = null;
        if (policy != null) {
            target = policy.getSelectedTargetContainer();
        }
        if (map != null) {
            for (DataSet ds : map.getDataSet()) {
                List<Point> pointList;
                if (!this.shouldDrawDataset(onlyDataset, ds) || target != null && target.getDataset() == ds || !policy.isDataSetVisible(ds) || (pointList = this.quickHull(this.getAllPoints(ds, onlyDataset))).isEmpty()) continue;
                PointList pl = new PointList();
                for (Point pt : pointList) {
                    pl.addPoint(pt);
                }
                final Point ref = pl.getBounds().getCenter();
                Collections.sort(pointList, new Comparator<Point>(){

                    @Override
                    public int compare(Point o1, Point o2) {
                        double aTanB;
                        double aTanA = Math.atan2(o1.y - ref.y, o1.x - ref.x);
                        if (aTanA < (aTanB = Math.atan2(o2.y - ref.y, o2.x - ref.x))) {
                            return -1;
                        }
                        if (aTanB < aTanA) {
                            return 1;
                        }
                        return 0;
                    }
                });
                pl = new PointList();
                for (Point pt : pointList) {
                    this.getLayer("customSetLayer").translateToRelative((Translatable)pt);
                    pl.addPoint(pt);
                }
                PointList re = new PointList();
                int i = 0;
                while (i < pl.size()) {
                    Point next = pl.getPoint(i);
                    Point cur = pl.getPoint((i + 1) % pointList.size());
                    Point prev = pl.getPoint((i + 2) % pointList.size());
                    PrecisionPoint prevCircleinter = this.circleInter(cur, cur, next);
                    PrecisionPoint nextCircleinter = this.circleInter(cur, cur, prev);
                    re.addAll(this.generateCubicBezier(new PrecisionPoint((Point)prevCircleinter), new PrecisionPoint(cur), new PrecisionPoint(cur), new PrecisionPoint((Point)nextCircleinter)));
                    ++i;
                }
                IFigure polygon = this.createPolygon(re);
                if (!(ds.getParent().isEmpty() && ds.getChild().isEmpty() || target == null || ((RMap)map.getMapReference()).getTargetSetRef(target).getSourceSet().getDataSet().contains((Object)ds))) {
                    polygon.setVisible(false);
                }
                this.addPolygon(polygon);
                this.dataSetFigureMap.put(ds, polygon);
                this.getLayer("customSetLayer").add(polygon);
            }
        }
        for (Object o : this.getHost().getChildren()) {
            if (!(o instanceof IGraphicalEditPart)) continue;
            ArrayList l = new ArrayList();
            l.addAll(((IGraphicalEditPart)o).getSourceConnections());
            l.addAll(((IGraphicalEditPart)o).getTargetConnections());
            for (Object c : l) {
                if (c instanceof InheritanceLinkEditPart) {
                    ((InheritanceLinkEditPart)((Object)c)).refresh();
                }
                if (!(c instanceof LinkEditPart)) continue;
                ((LinkEditPart)c).refresh();
            }
        }
    }

    private boolean shouldDrawDataset(boolean onlyDataset, DataSet ds) {
        Map map = (Map)ds.eContainer();
        if (!ds.getFilteredBy().isEmpty() || !ds.getFiltering().isEmpty()) {
            return true;
        }
        for (RSourceSet ss : ((RMap)map.getMapReference()).getSourceSetRef()) {
            if (!ss.getDataSet().contains((Object)ds)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected IFigure createPolygon(PointList points) {
        CustomPolygon polygon = new CustomPolygon();
        polygon.setPoints(points);
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.sourceColor");
        polygon.setForegroundColor(Activator.getDefault().getColor(rgb));
        polygon.setBackgroundColor(Activator.getDefault().getColor(rgb));
        polygon.setFill(true);
        polygon.setAlpha(35);
        polygon.setLineWidth(2);
        return polygon;
    }

    protected IFigure createConnection(DataSet sourceDataSet, DataSet targetDataSet) {
        Polygon source = (Polygon)this.dataSetFigureMap.get(sourceDataSet);
        Polygon target = (Polygon)this.dataSetFigureMap.get(targetDataSet);
        Point srcPt = null;
        Point trgPt = null;
        float heurictic = 0.0f;
        int i = 0;
        while (i < source.getPoints().size()) {
            if (srcPt == null) {
                srcPt = source.getPoints().getPoint(i);
            } else {
                float h = Math.abs(trgPt.x - source.getPoints().getPoint((int)i).x) + Math.abs(trgPt.y - source.getPoints().getPoint((int)i).y);
                if (h < heurictic) {
                    heurictic = h;
                    srcPt = source.getPoints().getPoint(i);
                }
            }
            int j = 0;
            while (j < target.getPoints().size()) {
                if (trgPt == null) {
                    trgPt = target.getPoints().getPoint(j);
                } else {
                    float h = Math.abs(srcPt.x - target.getPoints().getPoint((int)j).x) + Math.abs(srcPt.y - target.getPoints().getPoint((int)j).y);
                    if (h < heurictic) {
                        heurictic = h;
                        trgPt = target.getPoints().getPoint(j);
                    }
                }
                ++j;
            }
            ++i;
        }
        PointList pl = new PointList();
        pl.addPoint(srcPt);
        pl.addPoint(trgPt);
        PolylineConnection c = new PolylineConnection();
        c.setPoints(pl);
        c.setForegroundColor(ColorConstants.gray);
        c.setLineWidth(3);
        return c;
    }

    public Polygon getPolygon(DataSet dataset) {
        return (Polygon)this.dataSetFigureMap.get(dataset);
    }

    @Override
    protected Adapter createSemanticAdapter() {
        return null;
    }

    private class CustomPolygon
    extends Polygon
    implements IPolygonAnchorableFigure {
        private CustomPolygon() {
        }

        public ConnectionAnchor getConnectionAnchor(String terminal) {
            return null;
        }

        public String getConnectionAnchorTerminal(ConnectionAnchor c) {
            return null;
        }

        public ConnectionAnchor getSourceConnectionAnchorAt(Point p) {
            return null;
        }

        public ConnectionAnchor getTargetConnectionAnchorAt(Point p) {
            return null;
        }

        public PointList getPolygonPoints() {
            return this.getPoints();
        }
    }
}

