/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.edit.policies.SetEditPolicy;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Query;
import com.indy.map.SetDescriptor;
import com.indy.map.diagram.edit.commands.QueryFieldCreateCommand;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.map.diagram.providers.MapElementTypes;
import com.indy.ui.custom.out.services.IDropValidationService;
import com.stambia.md.MdNode;
import com.stambia.tech.MappingType;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateOrSelectElementCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramDragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.menus.PopupMenu;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;

public class QueryDragDropEditPolicy
extends DiagramDragDropEditPolicy {
    public static final String REQ_CREATE_FIELD_NAME = "request.queryFieldName";
    public static final String REQ_CREATE_FIELD_EXPRESSION = "request.expression";
    public static final String REQ_CREATE_FIELD_SET_DESC = "request.setDescriptor";

    public Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
        CompoundCommand cc = new CompoundCommand();
        Resource semanticResource = this.getHostObject().eResource();
        for (Object obj : dropRequest.getObjects()) {
            if (obj instanceof MdNode) {
                final MdNode mdNode = (MdNode)semanticResource.getResourceSet().getEObject(EcoreUtil.getURI((EObject)((MdNode)obj)), true);
                if (!mdNode.getMappingType().contains(MappingType.STAGING)) continue;
                return new ICommandProxy((ICommand)new AbstractTransactionalCommand(TransactionUtil.getEditingDomain((EObject)this.getHostObject()), Messages.QueryDragDropEditPolicy_4, null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        Query query = (Query)QueryDragDropEditPolicy.this.getHostObject();
                        query.setStagingArea((EObject)mdNode);
                        return CommandResult.newOKCommandResult();
                    }
                });
            }
            if (!(obj instanceof ILogicalField)) continue;
            IDropValidationService service = (IDropValidationService)PlatformUI.getWorkbench().getService(IDropValidationService.class);
            if (!service.validate(((EObject)obj).eContainer(), this.getHostObject(), true).canMap()) {
                return null;
            }
            CreateElementRequest req = new CreateElementRequest(TransactionUtil.getEditingDomain((EObject)this.getHostObject()), this.getHostObject(), MapElementTypes.QueryField_3002);
            req.setParameter(REQ_CREATE_FIELD_NAME, (Object)((ILogicalField)obj).getLabel());
            req.setParameter(REQ_CREATE_FIELD_EXPRESSION, (Object)((ILogicalField)obj).getFullPath());
            IContainer container = (IContainer)this.getHostObject();
            if (container.getSetDescriptor().size() == 1) {
                req.setParameter(REQ_CREATE_FIELD_SET_DESC, container.getSetDescriptor().get(0));
            } else {
                SetDescriptor desc;
                SetEditPolicy policy = (SetEditPolicy)this.getHost().getEditPolicy((Object)"targetRole");
                if (policy != null && (desc = policy.getActiveSetDescriptor()) != null) {
                    req.setParameter(REQ_CREATE_FIELD_SET_DESC, (Object)desc);
                }
            }
            cc.add((Command)new ICommandProxy((ICommand)new QueryFieldCreateCommand(req)));
        }
        if (!cc.isEmpty()) {
            return cc;
        }
        return null;
    }

    private PreferencesHint getDiagramPreferencesHint() {
        return ((GraphicalEditPart)this.getHost()).getDiagramPreferencesHint();
    }

    protected class PromptAndMapFieldCommand
    extends CreateOrSelectElementCommand {
        CreateElementRequest req;
        private Command createCommand;

        public PromptAndMapFieldCommand(CreateElementRequest req) {
            super(Messages.QueryDragDropEditPolicy_3, Display.getCurrent().getActiveShell(), (List)((IContainer)QueryDragDropEditPolicy.this.getHostObject()).getSetDescriptor(), 1);
            this.req = req;
            this.setPopupMenu(new PopupMenu((List)((IContainer)QueryDragDropEditPolicy.this.getHostObject().eContainer()).getSetDescriptor(), this.getLabelProvider()){

                public boolean show(Control parent) {
                    Menu menu = new Menu(parent);
                    this.createMenuItems(menu, this, new ArrayList());
                    menu.setVisible(true);
                    Display display = menu.getDisplay();
                    while (display.readAndDispatch()) {
                    }
                    menu.dispose();
                    return this.getResult() != null;
                }
            });
        }

        protected ILabelProvider getLabelProvider() {
            return new AdapterFactoryLabelProvider(MapDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            CommandResult cmdResult = super.doExecuteWithResult(progressMonitor, info);
            if (!cmdResult.getStatus().isOK()) {
                return cmdResult;
            }
            Object currentSetDescriptor = cmdResult.getReturnValue();
            this.req.setParameter(QueryDragDropEditPolicy.REQ_CREATE_FIELD_SET_DESC, currentSetDescriptor);
            ICommandProxy cmd = new ICommandProxy((ICommand)new QueryFieldCreateCommand(this.req));
            Assert.isTrue((cmd != null && cmd.canExecute() ? 1 : 0) != 0);
            cmd.execute();
            this.createCommand = cmd;
            return CommandResult.newOKCommandResult();
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            if (this.createCommand != null) {
                this.createCommand.undo();
            }
            return super.doUndoWithResult(progressMonitor, info);
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            if (this.createCommand != null) {
                this.createCommand.redo();
            }
            return super.doRedoWithResult(progressMonitor, info);
        }
    }
}

