/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.edit.parts.ContainerEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.DatastoreViewEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.LinkEditPart;
import com.indy.gmf.map.diagram.custom.edit.policies.AbstractPolygonDecorationEditPolicy;
import com.indy.gmf.map.diagram.custom.preferences.MapPreferenceConstants;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Join;
import com.indy.map.Map;
import com.indy.map.SetDescriptor;
import com.indy.map.diagram.edit.parts.FilterEditPart;
import com.indy.map.diagram.edit.parts.JoinEditPart;
import com.indy.map.diagram.notation.mappingNotation.NodeView;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RLogicalField;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RSourceSet;
import com.indy.map.util.SourceSetHelper;
import com.indy.ui.custom.out.Activator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;

public class SourceSetDecorationEditPolicy
extends AbstractPolygonDecorationEditPolicy {
    public static final String SOURCESET_FEEDBACK_ROLE = "sourceSet.role";
    private static final int ALPHA = 35;
    private WeakReference<IContainer> currentTargetContainer = null;
    private HashMap<SourceSetHelper.SubSourceSet, Polygon> polygons = new HashMap();
    private WeakHashMap<IGraphicalEditPart, Integer> offsetCount = new WeakHashMap();

    private Set<Point> getAllPoints(Collection<IGraphicalEditPart> curEpList, Set<Point> allPoints) {
        HashSet<Point> l = new HashSet<Point>();
        for (IGraphicalEditPart child : curEpList) {
            Rectangle bounds = child.getFigure().getBounds().getCopy();
            child.getFigure().translateToAbsolute((Translatable)bounds);
            Integer factor = this.offsetCount.get(child);
            if (child instanceof JoinEditPart && ((Join)((JoinEditPart)child).resolveSemanticElement()).isInheritance()) {
                bounds.expand(15, 15);
                l.add(new Point(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2));
                continue;
            }
            bounds.expand(15 * factor, 15 * factor);
            l.add(new Point(bounds.x, bounds.y));
            l.add(new Point(bounds.x + bounds.width, bounds.y));
            l.add(new Point(bounds.x + bounds.width, bounds.y + bounds.height));
            l.add(new Point(bounds.x, bounds.y + bounds.height));
        }
        allPoints.addAll(l);
        return l;
    }

    @Override
    protected void clearFigures() {
        this.polygons.clear();
        this.offsetCount.clear();
        super.clearFigures();
    }

    @Override
    public void deactivate() {
        this.polygons.clear();
        this.offsetCount.clear();
        super.deactivate();
    }

    protected boolean isEnabled() {
        return MapPreferenceConstants.getBoolean("mapShowSourceSet");
    }

    @Override
    public void refresh() {
        IContainer c;
        if (!this.getHost().isActive()) {
            return;
        }
        this.clearFigures();
        if (!this.isEnabled()) {
            return;
        }
        Map map = (Map)((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        HashMap<SourceSetHelper.SubSourceSet, Set> subsetEditPartsMap = new HashMap<SourceSetHelper.SubSourceSet, Set>();
        HashMap<Set<Point>, IFigure> basePointsSet = new HashMap<Set<Point>, IFigure>();
        HashSet<Point> ALL_POINTS = new HashSet<Point>();
        for (RSourceSet ds : ((RMap)map.getMapReference()).getSourceSetRef()) {
            for (SourceSetHelper.SubSourceSet sss : SourceSetHelper.computeSubSourceSets((RSourceSet)ds)) {
                Set setEp = this.findEditParts(sss);
                boolean listEpFound = false;
                for (Set s : subsetEditPartsMap.values()) {
                    if (!s.equals(setEp)) continue;
                    setEp = s;
                    subsetEditPartsMap.put(sss, setEp);
                    listEpFound = true;
                    break;
                }
                if (!listEpFound) {
                    subsetEditPartsMap.put(sss, setEp);
                    for (IGraphicalEditPart ep : setEp) {
                        if (this.offsetCount.get(ep) == null) {
                            this.offsetCount.put(ep, 1);
                            continue;
                        }
                        this.offsetCount.put(ep, this.offsetCount.get(ep) + 1);
                    }
                }
                Set<Point> points = this.getAllPoints(setEp, ALL_POINTS);
                IFigure polygon = null;
                boolean polyExists = false;
                if (listEpFound) {
                    polyExists = basePointsSet.keySet().contains(points);
                }
                if (!polyExists) {
                    List<Point> pointList = this.quickHull(new ArrayList<Point>(points));
                    PointList pl = new PointList();
                    for (Point pt : pointList) {
                        Point p = pt.getCopy();
                        this.getLayer("customSetLayer").translateToRelative((Translatable)p);
                        pl.addPoint(p);
                    }
                    final Point ref = pl.getBounds().getCenter();
                    Collections.sort(pointList, new Comparator<Point>(){

                        @Override
                        public int compare(Point o1, Point o2) {
                            double aTanB;
                            double aTanA = Math.atan2(o1.y - ref.y, o1.x - ref.x);
                            if (aTanA < (aTanB = Math.atan2(o2.y - ref.y, o2.x - ref.x))) {
                                return -1;
                            }
                            if (aTanB < aTanA) {
                                return 1;
                            }
                            return 0;
                        }
                    });
                    PointList re = new PointList();
                    int i = 0;
                    while (i < pl.size()) {
                        Point next = pl.getPoint(i);
                        Point cur = pl.getPoint((i + 1) % pointList.size());
                        Point prev = pl.getPoint((i + 2) % pointList.size());
                        PrecisionPoint prevCircleinter = this.circleInter(cur, cur, next);
                        PrecisionPoint nextCircleinter = this.circleInter(cur, cur, prev);
                        re.addAll(this.generateCubicBezier(new PrecisionPoint((Point)prevCircleinter), new PrecisionPoint(cur), new PrecisionPoint(cur), new PrecisionPoint((Point)nextCircleinter)));
                        ++i;
                    }
                    polygon = this.createPolygon(re);
                    this.addPolygon(polygon);
                    basePointsSet.put(points, polygon);
                    this.polygons.put(sss, (Polygon)polygon);
                    this.getLayer("customSetLayer").add(polygon);
                    continue;
                }
                polygon = (IFigure)basePointsSet.get(points);
                this.polygons.put(sss, (Polygon)polygon);
            }
        }
        if (this.currentTargetContainer != null && (c = (IContainer)this.currentTargetContainer.get()) != null) {
            HashSet<IFigure> visiblePolygon = new HashSet<IFigure>();
            for (SourceSetHelper.SubSourceSet s : this.polygons.keySet()) {
                if (!s.getSourceSet().getTargetSet().getContainerModel().contains(c)) continue;
                visiblePolygon.add((IFigure)this.polygons.get(s));
            }
            for (Polygon p : this.polygons.values()) {
                if (visiblePolygon.contains(p)) continue;
                p.setVisible(false);
            }
        }
        for (Object o : this.getHost().getChildren()) {
            if (!(o instanceof IGraphicalEditPart)) continue;
            ArrayList l = new ArrayList();
            l.addAll(((IGraphicalEditPart)o).getTargetConnections());
            for (Object c2 : l) {
                if (!(c2 instanceof LinkEditPart) || !"targetSetLink".equals(((LinkEditPart)c2).getNotationView().getType())) continue;
                ((LinkEditPart)c2).refresh();
            }
        }
    }

    private Set<IGraphicalEditPart> findEditParts(SourceSetHelper.SubSourceSet sourceSet) {
        HashSet<ILogicalField> targetSourceFields = null;
        HashSet<IGraphicalEditPart> curEpList = new HashSet<IGraphicalEditPart>();
        for (Object ep : ((IGraphicalEditPart)this.getHost()).getChildren()) {
            if (!(ep instanceof ContainerEditPart) && !(ep instanceof JoinEditPart) && !(ep instanceof FilterEditPart)) continue;
            IGraphicalEditPart child = (IGraphicalEditPart)ep;
            EObject semObject = child.resolveSemanticElement();
            if (!sourceSet.getContainers().contains(semObject) && !sourceSet.getClause().contains(semObject)) continue;
            if (child instanceof DatastoreViewEditPart) {
                if (targetSourceFields == null) {
                    targetSourceFields = new HashSet<ILogicalField>();
                    for (IContainer c : sourceSet.getSourceSet().getTargetSet().getContainerModel()) {
                        for (ILogicalField f : c.getLogicalField()) {
                            if (!f.isMapped()) continue;
                            for (Expression ex : f.getExpression()) {
                                for (RSourceItem i : ((RExpression)ex.getMapReference()).getSourceRef()) {
                                    if (!(i instanceof RLogicalField)) continue;
                                    targetSourceFields.add((ILogicalField)i.getDataModel());
                                }
                            }
                        }
                    }
                }
                NodeView view = (NodeView)child.getModel();
                ILogicalField obj = (ILogicalField)view.getSubElement();
                boolean necessary = false;
                for (ILogicalField f : targetSourceFields) {
                    ArrayList<Field> subsetHierachy = new ArrayList<Field>();
                    Field _current = f instanceof Field ? (Field)f : null;
                    while (_current != null) {
                        subsetHierachy.add(_current);
                        _current = _current.getParent();
                    }
                    if (!subsetHierachy.contains(obj)) continue;
                    necessary = true;
                    break;
                }
                if (!necessary) continue;
            }
            curEpList.add(child);
        }
        return curEpList;
    }

    private PointList generateBezier(Point prev, Point cur, Point next) {
        PointList l = new PointList();
        double t = 0.01;
        while (t < 1.0) {
            double x = (1.0 - t) * ((1.0 - t) * (double)prev.x + t * (double)cur.x) + t * ((1.0 - t) * (double)cur.x + t * (double)next.x);
            double y = (1.0 - t) * ((1.0 - t) * (double)prev.y + t * (double)cur.y) + t * ((1.0 - t) * (double)cur.y + t * (double)next.y);
            l.addPoint((Point)new PrecisionPoint(x, y));
            t += 0.1;
        }
        return l;
    }

    @Override
    protected IFigure createPolygon(PointList points) {
        Polygon polygon = new Polygon();
        polygon.setPoints(points);
        RGB color = PreferenceConverter.getColor((IPreferenceStore)MapDiagramEditorPlugin.getInstance().getPreferenceStore(), (String)"Appearance.sourceColor");
        polygon.setForegroundColor(Activator.getDefault().getColor(color));
        polygon.setBackgroundColor(Activator.getDefault().getColor(color));
        polygon.setAlpha(35);
        polygon.setFill(true);
        polygon.setLineWidth(2);
        return polygon;
    }

    @Override
    protected Adapter createSemanticAdapter() {
        return null;
    }

    public void setCurrentSourceSet(IContainer currentTargetContainer) {
        this.currentTargetContainer = new WeakReference<IContainer>(currentTargetContainer);
        this.refresh();
    }

    public Polygon getPolygon(RSourceSet rs, SetDescriptor desc) {
        for (SourceSetHelper.SubSourceSet sss : this.polygons.keySet()) {
            if (sss.getDesc() != desc || sss.getSourceSet() != rs) continue;
            return this.polygons.get(sss);
        }
        return null;
    }
}

