/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.custom.actions.AutomaticMap;
import com.indy.gmf.map.diagram.custom.edit.parts.LogicalFieldEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.util.ActiveSetDescriptorHelper;
import com.indy.gmf.map.diagram.custom.edit.policies.AbstractFieldDndEditPolicy;
import com.indy.gmf.map.diagram.custom.edit.policies.DragBlenderEditPolicy;
import com.indy.gmf.map.diagram.custom.edit.policies.FieldDragDropEditPolicy;
import com.indy.gmf.map.diagram.custom.edit.policies.MappingHighlightingEditPolicy;
import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.Datastore;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Inliner;
import com.indy.map.InputParameter;
import com.indy.map.Map;
import com.indy.map.MapFactory;
import com.indy.map.MapLocation;
import com.indy.map.MapPackage;
import com.indy.map.SetDescriptor;
import com.indy.map.Variable;
import com.indy.map.diagram.edit.commands.SetDescriptorCreateCommand;
import com.indy.map.diagram.providers.MapElementTypes;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RLogicalField;
import com.indy.map.ref.RSourceItem;
import com.indy.ui.custom.out.services.IDropValidationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.ui.PlatformUI;

public class TargetFieldDropEditPolicy
extends FieldDragDropEditPolicy {
    private static final String REQ_EXPRESSION_MAPPING = "request.expression.mapping";
    private static final String EXT_EXPRESSION = "request.expression";
    private static final String EXT_TRGFIELD = "request.targetField";
    private static final String EXT_EXPRESSION_VALUE = "request.expression.expression";
    private static final String EXT_SETDESCRIPTOR = "request.setDescriptor";
    private static final String EXT_DROPEDOBJECT = "request.dropedObject";
    public static final String TARGET_DRAG_DROP_ROLE = "targetFieldDrop.role";
    private Command sourceFeedbackCommand = null;

    protected SetDescriptor getCurrentSetDescriptor() {
        return ActiveSetDescriptorHelper.getActiveSetDescriptor((LogicalFieldEditPart)this.getHost());
    }

    @Override
    public Command getDropObjectsCommand(DropObjectsRequest request) {
        if (request.getObjects() != null && !request.getObjects().isEmpty() && (request.getObjects().get(0) instanceof Variable || request.getObjects().get(0) instanceof InputParameter)) {
            request.getExtendedData().put("request.dropType", IDropValidationService.DropResult.MAP_ALLOWED);
            this.eraseTargetFeedback((Request)request);
            this.showTargetFeedback((Request)request);
            return this.createMappingCommand(request);
        }
        return super.getDropObjectsCommand(request);
    }

    protected Request createMappingRequest(ILogicalField trgObject, Object dragObject, SetDescriptor currentSetDescriptor) {
        Expression expression = null;
        for (Expression exp : trgObject.getExpression()) {
            if (exp.getSetDescriptorRef() != currentSetDescriptor) continue;
            expression = exp;
            break;
        }
        String oldValue = null;
        if (expression != null) {
            oldValue = expression.getExpression();
        }
        Object addValue = "";
        if (dragObject instanceof ILogicalField) {
            addValue = ((ILogicalField)dragObject).getFullPath();
        } else if (dragObject instanceof Variable) {
            srcObject = (Variable)dragObject;
            addValue = "%{" + srcObject.getAlias().toString() + "}%";
        } else if (dragObject instanceof InputParameter) {
            srcObject = (InputParameter)dragObject;
            addValue = "%{" + srcObject.getName().toString() + "}%";
        }
        Object newValue = null;
        newValue = oldValue != null && !oldValue.trim().equals("") ? oldValue + " + " + (String)addValue : addValue;
        Request mappingRequest = new Request((Object)REQ_EXPRESSION_MAPPING);
        mappingRequest.getExtendedData().put(EXT_EXPRESSION, expression);
        mappingRequest.getExtendedData().put(EXT_TRGFIELD, trgObject);
        mappingRequest.getExtendedData().put(EXT_DROPEDOBJECT, dragObject);
        mappingRequest.getExtendedData().put(EXT_SETDESCRIPTOR, currentSetDescriptor);
        mappingRequest.getExtendedData().put(EXT_EXPRESSION_VALUE, newValue);
        return mappingRequest;
    }

    private Command getMappingCommand(Object dragObject, SetDescriptor currentSetDescriptor, boolean isAuto) {
        ILogicalField trgObject = (ILogicalField)this.getHostObject();
        Request mappingRequest = this.createMappingRequest(trgObject, dragObject, currentSetDescriptor);
        if (isAuto && dragObject instanceof ILogicalField) {
            boolean mapped = false;
            block0: for (ILogicalField f : ((IContainer)trgObject.eContainer()).getLogicalField()) {
                Expression exp = f.getExpression(currentSetDescriptor);
                if (exp == null) continue;
                for (RSourceItem i : ((RExpression)exp.getMapReference()).getSourceRef()) {
                    ILogicalField lcoalField;
                    if (!(i instanceof RLogicalField) || (lcoalField = (ILogicalField)i.getDataModel()).eContainer() != ((ILogicalField)dragObject).eContainer()) continue;
                    mapped = true;
                    continue block0;
                }
            }
            if (!mapped) {
                CompoundCommand cc = new CompoundCommand();
                cc.add(this.getCommand(mappingRequest));
                cc.add((Command)new ICommandProxy((ICommand)new AutomaticMap.AutomappingCommand(Collections.singletonList(currentSetDescriptor), this.getHost().getViewer().getEditDomain(), (IContainer)((ILogicalField)dragObject).eContainer(), (IContainer)trgObject.eContainer(), dragObject instanceof ILogicalField ? (ILogicalField)dragObject : null)));
                return cc;
            }
        }
        return this.getCommand(mappingRequest);
    }

    public boolean understandsRequest(Request request) {
        if (REQ_EXPRESSION_MAPPING.equals(request.getType())) {
            return true;
        }
        return super.understandsRequest(request);
    }

    public Command getCommand(Request request) {
        if (REQ_EXPRESSION_MAPPING.equals(request.getType())) {
            return this.createMappingExpressionCommand(request);
        }
        return super.getCommand(request);
    }

    protected Command createMappingExpressionCommand(final Request req) {
        CompoundCommand cc = new CompoundCommand();
        cc.add((Command)new ICommandProxy((ICommand)new AbstractTransactionalCommand(TransactionUtil.getEditingDomain(req.getExtendedData().get(EXT_TRGFIELD)), Messages.TargetFieldDropEditPolicy_15, null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Expression expression = (Expression)req.getExtendedData().get(TargetFieldDropEditPolicy.EXT_EXPRESSION);
                ILogicalField trgObject = (ILogicalField)req.getExtendedData().get(TargetFieldDropEditPolicy.EXT_TRGFIELD);
                String newValue = (String)req.getExtendedData().get(TargetFieldDropEditPolicy.EXT_EXPRESSION_VALUE);
                SetDescriptor currentSetDescriptor = (SetDescriptor)req.getExtendedData().get(TargetFieldDropEditPolicy.EXT_SETDESCRIPTOR);
                if (currentSetDescriptor == null) {
                    if (((IContainer)trgObject.eContainer()).getSetDescriptor().size() != 1) {
                        throw new ExecutionException(Messages.TargetFieldDropEditPolicy_16);
                    }
                    currentSetDescriptor = (SetDescriptor)((IContainer)trgObject.eContainer()).getSetDescriptor().get(0);
                    req.getExtendedData().put(TargetFieldDropEditPolicy.EXT_SETDESCRIPTOR, currentSetDescriptor);
                }
                if (expression == null && (expression = trgObject.getExpression(currentSetDescriptor)) == null) {
                    expression = MapFactory.eINSTANCE.createExpression();
                    if (trgObject.eContainer() instanceof Inliner) {
                        expression.setLocation(MapLocation.WRK);
                    }
                    expression.setSetDescriptorRef(currentSetDescriptor);
                    trgObject.getExpression().add((Object)expression);
                }
                expression.setExpression(newValue);
                TargetFieldDropEditPolicy.this.getHost().getViewer().getControl().getDisplay().asyncExec(() -> ((IGraphicalEditPart)TargetFieldDropEditPolicy.this.getHost()).refresh());
                return CommandResult.newOKCommandResult((Object)expression);
            }
        }));
        return cc;
    }

    @Override
    protected Command createMappingCommand(DropObjectsRequest request) {
        CompoundCommand cc = new CompoundCommand();
        Object dragObject = request.getObjects().get(0);
        ILogicalField field = (ILogicalField)this.getHostObject();
        if (field instanceof Field && !this.fieldCanBeTarget((Field)field)) {
            return UnexecutableCommand.INSTANCE;
        }
        AbstractFieldDndEditPolicy.CmdKind cmdKind = (AbstractFieldDndEditPolicy.CmdKind)((Object)request.getExtendedData().get("dropRequest.commandKind"));
        if (this.getCurrentSetDescriptor() != null) {
            cc.add(this.getMappingCommand(dragObject, this.getCurrentSetDescriptor(), cmdKind == AbstractFieldDndEditPolicy.CmdKind.MAP_AUTO));
        } else {
            IContainer container = (IContainer)field.eContainer();
            if (container.getSetDescriptor().isEmpty()) {
                CreateElementRequest r = null;
                if (container instanceof Datastore) {
                    r = new CreateElementRequest(TransactionUtil.getEditingDomain((EObject)container), (EObject)container, MapElementTypes.SetDescriptor_3001, MapPackage.eINSTANCE.getDatastore_SetDescriptor());
                    cc.add((Command)new ICommandProxy((ICommand)new SetDescriptorCreateCommand(r)));
                } else {
                    r = new CreateElementRequest(TransactionUtil.getEditingDomain((EObject)container), (EObject)container, MapElementTypes.SetDescriptor_3007, MapPackage.eINSTANCE.getQuery_SetDescriptor());
                    cc.add((Command)new ICommandProxy((ICommand)new SetDescriptorCreateCommand(r)));
                }
                cc.add(this.getMappingCommand(dragObject, (SetDescriptor)r.getNewElement(), cmdKind == AbstractFieldDndEditPolicy.CmdKind.MAP_AUTO));
            } else if (container.getSetDescriptor().size() == 1) {
                cc.add(this.getMappingCommand(dragObject, (SetDescriptor)container.getSetDescriptor().get(0), cmdKind == AbstractFieldDndEditPolicy.CmdKind.MAP_AUTO));
            }
        }
        if (!cc.isEmpty()) {
            return cc;
        }
        return null;
    }

    @Override
    protected Command getDragCommand(ChangeBoundsRequest request) {
        this.showSourceFeedback((Request)request);
        return super.getDragCommand(request);
    }

    public void eraseSourceFeedback(Request request) {
        if (request instanceof ChangeBoundsRequest && this.sourceFeedbackCommand != null && this.sourceFeedbackCommand.canUndo()) {
            this.sourceFeedbackCommand.undo();
            this.sourceFeedbackCommand = null;
        }
        super.eraseSourceFeedback(request);
    }

    public void showSourceFeedback(Request request) {
        if (request instanceof ChangeBoundsRequest && this.sourceFeedbackCommand == null) {
            IContainer c = (IContainer)this.getHostObject().eContainer();
            Map map = (Map)c.eContainer();
            MappingHighlightingEditPolicy policy = (MappingHighlightingEditPolicy)((IGraphicalEditPart)this.getHost()).findEditPart((EditPart)this.getHost().getRoot(), (EObject)map).getEditPolicy((Object)"hightlightMappingRole");
            IContainer highlightenContainer = policy == null ? null : policy.getSelectedTargetContainer();
            IDropValidationService service = (IDropValidationService)PlatformUI.getWorkbench().getService(IDropValidationService.class);
            if (service != null) {
                ArrayList<IContainer> l = new ArrayList<IContainer>();
                HashMap<IContainer, IDropValidationService.DropResult> m = new HashMap<IContainer, IDropValidationService.DropResult>();
                for (IContainer t : map.getContainer()) {
                    if (t == c) continue;
                    IDropValidationService.DropResult res = service.validate((EObject)c, (EObject)t, true);
                    if (res == IDropValidationService.DropResult.NONE) {
                        l.add(t);
                        continue;
                    }
                    m.put(t, res);
                }
                if (!l.isEmpty() || !m.isEmpty()) {
                    EditPart mapPart = ((IGraphicalEditPart)this.getHost()).findEditPart((EditPart)this.getHost().getRoot(), (EObject)map);
                    CompoundCommand cc = new CompoundCommand();
                    cc.add(mapPart.getCommand((Request)new DragBlenderEditPolicy.BlendRequest(l, true)));
                    for (Map.Entry e : m.entrySet()) {
                        if (highlightenContainer != null && !policy.isDataSetVisible(((IContainer)e.getKey()).getDataset())) continue;
                        cc.add(mapPart.getCommand((Request)new DragBlenderEditPolicy.BorderRequest((IContainer)e.getKey(), (IDropValidationService.DropResult)e.getValue())));
                    }
                    if (cc != null && cc.canExecute()) {
                        this.sourceFeedbackCommand = cc;
                        cc.execute();
                    }
                }
            }
        }
        super.showSourceFeedback(request);
    }
}

