/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies.tools;

import com.indy.gmf.map.diagram.custom.edit.parts.ClauseEditPart;
import com.indy.gmf.map.diagram.custom.edit.parts.ContainerEditPart;
import com.indy.gmf.map.diagram.custom.edit.policies.tools.IToolDescriptor;
import com.indy.gmf.map.diagram.custom.edit.policies.tools.ToolHandle;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.zoom.ZoomListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;

public abstract class AbstractToolEditPolicy
extends SelectionEditPolicy
implements ZoomListener {
    public static final String ROLE_TOOL_EDITION = "role.toolQuickEdit";
    private List<ToolHandle> handles = new ArrayList<ToolHandle>();
    private IFigure toolContainer;
    private Adapter semanticAdapter = null;
    protected boolean centerAdjustNeeded = false;
    private FigureListener moveListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            AbstractToolEditPolicy.this.relocateFigure();
        }
    };

    protected Adapter createSemanticAdapter() {
        return new AdapterImpl(){

            public void notifyChanged(Notification msg) {
            }
        };
    }

    protected void fillToolHandles(List<IToolDescriptor> desc) {
        for (IToolDescriptor d : desc) {
            ToolHandle h = new ToolHandle((IGraphicalEditPart)this.getHost(), d);
            this.handles.add(h);
            this.toolContainer.add(h.getFigure());
            h.setVisible(h.getDescriptor().isEnabled());
            h.getFigure().setVisible(h.getDescriptor().isEnabled());
        }
    }

    protected IGraphicalEditPart getContainerEditPart() {
        GraphicalEditPart ep = this.getHost();
        while (ep != null && !(ep instanceof ContainerEditPart) && !(ep instanceof ClauseEditPart)) {
            ep = ep.getParent();
        }
        return (IGraphicalEditPart)ep;
    }

    public abstract List<IToolDescriptor> getDescriptors();

    protected void createFigure() {
        Figure f = new Figure();
        ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout(false);
        layout.setMinorAlignment(1);
        layout.setStretchMajorAxis(false);
        layout.setStretchMinorAxis(true);
        f.setLayoutManager((LayoutManager)layout);
        this.toolContainer = f;
        this.customizeContainerFigure((IFigure)f);
        this.toolContainer.setVisible(false);
        this.fillToolHandles(this.getDescriptors());
        this.getLayer("Primary Layer").add(this.toolContainer);
        this.relocateFigure();
    }

    protected void customizeContainerFigure(IFigure f) {
    }

    protected void relocateFigure() {
        if (this.toolContainer == null) {
            return;
        }
        double zoom = ((DiagramRootEditPart)this.getHost().getViewer().getRootEditPart()).getZoomManager().getZoom();
        IFigure containerFigure = this.getContainerEditPart().getFigure();
        Rectangle boundsHost = containerFigure.getBounds().getCopy();
        containerFigure.translateToAbsolute((Translatable)boundsHost);
        PrecisionRectangle bounds = new PrecisionRectangle((double)boundsHost.x - 16.0 * zoom, (double)boundsHost.y, 16.0 * zoom, (double)boundsHost.height);
        Dimension prefSize = this.toolContainer.getPreferredSize(-1, -1).getCopy();
        this.toolContainer.translateToAbsolute((Translatable)prefSize);
        if (!bounds.getSize().contains(prefSize)) {
            Dimension shrinked = prefSize.getShrinked(bounds.getSize());
            if (((ConstrainedToolbarLayout)this.toolContainer.getLayoutManager()).getMinorAlignment() == 0) {
                bounds.expand(0.0, (double)shrinked.height / 2.0);
            } else {
                bounds.height += shrinked.height;
            }
        }
        bounds.expand(1.0 * zoom, 1.0 * zoom);
        if (this.centerAdjustNeeded) {
            Rectangle hostBounds = this.getSelectionBoundaries();
            this.getHostFigure().translateToAbsolute((Translatable)hostBounds);
            double newY = (double)hostBounds.getCenter().y - (double)bounds.height / 2.0;
            bounds.setPreciseY(newY);
        }
        this.getLayer("Primary Layer").translateToRelative((Translatable)bounds);
        this.toolContainer.setBounds((Rectangle)bounds);
    }

    protected Rectangle getSelectionBoundaries() {
        return this.getHostFigure().getBounds().getCopy();
    }

    protected void destroyFigure() {
        if (this.toolContainer != null) {
            IFigure f = this.getLayer("Primary Layer");
            if (f != null && this.toolContainer.getParent() == f) {
                f.remove(this.toolContainer);
            }
            this.toolContainer = null;
            for (ToolHandle h : this.getHandles()) {
                if (h.getParent() == null) continue;
                this.getLayer("Handle Layer").remove((IFigure)h);
            }
        }
        this.getHandles().clear();
    }

    public void activate() {
        EObject obj = ((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        if (obj != null) {
            if (this.semanticAdapter == null) {
                this.semanticAdapter = this.createSemanticAdapter();
            }
            obj.eAdapters().add((Object)this.semanticAdapter);
        }
        this.createFigure();
        this.getContainerEditPart().getFigure().addFigureListener(this.moveListener);
        ((DiagramRootEditPart)this.getHost().getViewer().getRootEditPart()).getZoomManager().addZoomListener((ZoomListener)this);
        super.activate();
    }

    public void deactivate() {
        try {
            if (this.semanticAdapter.getTarget() != null) {
                this.semanticAdapter.getTarget().eAdapters().remove((Object)this.semanticAdapter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.destroyFigure();
        ((DiagramRootEditPart)this.getHost().getViewer().getRootEditPart()).getZoomManager().removeZoomListener((ZoomListener)this);
        this.getContainerEditPart().getFigure().removeFigureListener(this.moveListener);
        super.deactivate();
    }

    public void zoomChanged(double zoom) {
        this.relocateFigure();
    }

    protected void hideSelection() {
        for (ToolHandle t : this.getHandles()) {
            if (t.getParent() == null) continue;
            this.getLayer("Handle Layer").remove((IFigure)t);
        }
        if (this.getToolContainerFigure() != null) {
            this.getToolContainerFigure().setVisible(false);
        }
    }

    protected void showSelection() {
        this.getToolContainerFigure().setVisible(true);
        this.relocateFigure();
        for (ToolHandle t : this.getHandles()) {
            this.getLayer("Handle Layer").add((IFigure)t);
            t.setVisible(t.getDescriptor().isEnabled());
            t.getFigure().setVisible(t.getDescriptor().isEnabled());
        }
    }

    protected List<ToolHandle> getHandles() {
        return this.handles;
    }

    protected final IFigure getToolContainerFigure() {
        return this.toolContainer;
    }
}

