/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies.tools;

import com.indy.gmf.map.diagram.custom.edit.policies.tools.IFeatureToolDescriptor;
import com.indy.gmf.map.diagram.custom.edit.policies.tools.SetValueDelegateDragTracker;
import com.indy.gmf.map.diagram.custom.edit.policies.tools.ToolHandle;
import com.indy.gmf.map.edit.provider.custom.MapEditUtil;
import com.indy.map.MapLocation;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.swt.graphics.Image;

public class MultiValuatedToolDragTracker
extends DragEditPartsTrackerEx {
    private boolean menuExpanded = false;
    private List<IFeatureToolDescriptor.ValuatedFeatureToolDescriptor> descriptors;
    private IFigure menuFigure;
    protected WeakReference<IFigure> triggerFigure;
    private WeakReference<Layer> layer;
    private WeakReference<Layer> figureLayer;
    private List<ToolHandle> handles = new ArrayList<ToolHandle>();

    public MultiValuatedToolDragTracker(EditPart sourceEditPart, Layer handleLayer, Layer figureLayer, IFigure triggerFigure, List<IFeatureToolDescriptor.ValuatedFeatureToolDescriptor> descriptors) {
        super(sourceEditPart);
        this.descriptors = descriptors;
        triggerFigure.addFigureListener(new FigureListener(){

            public void figureMoved(IFigure source) {
                MultiValuatedToolDragTracker.this.relocate();
            }
        });
        this.triggerFigure = new WeakReference<IFigure>(triggerFigure);
        this.layer = new WeakReference<Layer>(handleLayer);
        this.figureLayer = new WeakReference<Layer>(figureLayer);
        this.createMenu();
    }

    protected ToolHandle createMenuHandle(IFeatureToolDescriptor.ValuatedFeatureToolDescriptor d) {
        return new CustomizedToolHandle((IGraphicalEditPart)this.getSourceEditPart(), d, d.getValue());
    }

    private void createMenu() {
        Figure f = new Figure();
        ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout(false);
        layout.setMinorAlignment(1);
        layout.setStretchMajorAxis(false);
        layout.setSpacing(1);
        layout.setStretchMinorAxis(false);
        f.setLayoutManager((LayoutManager)layout);
        for (IFeatureToolDescriptor.ValuatedFeatureToolDescriptor d : this.descriptors) {
            ToolHandle h = this.createMenuHandle(d);
            f.add(h.getFigure());
            this.handles.add(h);
        }
        this.menuFigure = f;
        f.setVisible(false);
        Layer layer = (Layer)this.figureLayer.get();
        if (layer != null) {
            layer.add(this.menuFigure);
        }
    }

    protected void relocate() {
        IFigure f = (IFigure)this.triggerFigure.get();
        if (f == null) {
            return;
        }
        Point pt = f.getBounds().getLocation().getCopy();
        f.translateToAbsolute((Translatable)pt);
        Dimension d = this.menuFigure.getPreferredSize(-1, -1).getCopy();
        this.menuFigure.translateToAbsolute((Translatable)d);
        pt.x -= d.width;
        pt.y -= d.height / this.descriptors.size();
        Rectangle r = new Rectangle(pt, d);
        IFigure root = (IFigure)this.figureLayer.get();
        root.translateToRelative((Translatable)r);
        this.menuFigure.setBounds(r);
    }

    protected boolean handleButtonUp(int button) {
        if (this.isInState(2)) {
            this.performDrag();
            this.setState(0x40000000);
            return true;
        }
        return super.handleButtonUp(button);
    }

    protected boolean handleButtonDown(int button) {
        if (button == 1) {
            this.stateTransition(1, 2);
            return true;
        }
        return super.handleButtonDown(button);
    }

    protected void performDrag() {
        this.menuExpanded = !this.menuExpanded;
        this.menuFigure.setVisible(this.menuExpanded);
        Layer layer = (Layer)this.figureLayer.get();
        Layer layer2 = (Layer)this.layer.get();
        if (this.menuExpanded) {
            layer.add(this.menuFigure);
            for (ToolHandle h : this.handles) {
                layer2.add((IFigure)h);
            }
        } else {
            layer.remove(this.menuFigure);
            for (ToolHandle h : this.handles) {
                if (h.getParent() == null) continue;
                layer2.remove((IFigure)h);
            }
        }
        this.relocate();
    }

    protected Command getCurrentCommand() {
        return null;
    }

    public IFigure getMenuFigure() {
        return this.menuFigure;
    }

    public void release() {
        Layer layer = (Layer)this.figureLayer.get();
        if (this.menuFigure != null && layer != null && this.menuFigure.getParent() == layer) {
            layer.remove(this.menuFigure);
        }
        Layer layer2 = (Layer)this.layer.get();
        for (ToolHandle h : this.handles) {
            if (h.getParent() == null) continue;
            layer2.remove((IFigure)h);
        }
        this.menuExpanded = false;
    }

    class CustomizedToolHandle
    extends ToolHandle {
        public CustomizedToolHandle(IGraphicalEditPart gep, IFeatureToolDescriptor descriptor, Object value) {
            super(gep, descriptor);
        }

        @Override
        protected DragTracker createDragTracker() {
            return new SetValueDelegateDragTracker(MultiValuatedToolDragTracker.this.getSourceEditPart(), (IFeatureToolDescriptor)this.getDescriptor(), ((IFeatureToolDescriptor.ValuatedFeatureToolDescriptor)this.getDescriptor()).getValue()){

                protected void executeCurrentCommand() {
                    super.executeCurrentCommand();
                    Image locationImage = null;
                    if (this.value != null) {
                        switch ((MapLocation)this.value) {
                            case SRC: {
                                locationImage = ExtendedImageRegistry.getInstance().getImage(MapEditUtil.getImage((String)"full/obj16x16/LocationSource16x16.png"));
                                break;
                            }
                            case WRK: {
                                locationImage = ExtendedImageRegistry.getInstance().getImage(MapEditUtil.getImage((String)"full/obj16x16/LocationWork16x16.png"));
                                break;
                            }
                            case TRG: {
                                locationImage = ExtendedImageRegistry.getInstance().getImage(MapEditUtil.getImage((String)"full/obj16x16/LocationTarget16x16.png"));
                            }
                        }
                    }
                    ((ToolHandle)((Object)((CustomizedToolHandle)CustomizedToolHandle.this).MultiValuatedToolDragTracker.this.triggerFigure.get())).setImage(locationImage);
                }
            };
        }

        protected void updateImage(Object value) {
        }
    }
}

